/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore.api.accessor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import moddedmite.rustedironcore.api.accessor.TargetIsNotStaticException;
import moddedmite.rustedironcore.api.accessor.TargetIsStaticException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Accessor {
    private static final Logger logger = LogManager.getLogger((String)"Accessor");

    private Accessor() {
        try {
            throw new Throwable("\u4f60\u600e\u4e48\u56de\u4e8b\uff0c\u4e3a\u4ec0\u4e48\u8981\u521b\u5efaAccessor\u7684\u5b9e\u4f8b\uff1f");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, Y> T modify(@Nonnull Field field, @Nonnull T t, @Nonnull Y y) {
        try {
            if (Modifier.isFinal(field.getModifiers())) {
                Field declaredField = Field.class.getDeclaredField("modifiers");
                declaredField.setAccessible(true);
                declaredField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            field.setAccessible(true);
            field.set(y, t);
            return (T)field.get(t);
        }
        catch (ClassCastException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e2) {
            throw new RuntimeException("Accessor\uff1a\u8f93\u5165\u7684\u503c" + String.valueOf(t) + "\u65e0\u6548", e2);
        }
        catch (NoSuchFieldException e3) {
            throw new RuntimeException("Accessor\uff1a\u627e\u4e0d\u5230" + field.getName(), e3);
        }
    }

    public static <T> T modifyStatic(@Nonnull Field field, @Nonnull T t) {
        try {
            Field declaredField = Field.class.getDeclaredField("modifiers");
            declaredField.setAccessible(true);
            declaredField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
            field.set(null, t);
            return (T)field.get(t);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e2) {
            throw new RuntimeException("Accessor\uff1a\u8f93\u5165\u7684\u503c" + String.valueOf(t) + "\u65e0\u6548", e2);
        }
    }

    public static <T, Y> Y access(@Nonnull Field field, @Nonnull T t) throws TargetIsStaticException {
        if (!Modifier.isStatic(field.getModifiers())) {
            try {
                field.setAccessible(true);
                return (Y)field.get(t);
            }
            catch (ClassCastException | IllegalAccessException | SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e2) {
                throw new RuntimeException("Accessor\uff1a\u4f60\u6700\u597d\u4e0d\u662f\u4e71\u8f93\u7684" + String.valueOf(t), e2);
            }
        }
        throw new TargetIsStaticException("Accessor\uff1a\u6210\u5458" + field.getName() + "\u662f\u975e\u9759\u6001\u7684\uff0c\u4e0d\u80fd\u4ee5\u9759\u6001\u5f62\u5f0f\u8bbf\u95ee\uff01");
    }

    public static <T> T accessStatic(@Nonnull Field field) throws TargetIsNotStaticException {
        if (Modifier.isStatic(field.getModifiers())) {
            try {
                field.setAccessible(true);
                return (T)field.get(null);
            }
            catch (ClassCastException | IllegalAccessException | IllegalArgumentException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        throw new TargetIsNotStaticException("Accessor\uff1a\u6210\u5458" + field.getName() + "\u4e0d\u662f\u9759\u6001\u7684\uff01");
    }

    public static <T> T createInstance(@Nonnull Class<T> clazz, Object ... args) {
        try {
            Class[] parameterTypes = new Class[args.length];
            int i = 0;
            for (Object object : args) {
                parameterTypes[i] = object.getClass();
                ++i;
            }
            Constructor<T> constructor = clazz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e2) {
            throw new RuntimeException("Accessor\uff1a\u4f60\u8981\u4e0d\u68c0\u67e5\u68c0\u67e5\u4f60\u4f20\u5165\u7684\u53c2\u6570\uff1f\u6216\u8005\u4f7f\u7528\u53e6\u4e00\u4e2acreateInstant()\uff1f", e2);
        }
    }

    public static <T> T createInstance(@Nonnull Class<T> clazz, @Nonnull Class[] types, @Nonnull Object[] args) {
        try {
            if (types.length != args.length) {
                throw new IllegalArgumentException("Accessor\uff1a\u53c2\u6570\u7c7b\u578b\u6570\u91cf\u548c\u53c2\u6570\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
            }
            Constructor<T> constructor = clazz.getDeclaredConstructor(types);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Accessor\uff1a\u5feb\u53bb\u544a\u8bc9\u9508\u94c1\u952d\u4ed6Accessor\u6709\u95ee\u9898", e);
        }
        catch (InstantiationException | InvocationTargetException e2) {
            throw new RuntimeException(e2);
        }
        catch (NoSuchMethodException e3) {
            throw new RuntimeException("Accessor\uff1a\u4f60\u8981\u4e0d\u68c0\u67e5\u68c0\u67e5\u4f60\u4f20\u5165\u7684\u53c2\u6570\u7c7b\u578b\uff1f", e3);
        }
    }

    public static <T, Y> Y invoke(@Nonnull Method method, @Nonnull T t, Object ... objArr) throws TargetIsStaticException {
        if (!Modifier.isStatic(method.getModifiers()) || t == null) {
            try {
                method.setAccessible(true);
                return (Y)method.invoke(t, objArr);
            }
            catch (IllegalAccessException | NullPointerException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new TargetIsStaticException("Accessor\uff1a\u4e0d\u80fd\u4ee5\u9759\u6001\u65b9\u5f0f\u8bbf\u95ee\u975e\u9759\u6001\u65b9\u6cd5" + method.getName());
    }

    public static <T> T invokeStatic(@Nonnull Method method, Object ... objArr) throws TargetIsNotStaticException {
        if (Modifier.isStatic(method.getModifiers())) {
            try {
                method.setAccessible(true);
                return (T)method.invoke(null, objArr);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NullPointerException e2) {
                throw new RuntimeException("Accessor\uff1a\u9700\u8981\u5b9e\u4f8b\uff01", e2);
            }
        }
        throw new TargetIsNotStaticException("Accessor\uff1a\u65b9\u6cd5" + method.getName() + "\u4e0d\u662f\u9759\u6001\u7684\uff01");
    }

    public static <T> Class<T> accessClass(@Nonnull String str) {
        try {
            return Class.forName(str);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Accessor\uff1a\u8981\u4e0d\u518d\u8003\u8651\u6e05\u695a\uff1f", e);
        }
    }

    public static <T, Y> Class<Y> accessInnerClass(@Nonnull Class<T> cls, @Nonnull String str) {
        try {
            return Class.forName(cls.getName() + "$" + str);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

