/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.rustedironcore;

import java.util.Optional;
import moddedmite.rustedironcore.api.event.Handlers;
import moddedmite.rustedironcore.api.util.FabricUtil;
import moddedmite.rustedironcore.api.util.StringUtil;
import moddedmite.rustedironcore.internal.config.RICConfig;
import moddedmite.rustedironcore.internal.event.listeners.BiomeListener;
import moddedmite.rustedironcore.internal.event.listeners.CommandRegistry;
import moddedmite.rustedironcore.internal.event.listeners.DimensionRegistry;
import moddedmite.rustedironcore.internal.event.listeners.PlayerEventListener;
import moddedmite.rustedironcore.internal.event.listeners.TickListener;
import moddedmite.rustedironcore.internal.network.Packets;
import moddedmite.rustedironcore.internal.network.packets.S2COpenGuiTips;
import moddedmite.rustedironcore.network.Network;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.minecraft.Minecraft;
import net.minecraft.Packet;
import net.xiaoyu233.fml.config.ConfigRegistry;

public class RustedIronCore
implements ModInitializer {
    public static final String MOD_NAME = "RustedIronCore";

    public Optional<ConfigRegistry> createConfig() {
        return Optional.of(new ConfigRegistry(RICConfig.ROOT, RICConfig.CONFIG_FILE));
    }

    public void onInitialize() {
        if (!FabricUtil.isServer()) {
            this.initClient();
        }
        this.initServer();
        this.registerVanillaEvents();
    }

    private void initClient() {
        Network.initClient(packet -> Minecraft.getMinecraft().getNetHandler().addToSendQueue((Packet)packet.toVanilla()));
        Packets.registerClientReaders();
    }

    private void initServer() {
        Network.initServer((serverPlayer, packet) -> serverPlayer.playerNetServerHandler.sendPacketToPlayer((Packet)packet.toVanilla()));
        Packets.registerServerReaders();
    }

    private void registerVanillaEvents() {
        Handlers.PlayerEvent.register(new PlayerEventListener());
        Handlers.Tick.register(new TickListener());
        Handlers.BiomeGenerate.register(new BiomeListener());
        if (((Boolean)RICConfig.UseCustomDimension.get()).booleanValue()) {
            Handlers.Dimension.register(new DimensionRegistry());
            Handlers.Command.register(new CommandRegistry());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean shouldRenderStatement() {
        if (S2COpenGuiTips.firstLoginStatementCounter == 0) {
            return false;
        }
        if (!StringUtil.getCurrentLanguage().equals("zh_CN")) {
            return false;
        }
        if (FabricUtil.isDevelopmentEnvironment()) {
            return false;
        }
        return (Boolean)RICConfig.StatementOnLogin.get() != false;
    }
}

