/*
 * Decompiled with CFR 0.152.
 */
package huix.glacier.util;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Identifier
implements Comparable<Identifier> {
    protected final String namespace;
    protected final String path;

    private Identifier(String ... pathParts) {
        this.namespace = StringUtils.isEmpty((CharSequence)pathParts[0]) ? "minecraft" : pathParts[0].toLowerCase(Locale.ROOT);
        this.path = pathParts[1].toLowerCase(Locale.ROOT);
        Validate.notNull((Object)this.path);
    }

    public Identifier(String name) {
        this(Identifier.parseString(name));
    }

    public Identifier(Object object) {
        this(object.toString());
    }

    public Identifier(String namespace, String path) {
        this(new String[]{namespace, path});
    }

    protected static String[] parseString(String path) {
        String[] strings = new String[]{"minecraft", path};
        int i = path.indexOf(58);
        if (i >= 0) {
            strings[1] = path.substring(i + 1);
            if (i > 1) {
                strings[0] = path.substring(0, i);
            }
        }
        return strings;
    }

    public String getPath() {
        return this.path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String toString() {
        return this.namespace + ":" + this.path;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Identifier)) {
            return false;
        }
        Identifier identifier = (Identifier)object;
        return this.namespace.equals(identifier.namespace) && this.path.equals(identifier.path);
    }

    public int hashCode() {
        return 31 * this.namespace.hashCode() + this.path.hashCode();
    }

    @Override
    public int compareTo(Identifier identifier) {
        int i = this.namespace.compareTo(identifier.namespace);
        if (i == 0) {
            i = this.path.compareTo(identifier.path);
        }
        return i;
    }
}

