/*
 * Decompiled with CFR 0.152.
 */
package huix.glacier.mixin.util;

import java.io.File;
import java.io.FileWriter;
import net.minecraft.Item;
import net.minecraft.ItemCudgel;
import net.minecraft.ItemTool;
import net.minecraft.Material;
import net.minecraft.ReferenceFileWriter;
import net.minecraft.StringHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ReferenceFileWriter.class})
public class ReferenceFileWriterMixin {
    @Shadow
    private static String newline;

    @Overwrite
    private static void writeItemReachFile(File dir) throws Exception {
        FileWriter fw = new FileWriter(dir.getPath() + "/item_reach.txt");
        StringBuilder sb = new StringBuilder();
        sb.append("The player has a base reach of " + StringHelper.formatFloat((float)2.75f, (int)1, (int)2) + " vs blocks and " + StringHelper.formatFloat((float)1.5f, (int)1, (int)2) + " vs entities." + newline + newline);
        sb.append("Only items that have a reach bonus are listed." + newline + newline);
        sb.append("Reach Bonus" + newline);
        sb.append("-----------" + newline);
        for (int i = 0; i < Item.itemsList.length; ++i) {
            float var7;
            Item item = Item.getItem((int)i);
            if (item == null) continue;
            String name = item.getNameForReferenceFile();
            if (item instanceof ItemTool) {
                ItemTool reach_bonus = (ItemTool)item;
                if (reach_bonus.getToolMaterial() != Material.iron && !(reach_bonus instanceof ItemCudgel)) continue;
                name = reach_bonus.getToolMaterial().name;
            }
            if (!((var7 = item.getReachBonus()) > 0.0f)) continue;
            sb.append("Item[").append(i).append("] ");
            sb.append(name).append(": +").append(StringHelper.formatFloat((float)var7, (int)1, (int)3));
            sb.append(newline);
        }
        fw.write(sb.toString());
        fw.close();
    }
}

