/*
 * Decompiled with CFR 0.152.
 */
package huix.glacier.mixin;

import huix.glacier.api.registry.sync.ServerRegistryRemapper;
import huix.glacier.util.GlacierLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.CompressedStreamTools;
import net.minecraft.NBTTagCompound;
import net.minecraft.SaveHandler;
import net.minecraft.WorldInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SaveHandler.class})
public class SaveHandlerMixin {
    @Unique
    private NBTTagCompound fabric_lastSavedIdMap = null;
    @Unique
    private static final int FABRIC_ID_REGISTRY_BACKUPS = 3;
    @Shadow
    @Final
    private File worldDirectory;

    @Unique
    private boolean fabric_readIdMapFile(File file) throws IOException {
        if (file.exists()) {
            NBTTagCompound nbt;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                nbt = CompressedStreamTools.readCompressed((InputStream)fileInputStream);
            }
            if (nbt != null) {
                ServerRegistryRemapper.getInstance().readAndRemap(nbt);
                return true;
            }
        }
        return false;
    }

    @Unique
    private File fabric_getWorldIdMapFile(int i) {
        return new File(new File(this.worldDirectory, "data"), "fabricRegistry.dat" + (String)(i == 0 ? "" : "." + i));
    }

    @Unique
    private void fabric_saveRegistryData() {
        NBTTagCompound newIdMap = ServerRegistryRemapper.getInstance().toNbtCompound();
        if (!newIdMap.equals((Object)this.fabric_lastSavedIdMap)) {
            for (int i = 2; i >= 0; --i) {
                File file = this.fabric_getWorldIdMapFile(i);
                if (!file.exists()) continue;
                if (i == 2) {
                    file.delete();
                    continue;
                }
                File target = this.fabric_getWorldIdMapFile(i + 1);
                file.renameTo(target);
            }
            try {
                File file = this.fabric_getWorldIdMapFile(0);
                File parentFile = file.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    GlacierLog.warn("[legacy-fabric-registry-sync-api-v1] Could not create directory " + String.valueOf(parentFile) + "!");
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                CompressedStreamTools.writeCompressed((NBTTagCompound)newIdMap, (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (IOException e) {
                GlacierLog.warn("[legacy-fabric-registry-sync-api-v1] Failed to save registry file!", e);
            }
            this.fabric_lastSavedIdMap = newIdMap;
        }
    }

    @Inject(method={"saveWorldInfoWithPlayer"}, at={@At(value="HEAD")})
    public void saveWorld(WorldInfo par1WorldInfo, NBTTagCompound par2NBTTagCompound, CallbackInfo ci) {
        if (!this.worldDirectory.exists()) {
            return;
        }
        this.fabric_saveRegistryData();
    }

    @Inject(method={"loadWorldInfo"}, at={@At(value="HEAD")})
    public void readWorldProperties(CallbackInfoReturnable<WorldInfo> cir) {
        for (int i = 0; i < 3; ++i) {
            GlacierLog.trace("[glacier-registry-api] Loading Glacier registry [file " + (i + 1) + "/4]");
            try {
                if (!this.fabric_readIdMapFile(this.fabric_getWorldIdMapFile(i))) continue;
                GlacierLog.info("[glacier-registry-api] Loaded registry data [file " + (i + 1) + "/4]");
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
            catch (IOException e) {
                if (i >= 2) {
                    throw new RuntimeException(e);
                }
                GlacierLog.warn("Reading registry file failed!", e);
                continue;
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Remapping world failed!", e);
            }
        }
        this.fabric_saveRegistryData();
    }
}

