/*
 * Decompiled with CFR 0.152.
 */
package huix.glacier.api.registry.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import huix.glacier.api.registry.sync.compat.IdListCompat;
import huix.glacier.api.registry.sync.compat.SimpleRegistryCompat;
import huix.glacier.api.registry.util.IdList;
import huix.glacier.api.registry.util.RegistryEventsHolder;
import huix.glacier.util.GlacierLog;
import huix.glacier.util.Identifier;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class VanillaLikeRegistry<K, V>
implements SimpleRegistryCompat<K, V> {
    private static final GlacierLog LOGGER = GlacierLog.instance;
    protected final Map<K, V> map = this.createMap();
    protected IdList<V> ids = new IdList();
    protected final Map<V, K> objects = ((BiMap)this.map).inverse();
    private RegistryEventsHolder<V> registryEventsHolder;

    public void put(K key, V value) {
        Validate.notNull(key);
        Validate.notNull(value);
        if (this.map.containsKey(this.toKeyType(key))) {
            GlacierLog.debug("Adding duplicate key '{}' to registry", this.toKeyType(key));
        }
        this.map.put(this.toKeyType(key), value);
    }

    protected Map<K, V> createMap() {
        return HashBiMap.create();
    }

    @Override
    public Iterator<V> iterator() {
        return this.ids.iterator();
    }

    @Override
    public IdListCompat<V> getIds() {
        return this.ids;
    }

    @Override
    public Map<V, K> getObjects() {
        return this.objects;
    }

    @Override
    public void setIds(IdListCompat<V> idList) {
        this.ids = (IdList)idList;
    }

    @Override
    public IdListCompat<V> createIdList() {
        return new IdList();
    }

    @Override
    public int getRawID(V object) {
        return this.ids.getId(object);
    }

    @Override
    public K getKey(Object id) {
        return this.objects.get(id);
    }

    @Override
    public V getValue(Object key) {
        return this.map.get(this.toKeyType(key));
    }

    @Override
    public V register(int id, Object identifier, V object) {
        this.ids.set(object, id);
        this.put(this.toKeyType(identifier), object);
        this.getEventHolder().getAddEvent().invoker().onEntryAdded(id, new Identifier(identifier), object);
        return object;
    }

    @Override
    public RegistryEventsHolder<V> getEventHolder() {
        return this.registryEventsHolder;
    }

    @Override
    public void setEventHolder(RegistryEventsHolder<V> registryEventsHolder) {
        this.registryEventsHolder = registryEventsHolder;
    }
}

