/*
 * Decompiled with CFR 0.152.
 */
package huix.glacier.api.registry.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import huix.glacier.api.registry.sync.compat.SimpleRegistryCompat;
import huix.glacier.api.registry.util.RegistryEventsHolder;

public abstract class OldRemappedRegistry<K, V>
implements SimpleRegistryCompat<K, V> {
    private final BiMap<K, K> oldToNewKeyMap = this.generateOldToNewKeyMap();
    private final BiMap<Integer, K> idToKeyMap = this.generateIdToKeyMap();
    private RegistryEventsHolder<V> registryEventsHolder;

    public void remapDefaultIds() {
    }

    public BiMap<K, K> generateOldToNewKeyMap() {
        return HashBiMap.create();
    }

    public BiMap<Integer, K> generateIdToKeyMap() {
        return HashBiMap.create();
    }

    public K getNewKey(K oldKey) {
        return (K)this.oldToNewKeyMap.getOrDefault(oldKey, oldKey);
    }

    public K getOldKey(K newKey) {
        return (K)this.oldToNewKeyMap.inverse().getOrDefault(newKey, newKey);
    }

    public K getNewKey(int oldId) {
        return (K)this.idToKeyMap.getOrDefault((Object)oldId, null);
    }

    public int getOldId(K newKey) {
        return (Integer)this.idToKeyMap.inverse().getOrDefault(newKey, (Object)-1);
    }

    @Override
    public RegistryEventsHolder<V> getEventHolder() {
        return this.registryEventsHolder;
    }

    @Override
    public void setEventHolder(RegistryEventsHolder<V> registryEventsHolder) {
        this.registryEventsHolder = registryEventsHolder;
    }
}

