/*
 * Decompiled with CFR 0.152.
 */
package huix.glacier.api.registry.util;

import com.google.common.collect.BiMap;
import huix.glacier.api.registry.sync.compat.IdListCompat;
import huix.glacier.api.registry.util.IdList;
import huix.glacier.api.registry.util.OldRemappedRegistry;
import huix.glacier.util.Identifier;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ArrayAndMapBasedRegistry<K, V>
extends OldRemappedRegistry<K, V> {
    private V[] valueArray;
    private final Map<K, V> defaultMap;
    private final Map<V, K> invertedMap;
    private IdListCompat<V> IDLIST = new IdList<V>();
    private boolean init = false;

    public ArrayAndMapBasedRegistry(V[] valueArray, BiMap<K, V> defaultMap) {
        this.valueArray = (Object[])Array.newInstance(valueArray.getClass().getComponentType(), valueArray.length + 1);
        Arrays.fill(this.valueArray, null);
        this.defaultMap = defaultMap;
        this.invertedMap = ((BiMap)this.defaultMap).inverse();
        this.initRegistry(valueArray);
        this.init = true;
        this.syncArrayWithIdList();
    }

    public void initRegistry(V[] originalValueArray) {
        for (int i = 0; i < originalValueArray.length; ++i) {
            V value = originalValueArray[i];
            K key = this.invertedMap.remove(value);
            if (value == null) continue;
            K newKey = this.getNewKey(key);
            this.register(i, newKey, value);
        }
    }

    @Override
    public IdListCompat<V> getIds() {
        return this.IDLIST;
    }

    @Override
    public Map<V, K> getObjects() {
        return this.invertedMap;
    }

    @Override
    public void setIds(IdListCompat<V> idList) {
        this.IDLIST = idList;
    }

    @Override
    public IdListCompat<V> createIdList() {
        return new IdList();
    }

    @Override
    public int getRawID(V object) {
        return this.IDLIST.getInt(object);
    }

    @Override
    public K getKey(V object) {
        return this.invertedMap.get(object);
    }

    @Override
    public V getValue(Object key) {
        return this.defaultMap.get(this.toKeyType(key));
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return this.IDLIST.iterator();
    }

    @Override
    public V register(int i, Object key, V value) {
        this.defaultMap.put(this.toKeyType(key), value);
        this.IDLIST.setValue(value, i);
        if (this.init) {
            this.syncArrayWithIdList();
            this.getEventHolder().getAddEvent().invoker().onEntryAdded(i, new Identifier(key), value);
        }
        return value;
    }

    public void updateArrayLength(int i) {
        while (i >= this.valueArray.length) {
            this.valueArray = Arrays.copyOf(this.valueArray, this.valueArray.length * 2);
        }
        this.updateArray();
    }

    public void syncArrayWithIdList() {
        Arrays.fill(this.valueArray, null);
        this.updateArrayLength(this.IDLIST.getIdMap(this).size() + 1);
        for (Map.Entry<V, Integer> entry : this.IDLIST.getIdMap(this).entrySet()) {
            this.valueArray[entry.getValue().intValue()] = entry.getKey();
        }
        this.updateArray();
    }

    public V[] getArray() {
        return this.valueArray;
    }

    public abstract void updateArray();
}

