/*
 * Decompiled with CFR 0.152.
 */
package huix.glacier.api.registry.sync.remappers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import huix.glacier.api.registry.sync.RegistryHelper;
import huix.glacier.api.registry.sync.RegistryHelperImpl;
import huix.glacier.api.registry.sync.compat.IdListCompat;
import huix.glacier.api.registry.sync.compat.SimpleRegistryCompat;
import huix.glacier.api.registry.sync.remappers.RegistryRemapperRegistryRemapper;
import huix.glacier.api.registry.util.ArrayBasedRegistry;
import huix.glacier.api.registry.util.RegistryEventsHolder;
import huix.glacier.util.GlacierLog;
import huix.glacier.util.Identifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import net.minecraft.NBTTagCompound;

public class RegistryRemapper<V> {
    protected static final GlacierLog LOGGER = GlacierLog.instance;
    protected final SimpleRegistryCompat<?, V> registry;
    protected BiMap<Identifier, Integer> entryDump;
    protected BiMap<Identifier, Integer> missingMap = HashBiMap.create();
    public final Identifier registryId;
    public final String type;
    public final String nbtName;
    public static final Map<SimpleRegistryCompat<?, ?>, RegistryRemapper<?>> REGISTRY_REMAPPER_MAP = new HashMap();
    public static final Map<Identifier, RegistryRemapper<?>> REMAPPER_MAP = new HashMap();
    public static RegistryRemapper<RegistryRemapper<?>> DEFAULT_CLIENT_INSTANCE = null;
    private static final Map<Identifier, RegistryEventsHolder<?>> IDENTIFIER_EVENT_MAP = new HashMap();

    public RegistryRemapper(SimpleRegistryCompat<?, V> registry, Identifier registryId, String type, String nbtName) {
        this.registry = registry;
        this.registryId = registryId;
        this.type = type;
        this.nbtName = nbtName;
        if (this instanceof RegistryRemapperRegistryRemapper && DEFAULT_CLIENT_INSTANCE == null) {
            DEFAULT_CLIENT_INSTANCE = this;
        }
        if (IDENTIFIER_EVENT_MAP.containsKey(this.registryId)) {
            this.registry.setEventHolder(IDENTIFIER_EVENT_MAP.get(this.registryId));
        } else {
            this.registry.setEventHolder(new RegistryEventsHolder());
        }
        if (RegistryHelper.IDENTIFIER_EVENT_MAP.containsKey(registryId)) {
            RegistryHelper.IDENTIFIER_EVENT_MAP.remove(registryId).invoker();
        }
    }

    public void dump() {
        this.entryDump = HashBiMap.create();
        GlacierLog.debug("Dumping registry %s.", this.registryId);
        RegistryHelperImpl.getIdMap(this.registry).forEach((value, id) -> {
            Object key = RegistryHelperImpl.getObjects(this.registry).get(value);
            GlacierLog.debug("%s %s %d %s", this.type, key, id, value);
            if (key != null) {
                this.entryDump.put((Object)new Identifier(key), id);
            }
        });
        for (Map.Entry entry : this.missingMap.entrySet()) {
            if (!this.entryDump.containsValue(entry.getValue())) {
                this.entryDump.put((Object)((Identifier)entry.getKey()), (Object)((Integer)entry.getValue()));
                continue;
            }
            GlacierLog.warn("Tried to add missing entry %s at index %d, but it is already taken by %s", entry.getKey(), entry.getValue(), this.entryDump.inverse().get(entry.getValue()));
        }
    }

    public NBTTagCompound toNbt() {
        if (this.entryDump == null) {
            this.dump();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        this.entryDump.forEach((key, value) -> nbt.setInteger(key.toString(), value.intValue()));
        return nbt;
    }

    public void readNbt(NBTTagCompound tag) {
        this.entryDump = HashBiMap.create();
        for (Object key : tag.tagMap.keySet()) {
            Identifier identifier = new Identifier(key);
            int id = tag.getInteger((String)key);
            this.entryDump.put((Object)identifier, (Object)id);
        }
    }

    private IdListCompat<V> getExistingFromDump() {
        IdListCompat<V> newList = this.registry.createIdList();
        this.entryDump.forEach((id, rawId) -> {
            Object value = RegistryHelperImpl.getObjects(this.registry).inverse().get(this.registry.toKeyType(id));
            if (value == null) {
                newList.setValue(null, (int)rawId);
                GlacierLog.warn("%s with id %s is missing!", this.type, id.toString());
                this.missingMap.put(id, rawId);
            } else {
                newList.setValue((V)value, (int)rawId);
            }
        });
        return newList;
    }

    private void addNewEntries(IdListCompat<V> newList, IntSupplier currentSize, IntSupplier previousSize) {
        GlacierLog.info("Adding " + (previousSize.getAsInt() - currentSize.getAsInt()) + " missing entries to registry");
        RegistryHelperImpl.getObjects(this.registry).keySet().stream().filter(obj -> newList.getInt(obj) == -1).collect(Collectors.toList()).forEach(missingValue -> {
            int newId = RegistryHelperImpl.nextId(newList, this.registry, this.missingMap);
            newList.setValue(missingValue, newId);
            GlacierLog.info("Adding %s %s with numerical id %d to registry", this.type, this.registry.getKey(missingValue), newId);
        });
    }

    private void invokeRemapListeners(IdListCompat<V> newList) {
        for (Object value : newList) {
            int oldId = this.registry.getIds().getInt(value);
            int newId = newList.getInt(value);
            if (oldId == -1 || oldId == newId) continue;
            GlacierLog.info("Remapped %s %s from id %d to id %d", this.type, this.registry.getKey(value), oldId, newId);
            this.registry.getEventHolder().getRemapEvent().invoker().onEntryAdded(oldId, newId, new Identifier(this.registry.getKey(value)), value);
        }
    }

    private void updateRegistry(IdListCompat<V> newList) {
        this.registry.setIds(newList);
        if (this.registry instanceof ArrayBasedRegistry) {
            ((ArrayBasedRegistry)this.registry).syncArrayWithIdList();
        }
    }

    private IntSupplier normalizeRegistryEntryList(IdListCompat<V> newList) {
        IntSupplier currentSize = () -> RegistryHelperImpl.getIdMap(newList, this.registry).size();
        IntSupplier previousSize = () -> RegistryHelperImpl.getObjects(this.registry).size();
        if (currentSize.getAsInt() > previousSize.getAsInt()) {
            if (this.missingMap.isEmpty()) {
                throw new IllegalStateException("Registry size increased from " + previousSize.getAsInt() + " to " + currentSize.getAsInt() + " after remapping! This is not possible!");
            }
        } else if (currentSize.getAsInt() < previousSize.getAsInt()) {
            this.addNewEntries(newList, currentSize, previousSize);
        }
        if (currentSize.getAsInt() != previousSize.getAsInt() && this.missingMap.isEmpty()) {
            throw new IllegalStateException("An error occured during remapping");
        }
        return previousSize;
    }

    public void remap() {
        GlacierLog.info("Remapping registry %s", this.registryId.toString());
        if (this.entryDump == null || this.entryDump.isEmpty()) {
            this.dump();
        }
        IdListCompat<V> newList = this.getExistingFromDump();
        IntSupplier previousSize = this.normalizeRegistryEntryList(newList);
        this.invokeRemapListeners(newList);
        this.updateRegistry(newList);
        this.dump();
        GlacierLog.info("Remapped " + previousSize.getAsInt() + " entries");
    }

    public static <K, V> RegistryRemapper<V> getRegistryRemapper(SimpleRegistryCompat<K, V> simpleRegistry) {
        return REGISTRY_REMAPPER_MAP.getOrDefault(simpleRegistry, null);
    }

    public static <V> RegistryRemapper<V> getRegistryRemapper(Identifier identifier) {
        RegistryRemapper remapper = REMAPPER_MAP.getOrDefault(identifier, null);
        return remapper == null ? DEFAULT_CLIENT_INSTANCE : remapper;
    }

    public static <V> RegistryEventsHolder<V> getEventsHolder(Identifier identifier) {
        RegistryEventsHolder<Object> event;
        RegistryRemapper remapper = REMAPPER_MAP.getOrDefault(identifier, null);
        if (remapper == null) {
            if (IDENTIFIER_EVENT_MAP.containsKey(identifier)) {
                event = IDENTIFIER_EVENT_MAP.get(identifier);
            } else {
                event = new RegistryEventsHolder();
                IDENTIFIER_EVENT_MAP.put(identifier, event);
            }
        } else {
            event = remapper.getRegistry().getEventHolder();
        }
        return event;
    }

    public void addMissing(Identifier key, int id) {
        this.missingMap.put((Object)key, (Object)id);
    }

    public V register(int i, Object key, V value) {
        return this.registry.register(i, key, value);
    }

    public SimpleRegistryCompat<?, V> getRegistry() {
        return this.registry;
    }

    public Object toKeyType(Object id) {
        return this.registry.toKeyType(id);
    }

    public Identifier getIdentifier(V object) {
        return new Identifier(this.registry.getKey(object).toString());
    }

    public int getMinId() {
        return 0;
    }
}

