/*
 * Decompiled with CFR 0.152.
 */
package huix.glacier.api.registry.sync;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import huix.glacier.api.registry.RegistryIds;
import huix.glacier.api.registry.sync.ClientRegistryRemapper;
import huix.glacier.api.registry.sync.RegistryHelper;
import huix.glacier.api.registry.sync.ServerRegistryRemapper;
import huix.glacier.api.registry.sync.compat.IdListCompat;
import huix.glacier.api.registry.sync.compat.RegistriesGetter;
import huix.glacier.api.registry.sync.compat.SimpleRegistryCompat;
import huix.glacier.api.registry.sync.remappers.RegistryRemapper;
import huix.glacier.api.registry.util.ArrayAndMapBasedRegistry;
import huix.glacier.api.registry.util.NumericalIdPair;
import huix.glacier.util.Identifier;
import java.util.IdentityHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.minecraft.Block;
import net.minecraft.Item;
import net.xiaoyu233.fml.FishModLoader;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class RegistryHelperImpl {
    public static RegistriesGetter registriesGetter = null;

    public static <T> int register(T object, Identifier id, Identifier registryId) {
        RegistryRemapper<T> remapper = RegistryRemapper.getRegistryRemapper(registryId);
        int rawId = RegistryHelperImpl.nextId(remapper.getRegistry());
        remapper.register(rawId, id, object);
        return rawId;
    }

    public static <T> T register(RegistryHelper.EntryCreator<T> entryCreator, Identifier id, Identifier registryId) {
        return (T)RegistryHelperImpl.register(entryCreator, id, registryId, instance -> {});
    }

    public static <T> T register(RegistryHelper.EntryCreator<T> entryCreator, Identifier id, Identifier registryId, Consumer<T> beforeRegistration) {
        RegistryRemapper<T> remapper = RegistryRemapper.getRegistryRemapper(registryId);
        SimpleRegistryCompat registry = remapper.getRegistry();
        int rawId = RegistryHelperImpl.nextId(registry);
        if (registry instanceof ArrayAndMapBasedRegistry) {
            ((ArrayAndMapBasedRegistry)registry).updateArrayLength(rawId);
        }
        T instance = entryCreator.create(rawId);
        beforeRegistration.accept(instance);
        remapper.register(rawId, id, instance);
        return instance;
    }

    public static Block registerBlock(Block block, Identifier id) {
        block.setUnlocalizedName(RegistryHelperImpl.formatTranslationKey(id));
        int rawId = RegistryHelperImpl.register(block, id, RegistryIds.BLOCKS);
        return block;
    }

    public static Item registerItem(Item item, Identifier id) {
        item.setUnlocalizedName(RegistryHelperImpl.formatTranslationKey(id));
        RegistryHelperImpl.register(item, id, RegistryIds.ITEMS);
        return item;
    }

    public static <V> V getValue(Identifier id, Identifier registryId) {
        RegistryRemapper registryRemapper = RegistryRemapper.getRegistryRemapper(registryId);
        return registryRemapper.getRegistry().getValue(id);
    }

    public static RegistryRemapper<?> registerRegistryRemapper(RegistryRemapper<RegistryRemapper<?>> registryRemapperRegistryRemapper, RegistryRemapper<?> registryRemapper) {
        int rawId = RegistryHelperImpl.nextId(registryRemapperRegistryRemapper.getRegistry());
        registryRemapperRegistryRemapper.register(rawId, registryRemapper.registryId, registryRemapper);
        return registryRemapper;
    }

    public static void registerRegistryRemapper(Supplier<RegistryRemapper<?>> remapperSupplier) {
        if (FishModLoader.getEnvironmentType() == EnvType.CLIENT) {
            ClientRegistryRemapper.getInstance().registrerRegistryRemapper(remapperSupplier.get());
        }
        ServerRegistryRemapper.getInstance().registrerRegistryRemapper(remapperSupplier.get());
    }

    public static <V> RegistryRemapper<V> getRegistryRemapper(Identifier identifier) {
        return ServerRegistryRemapper.getInstance().getRegistryRemapperRegistryRemapper().getRegistry().getValue(identifier);
    }

    private static String formatTranslationKey(Identifier key) {
        return key.getNamespace() + "." + key.getPath();
    }

    public static int nextId(SimpleRegistryCompat<?, ?> registry) {
        return RegistryHelperImpl.nextId(registry.getIds(), registry);
    }

    public static int nextId(SimpleRegistryCompat<?, ?> registry, int minId) {
        return RegistryHelperImpl.nextId(registry.getIds(), registry, minId);
    }

    public static NumericalIdPair nextIds(SimpleRegistryCompat<?, ?> registry, int offset) {
        int id = 0;
        RegistryRemapper<Object> registryRemapper = RegistryRemapper.getRegistryRemapper(registry);
        if (registryRemapper == null) {
            registryRemapper = RegistryRemapper.DEFAULT_CLIENT_INSTANCE;
        }
        while (id < registryRemapper.getMinId() || RegistryHelperImpl.getIdList(registry).fromInt(id) != null || RegistryHelperImpl.getIdList(registry).fromInt(id + offset) != null) {
            ++id;
        }
        return new NumericalIdPair(id, id + offset);
    }

    public static int nextId(IdListCompat<?> idList, SimpleRegistryCompat<?, ?> registry, int minId) {
        return RegistryHelperImpl.nextId(idList, registry, (BiMap<Identifier, Integer>)HashBiMap.create(), minId);
    }

    public static int nextId(IdListCompat<?> idList, SimpleRegistryCompat<?, ?> registry) {
        return RegistryHelperImpl.nextId(idList, registry, 0);
    }

    public static int nextId(IdListCompat<?> idList, SimpleRegistryCompat<?, ?> registry, BiMap<Identifier, Integer> missingMap) {
        return RegistryHelperImpl.nextId(idList, registry, missingMap, 0);
    }

    public static int nextId(IdListCompat<?> idList, SimpleRegistryCompat<?, ?> registry, BiMap<Identifier, Integer> missingMap, int minId) {
        int id = minId;
        RegistryRemapper<Object> registryRemapper = RegistryRemapper.getRegistryRemapper(registry);
        if (registryRemapper == null) {
            registryRemapper = RegistryRemapper.DEFAULT_CLIENT_INSTANCE;
        }
        while (idList.fromInt(id) != null || id < registryRemapper.getMinId() || missingMap.containsValue((Object)id)) {
            ++id;
        }
        return id;
    }

    public static <K, V> IdListCompat<V> getIdList(SimpleRegistryCompat<K, V> registry) {
        return registry.getIds();
    }

    public static <K, V> BiMap<V, K> getObjects(SimpleRegistryCompat<K, V> registry) {
        return (BiMap)registry.getObjects();
    }

    public static <K, V> IdentityHashMap<V, Integer> getIdMap(IdListCompat<V> idList, SimpleRegistryCompat<K, V> registry) {
        return idList.getIdMap(registry);
    }

    public static <K, V> IdentityHashMap<V, Integer> getIdMap(SimpleRegistryCompat<K, V> registry) {
        return RegistryHelperImpl.getIdMap(RegistryHelperImpl.getIdList(registry), registry);
    }
}

