/*
 * Decompiled with CFR 0.152.
 */
package huix.glacier.api.registry.sync;

import huix.glacier.api.registry.RegistryIds;
import huix.glacier.api.registry.sync.RegistryHelperImpl;
import huix.glacier.event.Event;
import huix.glacier.event.EventFactory;
import huix.glacier.util.Identifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Block;
import net.minecraft.Item;

public final class RegistryHelper {
    public static final Map<Identifier, Event<RegistryInitialized>> IDENTIFIER_EVENT_MAP = new HashMap<Identifier, Event<RegistryInitialized>>();

    public static Event<RegistryInitialized> onRegistryInitialized(Identifier identifier) {
        Event<RegistryInitialized> event;
        if (IDENTIFIER_EVENT_MAP.containsKey(identifier)) {
            event = IDENTIFIER_EVENT_MAP.get(identifier);
        } else {
            event = EventFactory.createArrayBacked(RegistryInitialized.class, callbacks -> () -> {
                for (RegistryInitialized callback : callbacks) {
                    callback.initialized();
                }
            });
            IDENTIFIER_EVENT_MAP.put(identifier, event);
        }
        return event;
    }

    public static Block registerBlock(Block block, Identifier id) {
        return RegistryHelperImpl.registerBlock(block, id);
    }

    public static Block getBlock(Identifier id) {
        return (Block)RegistryHelperImpl.getValue(id, RegistryIds.BLOCKS);
    }

    public static Item registerItem(Item item, Identifier id) {
        return RegistryHelperImpl.registerItem(item, id);
    }

    public static Item getItem(Identifier id) {
        return (Item)RegistryHelperImpl.getValue(id, RegistryIds.ITEMS);
    }

    @FunctionalInterface
    public static interface RegistryInitialized {
        public void initialized();
    }

    @FunctionalInterface
    public static interface EntryCreator<T> {
        public T create(int var1);
    }
}

