/*
 * Decompiled with CFR 0.152.
 */
import com.unascribed.ears.api.features.EarsFeatures;
import com.unascribed.ears.common.EarsCommon;
import com.unascribed.ears.common.EarsFeaturesParser;
import com.unascribed.ears.common.EarsFeaturesStorage;
import com.unascribed.ears.common.debug.EarsLog;
import com.unascribed.ears.common.legacy.AWTEarsImage;
import com.unascribed.ears.common.legacy.ImmediateEarsRenderDelegate;
import com.unascribed.ears.common.render.EarsRenderDelegate;
import com.unascribed.ears.common.util.Decider;
import com.unascribed.ears.common.util.EarsStorage;
import com.unascribed.ears.legacy.LegacyHelper;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class com_unascribed_ears_Ears {
    private static final com_unascribed_ears_Ears INST = new com_unascribed_ears_Ears();
    public static final Map<String, EarsFeatures> earsSkinFeatures = new WeakHashMap<String, EarsFeatures>();
    public static Minecraft game;
    private ds render;
    private float brightness;
    private float tickDelta;
    public static boolean forceBipedTextureHeight;
    public static ps slimLeftArm;
    public static ps slimRightArm;
    public static ps fatLeftArm;
    public static ps fatRightArm;
    private static final Method rr_setAreaOpaque;
    private static final Method rr_setAreaTransparent;
    private static final Field rr_imageHeight;
    private static final Field rr_imageWidth;
    private static final Field rr_imageData;
    private static final Field ps_vertices;
    private static final Field ds_modelBipedMain;
    private static boolean forceTextureHeight;
    private static fh myModel;
    private final ImmediateEarsRenderDelegate<gs, ps> delegate = new ImmediateEarsRenderDelegate<gs, ps>(){

        @Override
        protected boolean isVisible(ps modelPart) {
            return modelPart.h;
        }

        @Override
        public boolean isSlim() {
            return LegacyHelper.isSlimArms(((gs)this.peer).l);
        }

        @Override
        protected EarsFeatures getEarsFeatures() {
            if (earsSkinFeatures.containsKey(this.getSkinUrl())) {
                EarsFeatures feat = earsSkinFeatures.get(this.getSkinUrl());
                EarsFeaturesStorage.INSTANCE.put(((gs)this.peer).l, LegacyHelper.getUuid(((gs)this.peer).l), feat);
                return feat;
            }
            return EarsFeatures.DISABLED;
        }

        @Override
        protected void doBindSkin() {
            try {
                com_unascribed_ears_Ears.this.render.a(this.getSkinUrl(), ((gs)this.peer).q_());
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }

        @Override
        protected void doAnchorTo(EarsRenderDelegate.BodyPart part, ps modelPart) {
            modelPart.c(0.0625f);
            GL11.glScalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            ib vert = com_unascribed_ears_Ears.getVertices(modelPart)[3];
            GL11.glTranslatef((float)((float)vert.a.a), (float)((float)vert.a.b), (float)((float)vert.a.c));
        }

        @Override
        protected Decider<EarsRenderDelegate.BodyPart, ps> decideModelPart(Decider<EarsRenderDelegate.BodyPart, ps> d) {
            fh modelBiped = (fh)((com_unascribed_ears_Ears)com_unascribed_ears_Ears.this).render.e;
            return d.map(EarsRenderDelegate.BodyPart.HEAD, modelBiped.a).map(EarsRenderDelegate.BodyPart.LEFT_ARM, modelBiped.e).map(EarsRenderDelegate.BodyPart.LEFT_LEG, modelBiped.g).map(EarsRenderDelegate.BodyPart.RIGHT_ARM, modelBiped.d).map(EarsRenderDelegate.BodyPart.RIGHT_LEG, modelBiped.f).map(EarsRenderDelegate.BodyPart.TORSO, modelBiped.c);
        }

        @Override
        protected int uploadImage(BufferedImage img) {
            return th.a.e.a(img);
        }

        @Override
        protected String getSkinUrl() {
            return ((gs)this.peer).bA;
        }

        @Override
        protected float getBrightness() {
            return com_unascribed_ears_Ears.this.brightness;
        }

        @Override
        public float getTime() {
            return (float)((sn)this.peer).bt + com_unascribed_ears_Ears.this.tickDelta;
        }

        @Override
        public boolean isFlying() {
            return ((gs)this.peer).bq;
        }

        @Override
        public boolean isGliding() {
            return false;
        }

        @Override
        public boolean isJacketEnabled() {
            return true;
        }

        @Override
        public boolean isWearingBoots() {
            iz feet = ((gs)this.peer).c.b[0];
            return feet != null && feet.a() instanceof wa;
        }

        @Override
        public boolean isWearingChestplate() {
            iz chest = ((gs)this.peer).c.b[2];
            return chest != null && chest.a() instanceof wa;
        }

        @Override
        public boolean isWearingElytra() {
            return false;
        }

        @Override
        public boolean needsSecondaryLayersDrawn() {
            return true;
        }

        @Override
        public float getHorizontalSpeed() {
            return EarsCommon.lerpDelta(((gs)this.peer).bi, ((gs)this.peer).bj, com_unascribed_ears_Ears.this.tickDelta);
        }

        @Override
        public float getLimbSwing() {
            return EarsCommon.lerpDelta(((gs)this.peer).ak, ((gs)this.peer).al, com_unascribed_ears_Ears.this.tickDelta);
        }

        @Override
        public float getStride() {
            return EarsCommon.lerpDelta(((gs)this.peer).h, ((gs)this.peer).i, com_unascribed_ears_Ears.this.tickDelta);
        }

        @Override
        public float getBodyYaw() {
            return EarsCommon.lerpDelta(((gs)this.peer).I, ((gs)this.peer).H, com_unascribed_ears_Ears.this.tickDelta);
        }

        @Override
        public double getCapeX() {
            return EarsCommon.lerpDelta(((gs)this.peer).o, ((gs)this.peer).r, com_unascribed_ears_Ears.this.tickDelta);
        }

        @Override
        public double getCapeY() {
            return EarsCommon.lerpDelta(((gs)this.peer).p, ((gs)this.peer).s, com_unascribed_ears_Ears.this.tickDelta);
        }

        @Override
        public double getCapeZ() {
            return EarsCommon.lerpDelta(((gs)this.peer).q, ((gs)this.peer).t, com_unascribed_ears_Ears.this.tickDelta);
        }

        @Override
        public double getX() {
            return EarsCommon.lerpDelta(((gs)this.peer).aJ, ((gs)this.peer).aM, com_unascribed_ears_Ears.this.tickDelta);
        }

        @Override
        public double getY() {
            return EarsCommon.lerpDelta(((gs)this.peer).aK, ((gs)this.peer).aN, com_unascribed_ears_Ears.this.tickDelta);
        }

        @Override
        public double getZ() {
            return EarsCommon.lerpDelta(((gs)this.peer).aL, ((gs)this.peer).aO, com_unascribed_ears_Ears.this.tickDelta);
        }
    };

    public static void init(Minecraft minecraft) {
        game = minecraft;
        if (EarsLog.DEBUG) {
            EarsLog.debugva(EarsLog.Tag.PLATFORM, "Initialized - Better Than Adventure", new Object[0]);
        }
    }

    public static void postRenderSpecials(ds renderPlayer, gs entity, float partialTicks) {
        INST.render(renderPlayer, entity, partialTicks);
    }

    public static void postDrawFirstPersonHand(ds renderPlayer) {
        INST.renderRightArm(renderPlayer, (gs)com_unascribed_ears_Ears.game.h, 0.0f);
    }

    public static void preprocessSkin(rr subject, BufferedImage rawImg, BufferedImage img) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "preprocessSkin({}, {}, {})", (Object)subject, (Object)rawImg, (Object)img);
        EarsStorage.put(img, EarsStorage.Key.ALFALFA, EarsCommon.preprocessSkin(new AWTEarsImage(rawImg)));
    }

    public static BufferedImage interceptParseUserSkin(rr subject, BufferedImage image) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "parseUserSkin({}, {})", (Object)subject, (Object)image);
        if (image == null) {
            EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "parseUserSkin(...): Image is null");
            return null;
        }
        com_unascribed_ears_Ears.setImageWidth(subject, 64);
        com_unascribed_ears_Ears.setImageHeight(subject, 64);
        BufferedImage newImg = new BufferedImage(64, 64, 2);
        Graphics g = newImg.getGraphics();
        g.drawImage(image, 0, 0, null);
        if (image.getHeight() == 32) {
            EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "parseUserSkin(...): Upgrading legacy skin");
            g.drawImage(newImg, 24, 48, 20, 52, 4, 16, 8, 20, null);
            g.drawImage(newImg, 28, 48, 24, 52, 8, 16, 12, 20, null);
            g.drawImage(newImg, 20, 52, 16, 64, 8, 20, 12, 32, null);
            g.drawImage(newImg, 24, 52, 20, 64, 4, 20, 8, 32, null);
            g.drawImage(newImg, 28, 52, 24, 64, 0, 20, 4, 32, null);
            g.drawImage(newImg, 32, 52, 28, 64, 12, 20, 16, 32, null);
            g.drawImage(newImg, 40, 48, 36, 52, 44, 16, 48, 20, null);
            g.drawImage(newImg, 44, 48, 40, 52, 48, 16, 52, 20, null);
            g.drawImage(newImg, 36, 52, 32, 64, 48, 20, 52, 32, null);
            g.drawImage(newImg, 40, 52, 36, 64, 44, 20, 48, 32, null);
            g.drawImage(newImg, 44, 52, 40, 64, 40, 20, 44, 32, null);
            g.drawImage(newImg, 48, 52, 44, 64, 52, 20, 56, 32, null);
        }
        g.dispose();
        EarsStorage.put(newImg, EarsStorage.Key.ALFALFA, EarsCommon.preprocessSkin(new AWTEarsImage(newImg)));
        com_unascribed_ears_Ears.setImageData(subject, ((DataBufferInt)newImg.getRaster().getDataBuffer()).getData());
        EarsCommon.carefullyStripAlpha((_x1, _y1, _x2, _y2) -> com_unascribed_ears_Ears.setAreaOpaque(subject, _x1, _y1, _x2, _y2), true);
        com_unascribed_ears_Ears.setAreaTransparent(subject, 32, 0, 64, 32);
        com_unascribed_ears_Ears.setAreaTransparent(subject, 0, 32, 16, 48);
        com_unascribed_ears_Ears.setAreaTransparent(subject, 16, 32, 40, 48);
        com_unascribed_ears_Ears.setAreaTransparent(subject, 40, 32, 56, 48);
        com_unascribed_ears_Ears.setAreaTransparent(subject, 0, 48, 16, 64);
        com_unascribed_ears_Ears.setAreaTransparent(subject, 48, 48, 64, 64);
        return newImg;
    }

    private static void setImageWidth(rr subject, int i) {
        try {
            rr_imageWidth.set(subject, i);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void setImageHeight(rr subject, int i) {
        try {
            rr_imageHeight.set(subject, i);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void setImageData(rr subject, int[] data) {
        try {
            rr_imageData.set(subject, data);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void setAreaOpaque(rr subject, int x1, int y1, int x2, int y2) {
        try {
            EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "stripAlpha({}, {}, {}, {}, {})", (Object)subject, x1, y1, x2, y2);
            rr_setAreaOpaque.invoke((Object)subject, x1, y1, x2, y2);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void setAreaTransparent(rr subject, int x1, int y1, int x2, int y2) {
        try {
            rr_setAreaTransparent.invoke((Object)subject, x1, y1, x2, y2);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static ib[] getVertices(ps ps2) {
        try {
            return (ib[])ps_vertices.get(ps2);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static fh getModelBipedMain(ds ds2) {
        try {
            return (fh)ds_modelBipedMain.get(ds2);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void setModelBipedMain(ds ds2, fh fh2) {
        try {
            ds_modelBipedMain.set(ds2, fh2);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void beforeRender(ds rp) {
        com_unascribed_ears_Ears.beforeRender(rp, (gs)com_unascribed_ears_Ears.game.h);
    }

    public static void beforeRender(ds rp, gs player) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT_RENDERER, "Before render rp={} player={}", (Object)rp, (Object)player);
        boolean slim = LegacyHelper.isSlimArms(player.l);
        fh modelBipedMain = com_unascribed_ears_Ears.getModelBipedMain(rp);
        if (slim) {
            modelBipedMain.e = slimLeftArm;
            modelBipedMain.d = slimRightArm;
        } else {
            modelBipedMain.e = fatLeftArm;
            modelBipedMain.d = fatRightArm;
        }
    }

    public static void checkSkin(String url, BufferedImage img) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "checkSkin({}, {})", (Object)url, (Object)img);
        earsSkinFeatures.put(url, EarsFeaturesParser.detect(new AWTEarsImage(img), EarsStorage.get(img, EarsStorage.Key.ALFALFA), data -> new AWTEarsImage(ImageIO.read(new ByteArrayInputStream(data)))));
    }

    public static String amendSkinUrl(String url) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "Amend skin URL {}", url);
        if (url.startsWith("https://betacraft.pl/skin/") && url.endsWith(".png")) {
            String username = url.substring(26, url.length() - 4);
            return LegacyHelper.getSkinUrl(username);
        }
        if (url.startsWith("https://betacraft.uk/MinecraftSkins/") && url.endsWith(".png")) {
            String username = url.substring(36, url.length() - 4);
            return LegacyHelper.getSkinUrl(username);
        }
        if (url.startsWith("http://s3.amazonaws.com/MinecraftSkins/") && url.endsWith(".png")) {
            String username = url.substring(39, url.length() - 4);
            return LegacyHelper.getSkinUrl(username);
        }
        return url;
    }

    public static void amendTexturedQuad(tz subject, ib[] apositiontexurevertex, int i, int j, int k, int l) {
        if (forceTextureHeight) {
            EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "amendTexturedQuad({}, ..., {}, {}, {}, {})", (Object)subject, i, j, k, l);
            float f = 0.0015625f;
            float f1 = 0.003125f;
            apositiontexurevertex[0] = apositiontexurevertex[0].a((float)k / 64.0f - f, (float)j / 64.0f + f1);
            apositiontexurevertex[1] = apositiontexurevertex[1].a((float)i / 64.0f + f, (float)j / 64.0f + f1);
            apositiontexurevertex[2] = apositiontexurevertex[2].a((float)i / 64.0f + f, (float)l / 64.0f - f1);
            apositiontexurevertex[3] = apositiontexurevertex[3].a((float)k / 64.0f - f, (float)l / 64.0f - f1);
        }
    }

    public static void amendPlayerRenderer(ds rp) throws IllegalArgumentException, IllegalAccessException {
        fh model;
        EarsLog.debug(EarsLog.Tag.PLATFORM, "Hacking 64x64 skin support into player model");
        forceTextureHeight = true;
        myModel = model = new fh(0.0f, 0.0f);
        Field mainModel = gv.class.getDeclaredFields()[0];
        mainModel.setAccessible(true);
        mainModel.set(rp, model);
        com_unascribed_ears_Ears.setModelBipedMain(rp, model);
        model.b = new com_unascribed_ears_ModelRendererTrans(32, 0);
        model.b.a(-4.0f, -8.0f, -4.0f, 8, 8, 8, 0.5f);
        model.b.a(0.0f, 0.0f, 0.0f);
        model.e = new ps(32, 48);
        model.e.a(-1.0f, -2.0f, -2.0f, 4, 12, 4, 0.0f);
        model.e.a(5.0f, 2.0f, 0.0f);
        model.g = new ps(16, 48);
        model.g.a(-2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f);
        model.g.a(1.9f, 12.0f, 0.0f);
        fatLeftArm = model.e;
        fatRightArm = model.d;
        slimLeftArm = new ps(32, 48);
        slimLeftArm.a(-1.0f, -2.0f, -2.0f, 3, 12, 4, 0.0f);
        slimLeftArm.a(5.0f, 2.5f, 0.0f);
        slimRightArm = new ps(40, 16);
        slimRightArm.a(-2.0f, -2.0f, -2.0f, 3, 12, 4, 0.0f);
        slimRightArm.a(-5.0f, 2.5f, 0.0f);
        com_unascribed_ears_Ears.flipBottom(model.a);
        com_unascribed_ears_Ears.flipBottom(model.c);
        com_unascribed_ears_Ears.flipBottom(fatLeftArm);
        com_unascribed_ears_Ears.flipBottom(slimLeftArm);
        com_unascribed_ears_Ears.flipBottom(fatRightArm);
        com_unascribed_ears_Ears.flipBottom(slimRightArm);
        com_unascribed_ears_Ears.flipBottom(model.g);
        com_unascribed_ears_Ears.flipBottom(model.f);
        com_unascribed_ears_Ears.flipBottom(model.b);
        forceTextureHeight = false;
    }

    private static void flipBottom(ps box) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        float maxV;
        Field quadsF = ps.class.getDeclaredFields()[1];
        quadsF.setAccessible(true);
        tz[] quads = (tz[])quadsF.get(box);
        ib[] verts = quads[3].a;
        float minV = verts[0].c;
        verts[0].c = maxV = verts[2].c;
        verts[1].c = maxV;
        verts[2].c = minV;
        verts[3].c = minV;
    }

    public void render(ds render, gs entity, float partialTicks) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "render({}, {}, {})", (Object)entity, 0.0f, partialTicks);
        this.render = render;
        this.brightness = entity.a(partialTicks);
        this.tickDelta = partialTicks;
        this.delegate.render(entity);
        this.render = null;
    }

    public void renderRightArm(ds render, gs entity, float partialTicks) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "renderRightArm({}, {}, {})", (Object)render, (Object)entity, partialTicks);
        this.render = render;
        this.brightness = entity.a(partialTicks);
        this.tickDelta = partialTicks;
        this.delegate.render(entity, EarsRenderDelegate.BodyPart.RIGHT_ARM);
        this.render = null;
    }

    static {
        forceBipedTextureHeight = false;
        try {
            rr_setAreaOpaque = rr.class.getDeclaredMethod("b", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            rr_setAreaOpaque.setAccessible(true);
            rr_setAreaTransparent = rr.class.getDeclaredMethod("a", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            rr_setAreaTransparent.setAccessible(true);
            rr_imageHeight = rr.class.getDeclaredField("c");
            rr_imageHeight.setAccessible(true);
            rr_imageWidth = rr.class.getDeclaredField("b");
            rr_imageWidth.setAccessible(true);
            rr_imageData = rr.class.getDeclaredField("a");
            rr_imageData.setAccessible(true);
            ps_vertices = ps.class.getDeclaredField("j");
            ps_vertices.setAccessible(true);
            ds_modelBipedMain = ds.class.getDeclaredField("a");
            ds_modelBipedMain.setAccessible(true);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

