/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.legacy.nanojson;

import com.unascribed.ears.legacy.nanojson.JsonAppendableWriter;
import com.unascribed.ears.legacy.nanojson.JsonStringWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;

public final class JsonWriter {
    private JsonWriter() {
    }

    public static JsonWriterContext indent(String indent) {
        if (indent == null) {
            throw new IllegalArgumentException("indent must be non-null");
        }
        for (int i = 0; i < indent.length(); ++i) {
            if (indent.charAt(i) == ' ' || indent.charAt(i) == '\t') continue;
            throw new IllegalArgumentException("Only tabs and spaces are allowed for indent.");
        }
        return new JsonWriterContext(indent);
    }

    public static JsonStringWriter string() {
        return new JsonStringWriter(null);
    }

    public static String string(Object value) {
        return ((JsonStringWriter)new JsonStringWriter(null).value(value)).done();
    }

    public static JsonAppendableWriter on(Appendable appendable) {
        return new JsonAppendableWriter(appendable, null);
    }

    public static JsonAppendableWriter on(PrintStream appendable) {
        return new JsonAppendableWriter(appendable, null);
    }

    public static JsonAppendableWriter on(OutputStream out) {
        return new JsonAppendableWriter(out, null);
    }

    public static String escape(String value) {
        String s = JsonWriter.string(value);
        return s.substring(1, s.length() - 1);
    }

    public static final class JsonWriterContext {
        private final String indent;

        private JsonWriterContext(String indent) {
            this.indent = indent;
        }

        public JsonStringWriter string() {
            return new JsonStringWriter(this.indent);
        }

        public JsonAppendableWriter on(Appendable appendable) {
            return new JsonAppendableWriter(appendable, this.indent);
        }

        public JsonAppendableWriter on(PrintStream appendable) {
            return new JsonAppendableWriter(appendable, this.indent);
        }

        public JsonAppendableWriter on(OutputStream out) {
            return new JsonAppendableWriter(new OutputStreamWriter(out, Charset.forName("UTF-8")), this.indent);
        }
    }
}

