/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.legacy.nanojson;

import com.unascribed.ears.legacy.nanojson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class JsonArray
extends ArrayList<Object> {
    private static final long serialVersionUID = 1L;

    public JsonArray() {
    }

    public JsonArray(int initialCapacity) {
        super(initialCapacity);
    }

    public JsonArray(Collection<?> collection) {
        super(collection);
    }

    public static JsonArray from(Object ... contents) {
        return new JsonArray((Collection<?>)Arrays.asList(contents));
    }

    @Override
    public Object get(int key) {
        return key < this.size() ? super.get(key) : null;
    }

    public JsonArray getArray(int key) {
        return this.getArray(key, null);
    }

    public JsonArray getArray(int key, JsonArray default_) {
        Object o = this.get(key);
        if (o instanceof JsonArray) {
            return (JsonArray)o;
        }
        return default_;
    }

    public boolean getBoolean(int key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(int key, Boolean default_) {
        Object o = this.get(key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return default_;
    }

    public double getDouble(int key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(int key, double default_) {
        Object o = this.get(key);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return default_;
    }

    public float getFloat(int key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(int key, float default_) {
        Object o = this.get(key);
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        return default_;
    }

    public int getInt(int key) {
        return this.getInt(key, 0);
    }

    public int getInt(int key, int default_) {
        Object o = this.get(key);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return default_;
    }

    public long getLong(int key) {
        return this.getLong(key, 0L);
    }

    public long getLong(int key, long default_) {
        Object o = this.get(key);
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return default_;
    }

    public Number getNumber(int key) {
        return this.getNumber(key, null);
    }

    public Number getNumber(int key, Number default_) {
        Object o = this.get(key);
        if (o instanceof Number) {
            return (Number)o;
        }
        return default_;
    }

    public JsonObject getObject(int key) {
        return this.getObject(key, null);
    }

    public JsonObject getObject(int key, JsonObject default_) {
        Object o = this.get(key);
        if (o instanceof JsonObject) {
            return (JsonObject)o;
        }
        return default_;
    }

    public String getString(int key) {
        return this.getString(key, null);
    }

    public String getString(int key, String default_) {
        Object o = this.get(key);
        if (o instanceof String) {
            return (String)o;
        }
        return default_;
    }

    public boolean has(int key) {
        return key < this.size();
    }

    public boolean isBoolean(int key) {
        return this.get(key) instanceof Boolean;
    }

    public boolean isNull(int key) {
        return key < this.size() && this.get(key) == null;
    }

    public boolean isNumber(int key) {
        return this.get(key) instanceof Number;
    }

    public boolean isString(int key) {
        return this.get(key) instanceof String;
    }
}

