/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.common;

import com.unascribed.ears.api.Slice;
import com.unascribed.ears.common.WritableEarsImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class QDPNG {
    private static final Slice HEADER = Slice.parse("89[PNG\r\n]1A[\n]");
    private static final Slice IHDR = Slice.parse("[IHDR]");
    private static final Slice IDAT = Slice.parse("[IDAT]");
    private static final Slice IEND_COMPLETE = Slice.parse("00000000[IEND]AE426082");
    private final WritableEarsImage img;
    private final ByteArrayOutputStream root = new ByteArrayOutputStream();
    private final DataOutputStream dosRoot = new DataOutputStream(this.root);
    private final ByteArrayOutputStream tmp = new ByteArrayOutputStream();
    private final CheckedOutputStream crcTmp = new CheckedOutputStream(this.tmp, new CRC32());
    private final DataOutputStream dosTmp = new DataOutputStream(this.crcTmp);
    private DataOutputStream out = this.dosRoot;

    public static byte[] write(WritableEarsImage out) {
        return new QDPNG(out).write();
    }

    private QDPNG(WritableEarsImage img) {
        this.img = img;
    }

    private byte[] write() {
        try {
            this.root.reset();
            this.out = this.dosRoot;
            HEADER.writeTo(this.out);
            this.beginChunk(IHDR);
            this.out.writeInt(this.img.getWidth());
            this.out.writeInt(this.img.getHeight());
            this.out.writeByte(8);
            this.out.writeByte(6);
            this.out.writeByte(0);
            this.out.writeByte(0);
            this.out.writeByte(0);
            this.endChunk();
            this.beginChunk(IDAT);
            DeflaterOutputStream zout = new DeflaterOutputStream((OutputStream)this.crcTmp, new Deflater(2));
            for (int y = 0; y < this.img.getHeight(); ++y) {
                zout.write(0);
                for (int x = 0; x < this.img.getWidth(); ++x) {
                    int c = this.img.getARGB(x, y);
                    zout.write(c >> 16 & 0xFF);
                    zout.write(c >> 8 & 0xFF);
                    zout.write(c >> 0 & 0xFF);
                    zout.write(c >> 24 & 0xFF);
                }
            }
            zout.finish();
            this.endChunk();
            IEND_COMPLETE.writeTo(this.out);
            return this.root.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void beginChunk(Slice name) throws IOException {
        this.tmp.reset();
        this.crcTmp.getChecksum().reset();
        this.out = this.dosTmp;
        name.writeTo(this.out);
    }

    private void endChunk() throws IOException {
        this.out.flush();
        this.out = this.dosRoot;
        this.out.writeInt(this.tmp.size() - 4);
        this.tmp.writeTo(this.out);
        this.out.writeInt((int)this.crcTmp.getChecksum().getValue());
    }
}

