/*
 * Decompiled with CFR 0.152.
 */
package shims.java.net.minecraft.util;

import dev.emi.emi.Prototype;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import moddedmite.emi.api.EMIShapedRecipes;
import moddedmite.emi.api.EMIShapelessRecipes;
import moddedmite.emi.recipe.EmiFoodRecipe;
import net.minecraft.Block;
import net.minecraft.ItemStack;
import net.minecraft.ResourceLocation;
import net.minecraft.ShapedRecipes;
import net.minecraft.ShapelessRecipes;
import shims.java.net.minecraft.nbt.StringNbtReader;

public class SyntheticIdentifier
extends ResourceLocation {
    public SyntheticIdentifier(Object o) {
        super(SyntheticIdentifier.generateId(o));
    }

    public SyntheticIdentifier(Object o, String tail) {
        super(SyntheticIdentifier.generateId(o) + tail);
    }

    private static String generateId(Object o) {
        if (o == null) {
            return "null:null";
        }
        if (o instanceof ShapedRecipes) {
            ShapedRecipes sr = (ShapedRecipes)o;
            return "shaped:/" + ((EMIShapedRecipes)sr).getRecipeWidth() + "x" + ((EMIShapedRecipes)sr).getRecipeHeight() + "/" + SyntheticIdentifier.describeFlat(((EMIShapedRecipes)sr).getRecipeItems()) + "/" + SyntheticIdentifier.describe(sr.getRecipeOutput());
        }
        if (o instanceof ShapelessRecipes) {
            ShapelessRecipes sr = (ShapelessRecipes)o;
            return "shapeless:/" + SyntheticIdentifier.describeFlat(((EMIShapelessRecipes)sr).getRecipeItems()) + "/" + SyntheticIdentifier.describe(sr.getRecipeOutput());
        }
        if (o instanceof EmiCraftingRecipe) {
            EmiCraftingRecipe cr = (EmiCraftingRecipe)o;
            return "crafting:/" + SyntheticIdentifier.describeFlat(cr.getInputs()) + "/" + SyntheticIdentifier.describe(cr.getOutputs());
        }
        if (o instanceof EmiFoodRecipe) {
            EmiFoodRecipe fr = (EmiFoodRecipe)o;
            return "food:/" + SyntheticIdentifier.describe(fr.getFoodItem());
        }
        return "unknown:/" + SyntheticIdentifier.describe(o);
    }

    public static String describeFlat(List<?> li) {
        return SyntheticIdentifier.describeFlat(li.stream());
    }

    public static String describeFlat(Object[] items) {
        return SyntheticIdentifier.describeFlat(Arrays.stream(items));
    }

    public static String describeFlat(Stream<?> stream) {
        return stream.map(SyntheticIdentifier::describe).collect(Collectors.joining("/"));
    }

    public static String describe(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof EmiStack) {
            EmiStack es = (EmiStack)o;
            return SyntheticIdentifier.describe(es.getItemStack());
        }
        if (o instanceof EmiIngredient) {
            EmiIngredient ei = (EmiIngredient)o;
            return ei.getEmiStacks().stream().map(SyntheticIdentifier::describe).collect(Collectors.joining("/", "[", "]"));
        }
        if (o instanceof ItemStack) {
            ItemStack is = (ItemStack)o;
            return is.itemID + "." + is.getItemSubtype() + (is.hasTagCompound() ? StringNbtReader.encode(is.getTagCompound()) : "");
        }
        if (o instanceof Block) {
            return SyntheticIdentifier.describe(new ItemStack((Block)o));
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof List) {
            List l = (List)o;
            return l.stream().map(SyntheticIdentifier::describe).collect(Collectors.joining("/", "[", "]"));
        }
        if (o instanceof Object[]) {
            Object[] arr = (Object[])o;
            return Arrays.stream(arr).map(SyntheticIdentifier::describe).collect(Collectors.joining("/", "[", "]"));
        }
        if (o instanceof Prototype) {
            Prototype p = (Prototype)o;
            return p.item() == null ? "0.0" : p.item().itemID + "." + p.meta();
        }
        return o.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }
}

