/*
 * Decompiled with CFR 0.152.
 */
package shims.java.net.minecraft.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class JsonHelper {
    private static final Gson GSON = new GsonBuilder().create();

    public static boolean hasString(JsonObject object, String element) {
        return !JsonHelper.hasPrimitive(object, element) ? false : object.getAsJsonPrimitive(element).isString();
    }

    public static boolean isString(JsonElement element) {
        return !element.isJsonPrimitive() ? false : element.getAsJsonPrimitive().isString();
    }

    public static boolean hasNumber(JsonObject object, String element) {
        return !JsonHelper.hasPrimitive(object, element) ? false : object.getAsJsonPrimitive(element).isNumber();
    }

    public static boolean hasBoolean(JsonObject object, String element) {
        return !JsonHelper.hasPrimitive(object, element) ? false : object.getAsJsonPrimitive(element).isBoolean();
    }

    public static boolean isBoolean(JsonElement object) {
        return !object.isJsonPrimitive() ? false : object.getAsJsonPrimitive().isBoolean();
    }

    public static boolean hasArray(JsonObject object, String element) {
        return !JsonHelper.hasElement(object, element) ? false : object.get(element).isJsonArray();
    }

    public static boolean hasJsonObject(JsonObject object, String element) {
        return !JsonHelper.hasElement(object, element) ? false : object.get(element).isJsonObject();
    }

    public static boolean hasPrimitive(JsonObject object, String element) {
        return !JsonHelper.hasElement(object, element) ? false : object.get(element).isJsonPrimitive();
    }

    public static boolean hasElement(JsonObject object, String element) {
        if (object == null) {
            return false;
        }
        return object.get(element) != null;
    }

    public static String asString(JsonElement element, String name) {
        if (element.isJsonPrimitive()) {
            return element.getAsString();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a string, was " + JsonHelper.getType(element));
    }

    public static String getString(JsonObject object, String element) {
        if (object.has(element)) {
            return JsonHelper.asString(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a string");
    }

    @Nullable
    public static String getString(JsonObject object, String element, @Nullable String defaultStr) {
        return object.has(element) ? JsonHelper.asString(object.get(element), element) : defaultStr;
    }

    public static boolean asBoolean(JsonElement element, String name) {
        if (element.isJsonPrimitive()) {
            return element.getAsBoolean();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Boolean, was " + JsonHelper.getType(element));
    }

    public static boolean getBoolean(JsonObject object, String element) {
        if (object.has(element)) {
            return JsonHelper.asBoolean(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Boolean");
    }

    public static boolean getBoolean(JsonObject object, String element, boolean defaultBoolean) {
        return object.has(element) ? JsonHelper.asBoolean(object.get(element), element) : defaultBoolean;
    }

    public static double asDouble(JsonElement object, String name) {
        if (object.isJsonPrimitive() && object.getAsJsonPrimitive().isNumber()) {
            return object.getAsDouble();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Double, was " + JsonHelper.getType(object));
    }

    public static double getDouble(JsonObject object, String element) {
        if (object.has(element)) {
            return JsonHelper.asDouble(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Double");
    }

    public static double getDouble(JsonObject object, String element, double defaultDouble) {
        return object.has(element) ? JsonHelper.asDouble(object.get(element), element) : defaultDouble;
    }

    public static float asFloat(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsFloat();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Float, was " + JsonHelper.getType(element));
    }

    public static float getFloat(JsonObject object, String element) {
        if (object.has(element)) {
            return JsonHelper.asFloat(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Float");
    }

    public static float getFloat(JsonObject object, String element, float defaultFloat) {
        return object.has(element) ? JsonHelper.asFloat(object.get(element), element) : defaultFloat;
    }

    public static long asLong(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsLong();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Long, was " + JsonHelper.getType(element));
    }

    public static long getLong(JsonObject object, String name) {
        if (object.has(name)) {
            return JsonHelper.asLong(object.get(name), name);
        }
        throw new JsonSyntaxException("Missing " + name + ", expected to find a Long");
    }

    public static long getLong(JsonObject object, String element, long defaultLong) {
        return object.has(element) ? JsonHelper.asLong(object.get(element), element) : defaultLong;
    }

    public static int asInt(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsInt();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Int, was " + JsonHelper.getType(element));
    }

    public static int getInt(JsonObject object, String element) {
        if (object.has(element)) {
            return JsonHelper.asInt(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Int");
    }

    public static int getInt(JsonObject object, String element, int defaultInt) {
        return object.has(element) ? JsonHelper.asInt(object.get(element), element) : defaultInt;
    }

    public static JsonObject asObject(JsonElement element, String name) {
        if (element.isJsonObject()) {
            return element.getAsJsonObject();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a JsonObject, was " + JsonHelper.getType(element));
    }

    public static JsonObject getObject(JsonObject object, String element) {
        if (object.has(element)) {
            return JsonHelper.asObject(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a JsonObject");
    }

    @Nullable
    public static JsonObject getObject(JsonObject object, String element, @Nullable JsonObject defaultObject) {
        return object.has(element) ? JsonHelper.asObject(object.get(element), element) : defaultObject;
    }

    public static JsonArray asArray(JsonElement element, String name) {
        if (element.isJsonArray()) {
            return element.getAsJsonArray();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a JsonArray, was " + JsonHelper.getType(element));
    }

    public static JsonArray getArray(JsonObject object, String element) {
        if (object.has(element)) {
            return JsonHelper.asArray(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a JsonArray");
    }

    @Nullable
    public static JsonArray getArray(JsonObject object, String name, @Nullable JsonArray defaultArray) {
        return object.has(name) ? JsonHelper.asArray(object.get(name), name) : defaultArray;
    }

    public static <T> T deserialize(@Nullable JsonElement element, String name, JsonDeserializationContext context, Class<? extends T> type) {
        if (element != null) {
            return (T)context.deserialize(element, type);
        }
        throw new JsonSyntaxException("Missing " + name);
    }

    public static <T> T deserialize(JsonObject object, String element, JsonDeserializationContext context, Class<? extends T> type) {
        if (object.has(element)) {
            return JsonHelper.deserialize(object.get(element), element, context, type);
        }
        throw new JsonSyntaxException("Missing " + element);
    }

    @Nullable
    public static <T> T deserialize(JsonObject object, String element, @Nullable T defaultValue, JsonDeserializationContext context, Class<? extends T> type) {
        return object.has(element) ? JsonHelper.deserialize(object.get(element), element, context, type) : defaultValue;
    }

    public static String getType(@Nullable JsonElement element) {
        String string = String.valueOf(element);
        if (element == null) {
            return "null (missing)";
        }
        if (element.isJsonNull()) {
            return "null (json)";
        }
        if (element.isJsonArray()) {
            return "an array (" + string + ")";
        }
        if (element.isJsonObject()) {
            return "an object (" + string + ")";
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = element.getAsJsonPrimitive();
            if (jsonPrimitive.isNumber()) {
                return "a number (" + string + ")";
            }
            if (jsonPrimitive.isBoolean()) {
                return "a boolean (" + string + ")";
            }
        }
        return string;
    }

    @Nullable
    public static <T> T m_vsbufiln(Gson gson, Reader reader, Class<T> class_, boolean bl) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setLenient(bl);
            return (T)gson.getAdapter(class_).read(jsonReader);
        }
        catch (IOException var5) {
            throw new JsonParseException((Throwable)var5);
        }
    }

    public static <T> T deserialize(Gson gson, Reader reader, Class<T> type, boolean lenient) {
        T object = JsonHelper.m_vsbufiln(gson, reader, type, lenient);
        if (object == null) {
            throw new JsonParseException("JSON data was null or empty");
        }
        return object;
    }

    @Nullable
    public static <T> T m_boxypbwp(Gson gson, Reader reader, TypeToken<T> typeToken, boolean bl) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setLenient(bl);
            return (T)gson.getAdapter(typeToken).read(jsonReader);
        }
        catch (IOException var5) {
            throw new JsonParseException((Throwable)var5);
        }
    }

    public static <T> T deserialize(Gson gson, Reader reader, TypeToken<T> typeToken, boolean lenient) {
        T object = JsonHelper.m_boxypbwp(gson, reader, typeToken, lenient);
        if (object == null) {
            throw new JsonParseException("JSON data was null or empty");
        }
        return object;
    }

    @Nullable
    public static <T> T m_gludylcq(Gson gson, String string, TypeToken<T> typeToken, boolean bl) {
        return JsonHelper.m_boxypbwp(gson, new StringReader(string), typeToken, bl);
    }

    public static <T> T deserialize(Gson gson, String content, Class<T> type, boolean lenient) {
        return JsonHelper.deserialize(gson, (Reader)new StringReader(content), type, lenient);
    }

    @Nullable
    public static <T> T m_haynlcxa(Gson gson, String string, Class<T> class_, boolean bl) {
        return JsonHelper.m_vsbufiln(gson, new StringReader(string), class_, bl);
    }

    public static <T> T deserialize(Gson gson, Reader reader, TypeToken<T> typeToken) {
        return JsonHelper.deserialize(gson, reader, typeToken, false);
    }

    @Nullable
    public static <T> T m_zmohitsy(Gson gson, String string, TypeToken<T> typeToken) {
        return JsonHelper.m_gludylcq(gson, string, typeToken, false);
    }

    public static <T> T deserialize(Gson gson, Reader reader, Class<T> type) {
        return JsonHelper.deserialize(gson, reader, type, false);
    }

    public static <T> T deserialize(Gson gson, String content, Class<T> type) {
        return JsonHelper.deserialize(gson, content, type, false);
    }

    public static JsonObject deserialize(String content, boolean lenient) {
        return JsonHelper.deserialize(new StringReader(content), lenient);
    }

    public static JsonObject deserialize(Reader reader, boolean lenient) {
        return JsonHelper.deserialize(GSON, reader, JsonObject.class, lenient);
    }

    public static JsonObject deserialize(String content) {
        return JsonHelper.deserialize(content, false);
    }

    public static JsonObject deserialize(Reader reader) {
        return JsonHelper.deserialize(reader, false);
    }

    public static JsonArray deserializeArray(String content) {
        return JsonHelper.deserializeArray(new StringReader(content));
    }

    public static JsonArray deserializeArray(Reader reader) {
        return JsonHelper.deserialize(GSON, reader, JsonArray.class, false);
    }

    public static String toSortedString(JsonElement element) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            JsonHelper.writeValue(jsonWriter, element, Comparator.naturalOrder());
        }
        catch (IOException var4) {
            throw new AssertionError((Object)var4);
        }
        return stringWriter.toString();
    }

    public static void writeValue(JsonWriter writer, @Nullable JsonElement element, @Nullable Comparator<String> comparator) throws IOException {
        if (element == null || element.isJsonNull()) {
            writer.nullValue();
        } else if (element.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = element.getAsJsonPrimitive();
            if (jsonPrimitive.isNumber()) {
                writer.value(jsonPrimitive.getAsNumber());
            } else if (jsonPrimitive.isBoolean()) {
                writer.value(jsonPrimitive.getAsBoolean());
            } else {
                writer.value(jsonPrimitive.getAsString());
            }
        } else if (element.isJsonArray()) {
            writer.beginArray();
            for (JsonElement jsonElement : element.getAsJsonArray()) {
                JsonHelper.writeValue(writer, jsonElement, comparator);
            }
            writer.endArray();
        } else {
            if (!element.isJsonObject()) {
                throw new IllegalArgumentException("Couldn't write " + element.getClass());
            }
            writer.beginObject();
            for (Map.Entry<String, JsonElement> entry : JsonHelper.sort(element.getAsJsonObject().entrySet(), comparator)) {
                writer.name(entry.getKey());
                JsonHelper.writeValue(writer, entry.getValue(), comparator);
            }
            writer.endObject();
        }
    }

    private static Collection<Map.Entry<String, JsonElement>> sort(Collection<Map.Entry<String, JsonElement>> entries, @Nullable Comparator<String> comparator) {
        if (comparator == null) {
            return entries;
        }
        ArrayList<Map.Entry<String, JsonElement>> list = new ArrayList<Map.Entry<String, JsonElement>>(entries);
        list.sort(Map.Entry.comparingByKey(comparator));
        return list;
    }
}

