/*
 * Decompiled with CFR 0.152.
 */
package shims.java.net.minecraft.text;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import shims.java.net.minecraft.text.MutableText;
import shims.java.net.minecraft.text.OrderedText;
import shims.java.net.minecraft.text.Style;
import shims.java.net.minecraft.text.Text;
import shims.java.net.minecraft.util.Formatting;

public class TextImpl
implements OrderedText,
Text,
MutableText {
    private final Supplier<String> text;
    private String style;
    private final List<TextImpl> siblings = new ArrayList<TextImpl>();

    public TextImpl(Supplier<String> text, String style) {
        this.text = text;
        this.style = style;
    }

    private void appendTo(StringBuilder sb) {
        sb.append(this.style);
        sb.append(this.text.get());
        for (TextImpl sibling : this.siblings) {
            sibling.appendTo(sb);
        }
    }

    @Override
    public String asString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        if (!this.style.isEmpty()) {
            sb.append("\u00a7r");
        }
        return sb.toString();
    }

    @Deprecated
    public String toString() {
        return this.asString();
    }

    @Override
    public MutableText setStyle(Style s) {
        this.style = s.toString();
        return this;
    }

    @Override
    public MutableText formatted(Formatting fmt) {
        this.style = this.style + fmt;
        return this;
    }

    @Override
    public MutableText formatted(Formatting ... fmt) {
        StringBuilder sb = new StringBuilder(this.style.length() + fmt.length * 2);
        sb.append(this.style);
        for (Formatting f : fmt) {
            sb.append((Object)f);
        }
        this.style = sb.toString();
        return this;
    }

    @Override
    public MutableText append(Text text) {
        this.siblings.add((TextImpl)text);
        return this;
    }

    @Override
    public OrderedText asOrderedText() {
        return this;
    }

    @Override
    public MutableText copy() {
        TextImpl i = new TextImpl(this.text, this.style);
        i.siblings.addAll(this.siblings);
        return i;
    }
}

