/*
 * Decompiled with CFR 0.152.
 */
package shims.java.net.minecraft.text;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import shims.java.net.minecraft.text.ClickEvent;
import shims.java.net.minecraft.util.Formatting;

public class Style {
    public static final Style EMPTY = new Style("", false, null);
    final String formats;
    final ClickEvent clickEvent;
    final Boolean underline;

    public Style(String formats, Boolean underline, ClickEvent clickEvent) {
        this.formats = formats;
        this.clickEvent = clickEvent;
        this.underline = underline;
    }

    public Style withUnderline(boolean underline) {
        return Objects.equals(this.underline, underline) ? this : Style.with(new Style(this.formats + Formatting.UNDERLINE, underline, this.clickEvent), this.underline, underline);
    }

    public Style withColor(int color) {
        return Objects.equals(this.formats, String.valueOf(color)) ? this : Style.with(new Style(this.formats + "\u00a7x" + Integer.toHexString(color | 0xFF000000).substring(2).replace("", "\u00a7") + "x", this.underline, this.clickEvent), this.formats, String.valueOf(color));
    }

    public Style withFormatting(Formatting formatting) {
        return Objects.equals(this.formats, (Object)formatting) ? this : Style.with(new Style(this.formats, this.underline, this.clickEvent), this.formats, formatting);
    }

    public Style withClickEvent(ClickEvent clickEvent) {
        return Objects.equals(this.clickEvent, clickEvent) ? this : Style.with(new Style(this.formats, this.underline, clickEvent), this.clickEvent, clickEvent);
    }

    private static <T> Style with(Style newStyle, @Nullable T oldAttribute, @Nullable T newAttribute) {
        return oldAttribute != null && newAttribute == null && newStyle.equals(EMPTY) ? EMPTY : newStyle;
    }

    @Nullable
    public ClickEvent getClickEvent() {
        return this.clickEvent;
    }

    public String toString() {
        return this.formats;
    }
}

