/*
 * Decompiled with CFR 0.152.
 */
package shims.java.net.minecraft.tag;

import dev.emi.emi.Prototype;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.ResourceLocation;
import shims.java.net.minecraft.tag.TagKey;

public class WildcardItemTag
implements TagKey<Prototype> {
    private final Item item;
    private final List<Prototype> subtypes;

    public WildcardItemTag(Item item) {
        this.item = item;
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        item.getSubItems(item.itemID, item.getCreativeTab(), li);
        if (li.isEmpty()) {
            li.add(new ItemStack(item));
        }
        this.subtypes = li.stream().map(Prototype::of).collect(Collectors.toList());
    }

    @Override
    public ResourceLocation id() {
        return new ResourceLocation("wildcard", this.item.getItemDisplayName(new ItemStack(this.item)) + "/" + this.item.itemID);
    }

    @Override
    public List<Prototype> get() {
        return this.subtypes;
    }

    @Override
    public String getFlavor() {
        return "wildcard";
    }
}

