/*
 * Decompiled with CFR 0.152.
 */
package shims.java.net.minecraft.network;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import net.minecraft.ItemStack;
import net.minecraft.Packet;

public interface PacketByteBuf {
    public byte readByte();

    public ItemStack readItemStack();

    public String readString();

    public int readInt();

    public int readVarInt();

    public boolean readBoolean();

    public void writeByte(int var1);

    public void writeItemStack(ItemStack var1);

    public void writeString(String var1);

    public void writeInt(int var1);

    public void writeVarInt(int var1);

    public void writeBoolean(boolean var1);

    public static PacketByteBuf out(final DataOutputStream out) {
        return new PacketByteBuf(){

            @Override
            public void writeVarInt(int value) {
                while ((value & 0xFFFFFF80) != 0) {
                    this.writeByte(value & 0x7F | 0x80);
                    value >>>= 7;
                }
                this.writeByte(value);
            }

            @Override
            public void writeString(String str) {
                byte[] bys = str.getBytes(StandardCharsets.UTF_8);
                this.writeVarInt(bys.length);
                try {
                    out.write(bys);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public void writeItemStack(ItemStack stack) {
                try {
                    Packet.writeItemStack((ItemStack)stack, (DataOutput)out);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public void writeInt(int i) {
                try {
                    out.writeInt(i);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public void writeByte(int b) {
                try {
                    out.writeByte(b);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public void writeBoolean(boolean b) {
                this.writeByte(b ? 1 : 0);
            }

            @Override
            public int readVarInt() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String readString() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ItemStack readItemStack() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int readInt() {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte readByte() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean readBoolean() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PacketByteBuf in(final DataInputStream in) {
        return new PacketByteBuf(){

            @Override
            public int readVarInt() {
                byte b;
                int i = 0;
                int j = 0;
                do {
                    b = this.readByte();
                    i |= (b & 0x7F) << j++ * 7;
                    if (j <= 5) continue;
                    throw new RuntimeException("VarInt too big");
                } while ((b & 0x80) == 128);
                return i;
            }

            @Override
            public String readString() {
                int len = this.readVarInt();
                byte[] bys = new byte[len];
                try {
                    in.readFully(bys);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return new String(bys, StandardCharsets.UTF_8);
            }

            @Override
            public ItemStack readItemStack() {
                try {
                    return Packet.readItemStack((DataInput)in);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public int readInt() {
                try {
                    return in.readInt();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public byte readByte() {
                try {
                    return in.readByte();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public boolean readBoolean() {
                try {
                    return in.readByte() != 0;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public void writeVarInt(int value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void writeString(String str) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void writeItemStack(ItemStack stack) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void writeInt(int i) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void writeByte(int b) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void writeBoolean(boolean b) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

