/*
 * Decompiled with CFR 0.152.
 */
package shims.java.net.minecraft.client.util;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import net.minecraft.StringTranslate;
import org.lwjgl.input.Keyboard;
import shims.java.net.minecraft.text.Text;

public class InputUtil {
    public static final Key UNKNOWN_KEY = Type.KEYSYM.createFromCode(0);

    public static Key fromKeyCode(int keyCode, int scanCode) {
        return keyCode == 0 ? Type.SCANCODE.createFromCode(scanCode) : Type.KEYSYM.createFromCode(keyCode);
    }

    public static Key fromTranslationKey(String translationKey) {
        if (Key.KEYS_BY_ID.containsKey(translationKey)) {
            return Key.KEYS_BY_ID.get(translationKey);
        }
        for (Type type : Type.values()) {
            if (!translationKey.startsWith(type.name)) continue;
            String string = translationKey.substring(type.name.length() + 1);
            int i = Integer.parseInt(string);
            if (type == Type.MOUSE) {
                --i;
            }
            return type.createFromCode(i);
        }
        throw new IllegalArgumentException("Unknown key name: " + translationKey);
    }

    public static boolean isKeyPressed(int code) {
        return Keyboard.isKeyDown((int)code);
    }

    public static enum Type {
        KEYSYM("key.keyboard", (keyCode, translationKey) -> {
            String string = Keyboard.getKeyName((int)keyCode);
            return string != null ? Text.literal(string) : Text.translatable(translationKey);
        }),
        SCANCODE("scancode", (scanCode, translationKey) -> Text.translatable(translationKey)),
        MOUSE("key.mouse", (buttonCode, translationKey) -> StringTranslate.getInstance().containsTranslateKey(translationKey) ? Text.translatable(translationKey) : Text.translatable("key.mouseButton", buttonCode + 1));

        private final Map<Integer, Key> keys = new HashMap<Integer, Key>();
        final String name;
        final BiFunction<Integer, String, Text> displayTextCreator;

        private static void mapKey(Type type, String translationKey, int keyCode) {
            Key key = new Key(translationKey, type, keyCode);
            type.keys.put(keyCode, key);
        }

        private Type(String name, BiFunction<Integer, String, Text> displayTextCreator) {
            this.name = name;
            this.displayTextCreator = displayTextCreator;
        }

        public Key createFromCode(int code) {
            return this.keys.computeIfAbsent(code, i -> {
                if (this == MOUSE) {
                    Integer n = i;
                    i = i + 1;
                }
                return new Key(this.name + "." + i, this, (int)i);
            });
        }

        static {
            Type.mapKey(KEYSYM, "key.keyboard.unknown", 0);
            Type.mapKey(MOUSE, "key.mouse.left", 0);
            Type.mapKey(MOUSE, "key.mouse.right", 1);
            Type.mapKey(MOUSE, "key.mouse.middle", 2);
            Type.mapKey(MOUSE, "key.mouse.4", 3);
            Type.mapKey(MOUSE, "key.mouse.5", 4);
            Type.mapKey(MOUSE, "key.mouse.6", 5);
            Type.mapKey(MOUSE, "key.mouse.7", 6);
            Type.mapKey(MOUSE, "key.mouse.8", 7);
            Type.mapKey(KEYSYM, "key.keyboard.0", 11);
            Type.mapKey(KEYSYM, "key.keyboard.1", 2);
            Type.mapKey(KEYSYM, "key.keyboard.2", 3);
            Type.mapKey(KEYSYM, "key.keyboard.3", 4);
            Type.mapKey(KEYSYM, "key.keyboard.4", 5);
            Type.mapKey(KEYSYM, "key.keyboard.5", 6);
            Type.mapKey(KEYSYM, "key.keyboard.6", 7);
            Type.mapKey(KEYSYM, "key.keyboard.7", 8);
            Type.mapKey(KEYSYM, "key.keyboard.8", 9);
            Type.mapKey(KEYSYM, "key.keyboard.9", 10);
            Type.mapKey(KEYSYM, "key.keyboard.a", 30);
            Type.mapKey(KEYSYM, "key.keyboard.b", 48);
            Type.mapKey(KEYSYM, "key.keyboard.c", 46);
            Type.mapKey(KEYSYM, "key.keyboard.d", 32);
            Type.mapKey(KEYSYM, "key.keyboard.e", 18);
            Type.mapKey(KEYSYM, "key.keyboard.f", 33);
            Type.mapKey(KEYSYM, "key.keyboard.g", 34);
            Type.mapKey(KEYSYM, "key.keyboard.h", 35);
            Type.mapKey(KEYSYM, "key.keyboard.i", 23);
            Type.mapKey(KEYSYM, "key.keyboard.j", 36);
            Type.mapKey(KEYSYM, "key.keyboard.k", 37);
            Type.mapKey(KEYSYM, "key.keyboard.l", 38);
            Type.mapKey(KEYSYM, "key.keyboard.m", 50);
            Type.mapKey(KEYSYM, "key.keyboard.n", 49);
            Type.mapKey(KEYSYM, "key.keyboard.o", 24);
            Type.mapKey(KEYSYM, "key.keyboard.p", 25);
            Type.mapKey(KEYSYM, "key.keyboard.q", 16);
            Type.mapKey(KEYSYM, "key.keyboard.r", 19);
            Type.mapKey(KEYSYM, "key.keyboard.s", 31);
            Type.mapKey(KEYSYM, "key.keyboard.t", 20);
            Type.mapKey(KEYSYM, "key.keyboard.u", 22);
            Type.mapKey(KEYSYM, "key.keyboard.v", 47);
            Type.mapKey(KEYSYM, "key.keyboard.w", 17);
            Type.mapKey(KEYSYM, "key.keyboard.x", 45);
            Type.mapKey(KEYSYM, "key.keyboard.y", 21);
            Type.mapKey(KEYSYM, "key.keyboard.z", 44);
            Type.mapKey(KEYSYM, "key.keyboard.f1", 59);
            Type.mapKey(KEYSYM, "key.keyboard.f2", 60);
            Type.mapKey(KEYSYM, "key.keyboard.f3", 61);
            Type.mapKey(KEYSYM, "key.keyboard.f4", 62);
            Type.mapKey(KEYSYM, "key.keyboard.f5", 63);
            Type.mapKey(KEYSYM, "key.keyboard.f6", 64);
            Type.mapKey(KEYSYM, "key.keyboard.f7", 65);
            Type.mapKey(KEYSYM, "key.keyboard.f8", 66);
            Type.mapKey(KEYSYM, "key.keyboard.f9", 67);
            Type.mapKey(KEYSYM, "key.keyboard.f10", 68);
            Type.mapKey(KEYSYM, "key.keyboard.f11", 87);
            Type.mapKey(KEYSYM, "key.keyboard.f12", 88);
            Type.mapKey(KEYSYM, "key.keyboard.f13", 100);
            Type.mapKey(KEYSYM, "key.keyboard.f14", 101);
            Type.mapKey(KEYSYM, "key.keyboard.f15", 102);
            Type.mapKey(KEYSYM, "key.keyboard.f16", 103);
            Type.mapKey(KEYSYM, "key.keyboard.f17", 104);
            Type.mapKey(KEYSYM, "key.keyboard.f18", 105);
            Type.mapKey(KEYSYM, "key.keyboard.f19", 113);
            Type.mapKey(KEYSYM, "key.keyboard.f20", 0);
            Type.mapKey(KEYSYM, "key.keyboard.f21", 0);
            Type.mapKey(KEYSYM, "key.keyboard.f22", 0);
            Type.mapKey(KEYSYM, "key.keyboard.f23", 0);
            Type.mapKey(KEYSYM, "key.keyboard.f24", 0);
            Type.mapKey(KEYSYM, "key.keyboard.f25", 0);
            Type.mapKey(KEYSYM, "key.keyboard.num.lock", 69);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.0", 82);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.1", 79);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.2", 80);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.3", 81);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.4", 75);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.5", 76);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.6", 77);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.7", 71);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.8", 72);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.9", 73);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.add", 78);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.decimal", 83);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.enter", 156);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.equal", 141);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.multiply", 55);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.divide", 181);
            Type.mapKey(KEYSYM, "key.keyboard.keypad.subtract", 74);
            Type.mapKey(KEYSYM, "key.keyboard.down", 208);
            Type.mapKey(KEYSYM, "key.keyboard.left", 203);
            Type.mapKey(KEYSYM, "key.keyboard.right", 205);
            Type.mapKey(KEYSYM, "key.keyboard.up", 200);
            Type.mapKey(KEYSYM, "key.keyboard.apostrophe", 40);
            Type.mapKey(KEYSYM, "key.keyboard.backslash", 43);
            Type.mapKey(KEYSYM, "key.keyboard.comma", 51);
            Type.mapKey(KEYSYM, "key.keyboard.equal", 13);
            Type.mapKey(KEYSYM, "key.keyboard.grave.accent", 41);
            Type.mapKey(KEYSYM, "key.keyboard.left.bracket", 26);
            Type.mapKey(KEYSYM, "key.keyboard.minus", 12);
            Type.mapKey(KEYSYM, "key.keyboard.period", 52);
            Type.mapKey(KEYSYM, "key.keyboard.right.bracket", 27);
            Type.mapKey(KEYSYM, "key.keyboard.semicolon", 39);
            Type.mapKey(KEYSYM, "key.keyboard.slash", 53);
            Type.mapKey(KEYSYM, "key.keyboard.space", 57);
            Type.mapKey(KEYSYM, "key.keyboard.tab", 15);
            Type.mapKey(KEYSYM, "key.keyboard.left.alt", 56);
            Type.mapKey(KEYSYM, "key.keyboard.left.control", 29);
            Type.mapKey(KEYSYM, "key.keyboard.left.shift", 42);
            Type.mapKey(KEYSYM, "key.keyboard.left.win", 219);
            Type.mapKey(KEYSYM, "key.keyboard.right.alt", 184);
            Type.mapKey(KEYSYM, "key.keyboard.right.control", 157);
            Type.mapKey(KEYSYM, "key.keyboard.right.shift", 54);
            Type.mapKey(KEYSYM, "key.keyboard.right.win", 220);
            Type.mapKey(KEYSYM, "key.keyboard.enter", 28);
            Type.mapKey(KEYSYM, "key.keyboard.escape", 1);
            Type.mapKey(KEYSYM, "key.keyboard.backspace", 14);
            Type.mapKey(KEYSYM, "key.keyboard.delete", 211);
            Type.mapKey(KEYSYM, "key.keyboard.end", 207);
            Type.mapKey(KEYSYM, "key.keyboard.home", 199);
            Type.mapKey(KEYSYM, "key.keyboard.insert", 210);
            Type.mapKey(KEYSYM, "key.keyboard.page.down", 209);
            Type.mapKey(KEYSYM, "key.keyboard.page.up", 201);
            Type.mapKey(KEYSYM, "key.keyboard.caps.lock", 58);
            Type.mapKey(KEYSYM, "key.keyboard.pause", 197);
            Type.mapKey(KEYSYM, "key.keyboard.scroll.lock", 70);
            Type.mapKey(KEYSYM, "key.keyboard.menu", 0);
            Type.mapKey(KEYSYM, "key.keyboard.print.screen", 183);
            Type.mapKey(KEYSYM, "key.keyboard.world.1", 0);
            Type.mapKey(KEYSYM, "key.keyboard.world.2", 0);
        }
    }

    public static final class Key {
        private final String translationKey;
        private final Type type;
        private final int keyCode;
        private final Text displayText;
        static final Map<String, Key> KEYS_BY_ID = Maps.newHashMap();

        Key(String translationKey, Type type, int keyCode) {
            this.translationKey = translationKey;
            this.type = type;
            this.keyCode = keyCode;
            this.displayText = type.displayTextCreator.apply(keyCode, translationKey);
            KEYS_BY_ID.put(translationKey, this);
        }

        public Type getCategory() {
            return this.type;
        }

        public int getCode() {
            return this.keyCode;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public Text getLocalizedText() {
            return this.displayText;
        }

        public OptionalInt toInt() {
            if (this.keyCode >= 48 && this.keyCode <= 57) {
                return OptionalInt.of(this.keyCode - 48);
            }
            return this.keyCode >= 320 && this.keyCode <= 329 ? OptionalInt.of(this.keyCode - 320) : OptionalInt.empty();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                Key key = (Key)object;
                return this.keyCode == key.keyCode && this.type == key.type;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.keyCode});
        }

        public String toString() {
            return this.translationKey;
        }
    }
}

