/*
 * Decompiled with CFR 0.152.
 */
package shims.java.net.minecraft.client.search;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class SuffixArray<T> {
    private static final boolean PRINT_COMPARISONS = Boolean.parseBoolean(System.getProperty("SuffixArray.printComparisons", "false"));
    private static final boolean PRINT_ARRAY = Boolean.parseBoolean(System.getProperty("SuffixArray.printArray", "false"));
    private static final Logger LOGGER = Logger.getLogger("SuffixArray");
    private static final int END_OF_TEXT_MARKER = -1;
    private static final int END_OF_DATA = -2;
    protected final List<T> objects = Lists.newArrayList();
    private final IntList characters = new IntArrayList();
    private final IntList textStarts = new IntArrayList();
    private IntList suffixIndexToObjectIndex = new IntArrayList();
    private IntList offsetInText = new IntArrayList();
    private int maxTextLength;

    public void add(T object, String text) {
        this.maxTextLength = Math.max(this.maxTextLength, text.length());
        int i = this.objects.size();
        this.objects.add(object);
        this.textStarts.add(this.characters.size());
        for (int j = 0; j < text.length(); ++j) {
            this.suffixIndexToObjectIndex.add(i);
            this.offsetInText.add(j);
            this.characters.add((int)text.charAt(j));
        }
        this.suffixIndexToObjectIndex.add(i);
        this.offsetInText.add(text.length());
        this.characters.add(-1);
    }

    public void build() {
        int j;
        int i = this.characters.size();
        int[] is = new int[i];
        int[] js = new int[i];
        int[] ks = new int[i];
        int[] ls = new int[i];
        IntComparator intComparator = (ix, jx) -> js[ix] == js[jx] ? Integer.compare(ks[ix], ks[jx]) : Integer.compare(js[ix], js[jx]);
        Swapper swapper = (ix, jx) -> {
            if (ix != jx) {
                int kx = js[ix];
                js[ix] = js[jx];
                js[jx] = kx;
                kx = ks[ix];
                ks[ix] = ks[jx];
                ks[jx] = kx;
                kx = ls[ix];
                ls[ix] = ls[jx];
                ls[jx] = kx;
            }
        };
        for (j = 0; j < i; ++j) {
            is[j] = this.characters.getInt(j);
        }
        j = 1;
        int k = Math.min(i, this.maxTextLength);
        while (j * 2 < k) {
            int l = 0;
            while (l < i) {
                js[l] = is[l];
                ks[l] = l + j < i ? is[l + j] : -2;
                ls[l] = l++;
            }
            it.unimi.dsi.fastutil.Arrays.quickSort((int)0, (int)i, (IntComparator)intComparator, (Swapper)swapper);
            for (l = 0; l < i; ++l) {
                is[ls[l]] = l > 0 && js[l] == js[l - 1] && ks[l] == ks[l - 1] ? is[ls[l - 1]] : l;
            }
            j *= 2;
        }
        IntList intList = this.suffixIndexToObjectIndex;
        IntList intList2 = this.offsetInText;
        this.suffixIndexToObjectIndex = new IntArrayList(intList.size());
        this.offsetInText = new IntArrayList(intList2.size());
        for (int m = 0; m < i; ++m) {
            int n = ls[m];
            this.suffixIndexToObjectIndex.add(intList.getInt(n));
            this.offsetInText.add(intList2.getInt(n));
        }
        if (PRINT_ARRAY) {
            this.printArray();
        }
    }

    private void printArray() {
        for (int i = 0; i < this.suffixIndexToObjectIndex.size(); ++i) {
            LOGGER.info(i + this.getDebugString(i));
        }
        LOGGER.info("");
    }

    private String getDebugString(int suffixIndex) {
        int i = this.offsetInText.getInt(suffixIndex);
        int j = this.textStarts.getInt(this.suffixIndexToObjectIndex.getInt(suffixIndex));
        StringBuilder stringBuilder = new StringBuilder();
        int k = 0;
        while (j + k < this.characters.size()) {
            int l;
            if (k == i) {
                stringBuilder.append('^');
            }
            if ((l = this.characters.getInt(j + k)) == -1) break;
            stringBuilder.append((char)l);
            ++k;
        }
        return stringBuilder.toString();
    }

    private int compare(String string, int suffixIndex) {
        int i = this.textStarts.getInt(this.suffixIndexToObjectIndex.getInt(suffixIndex));
        int j = this.offsetInText.getInt(suffixIndex);
        for (int k = 0; k < string.length(); ++k) {
            char d;
            int l = this.characters.getInt(i + j + k);
            if (l == -1) {
                return 1;
            }
            char c = string.charAt(k);
            if (c < (d = (char)l)) {
                return -1;
            }
            if (c <= d) continue;
            return 1;
        }
        return 0;
    }

    public List<T> findAll(String text) {
        int m;
        int l;
        int i = this.suffixIndexToObjectIndex.size();
        int j = 0;
        int k = i;
        while (j < k) {
            l = j + (k - j) / 2;
            m = this.compare(text, l);
            if (PRINT_COMPARISONS) {
                LOGGER.info("comparing lower \"" + text + "\" with " + l + " \"" + this.getDebugString(l) + "\": " + m);
            }
            if (m > 0) {
                j = l + 1;
                continue;
            }
            k = l;
        }
        if (j >= 0 && j < i) {
            l = j;
            k = i;
            while (j < k) {
                m = j + (k - j) / 2;
                int n = this.compare(text, m);
                if (PRINT_COMPARISONS) {
                    LOGGER.info("comparing upper \"" + text + "\" with " + m + " \"" + this.getDebugString(m) + "\": " + n);
                }
                if (n >= 0) {
                    j = m + 1;
                    continue;
                }
                k = m;
            }
            m = j;
            IntOpenHashSet intSet = new IntOpenHashSet();
            for (int o = l; o < m; ++o) {
                intSet.add(this.suffixIndexToObjectIndex.getInt(o));
            }
            int[] is = intSet.toIntArray();
            Arrays.sort(is);
            LinkedHashSet set = Sets.newLinkedHashSet();
            for (int p : is) {
                set.add(this.objects.get(p));
            }
            return Lists.newArrayList((Iterable)set);
        }
        return Collections.emptyList();
    }
}

