/*
 * Decompiled with CFR 0.152.
 */
package shims.java.com.unascribed.retroemi;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.input.EmiInput;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.screen.EmiScreen;
import dev.emi.emi.screen.EmiScreenManager;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import moddedmite.emi.api.EMIGuiContainerCreative;
import moddedmite.emi.util.MinecraftServerHelper;
import net.minecraft.Block;
import net.minecraft.EntityPlayer;
import net.minecraft.FontRenderer;
import net.minecraft.GuiContainer;
import net.minecraft.GuiScreen;
import net.minecraft.ItemPotion;
import net.minecraft.ItemStack;
import net.minecraft.Minecraft;
import net.minecraft.PotionEffect;
import net.minecraft.RenderItem;
import net.minecraft.ResourceLocation;
import net.minecraft.ScaledResolution;
import net.minecraft.StringTranslate;
import net.minecraft.Tessellator;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import shims.java.net.minecraft.client.gui.tooltip.TooltipBackgroundRenderer;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.client.gui.tooltip.TooltipPositioner;
import shims.java.net.minecraft.client.util.math.Vec2i;
import shims.java.net.minecraft.tag.WildcardItemTag;

public class RetroEMI {
    public static final RetroEMI instance = new RetroEMI();
    public final RenderItem itemRenderer = !MinecraftServerHelper.isServer() ? new RenderItem() : null;
    private static final List<Runnable> tickQueue = new ArrayList<Runnable>();
    public static final IntSet heldButtons = new IntOpenHashSet();

    private RetroEMI() {
    }

    public static boolean isSideLit(ItemStack item) {
        Block b;
        if (item.itemID < Block.blocksList.length && (b = Block.blocksList[item.itemID]) != null) {
            return RetroEMI.doesRenderIDRenderItemIn3D(b.getRenderType());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeOnMainThread(Runnable r) {
        List<Runnable> list = tickQueue;
        synchronized (list) {
            tickQueue.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        Runnable[] runnableArray = tickQueue;
        synchronized (tickQueue) {
            Runnable[] queue = tickQueue.toArray(new Runnable[tickQueue.size()]);
            tickQueue.clear();
            // ** MonitorExit[var1] (shouldn't be in output)
            for (Runnable r : queue) {
                r.run();
            }
            return;
        }
    }

    public static Collection<PotionEffect> getEffects(EmiStack stack) {
        if (stack.getItemStack().getItem() instanceof ItemPotion) {
            ItemPotion p = (ItemPotion)stack.getItemStack().getItem();
            return p.getEffects(stack.getItemStack());
        }
        return Collections.emptyList();
    }

    public static List<String> wrapLines(String str, int cols) {
        ArrayList<String> li = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        for (String line : str.split("\n")) {
            int w = -1;
            for (String word : line.split(" ")) {
                if (w + 1 + word.length() > cols) {
                    li.add(buf.toString());
                    buf.setLength(0);
                    w = 0;
                } else {
                    if (w != -1) {
                        buf.append(" ");
                    }
                    ++w;
                }
                while (word.length() > cols) {
                    li.add(word.substring(0, cols));
                    word = word.substring(cols);
                }
                buf.append(word);
                w += word.length();
            }
            if (buf.length() > 0) {
                li.add(buf.toString());
            }
            buf.setLength(0);
        }
        return li;
    }

    public static String join(List<String> strs, String delim) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : strs) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static void offerOrDrop(EntityPlayer player, ItemStack stack) {
        if (!player.inventory.addItemStackToInventory(stack)) {
            player.dropPlayerItem(stack);
        }
    }

    public static boolean canCombine(ItemStack a, ItemStack b) {
        return a == null || b == null ? a == b : a.isItemEqual(b) && ItemStack.areItemStackTagsEqual((ItemStack)a, (ItemStack)b);
    }

    public static void renderModernTooltip(GuiScreen screen, List<TooltipComponent> components, int x, int y, int maxWidth, TooltipPositioner positioner) {
        TooltipComponent tooltipComponent2;
        int r;
        FontRenderer textRenderer = Minecraft.getMinecraft().fontRenderer;
        if (components.isEmpty()) {
            return;
        }
        int i = 0;
        int j = components.size() == 1 ? -2 : 0;
        for (TooltipComponent tooltipComponent : components) {
            int k = tooltipComponent.getWidth(textRenderer);
            if (k > i) {
                i = k;
            }
            j += tooltipComponent.getHeight();
        }
        int l = i;
        int m = j;
        Vec2i vector2ic = positioner.getPosition(screen, x, y, l, m);
        int n = vector2ic.x();
        int o = vector2ic.y();
        GL11.glPushMatrix();
        int p = 400;
        Tessellator tess = Tessellator.instance;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        EmiDrawContext.instance().context.zLevel += 300.0f;
        TooltipBackgroundRenderer.render((builder, startX, startY, endX, endY, z, colorStart, colorEnd) -> EmiDrawContext.instance().context.drawGradientRect(startX, startY, endX, endY, colorStart, colorEnd), tess, n, o, l, m, 400);
        EmiDrawContext.instance().context.zLevel -= 300.0f;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)400.0f);
        int q = o;
        for (r = 0; r < components.size(); ++r) {
            tooltipComponent2 = components.get(r);
            tooltipComponent2.drawText(textRenderer, n, q);
            q += tooltipComponent2.getHeight() + (r == 0 ? 2 : 0);
        }
        q = o;
        for (r = 0; r < components.size(); ++r) {
            tooltipComponent2 = components.get(r);
            tooltipComponent2.drawItems(textRenderer, n, q);
            q += tooltipComponent2.getHeight() + (r == 0 ? 2 : 0);
        }
        GL11.glPopMatrix();
    }

    public static Object emify(GuiScreen screen) {
        if (screen instanceof EmiScreen) {
            EmiScreen es = (EmiScreen)screen;
            return es;
        }
        if (screen instanceof GuiContainer) {
            final GuiContainer hs = (GuiContainer)screen;
            return new EmiScreen(){

                @Override
                public int emi$getLeft() {
                    return ((EMIGuiContainerCreative)hs).getGuiLeft();
                }

                @Override
                public int emi$getRight() {
                    return ((EMIGuiContainerCreative)hs).getGuiLeft() + ((EMIGuiContainerCreative)hs).getxSize();
                }

                @Override
                public int emi$getTop() {
                    return ((EMIGuiContainerCreative)hs).getGuiTop();
                }

                @Override
                public int emi$getBottom() {
                    return ((EMIGuiContainerCreative)hs).getGuiTop() + ((EMIGuiContainerCreative)hs).getySize();
                }
            };
        }
        return screen;
    }

    public static boolean handleMouseInput() {
        try {
            Minecraft client = Minecraft.getMinecraft();
            GuiScreen screen = client.currentScreen;
            if (screen instanceof GuiContainer) {
                int dwheel;
                GuiContainer hs = (GuiContainer)screen;
                ScaledResolution sr = new ScaledResolution(client.gameSettings, client.displayWidth, client.displayHeight);
                double xScale = sr.getScaledWidth_double() / (double)client.displayWidth;
                double yScale = sr.getScaledHeight_double() / (double)client.displayHeight;
                double mx = (double)Mouse.getEventX() * xScale;
                double my = (double)(client.displayHeight - Mouse.getEventY()) * yScale;
                int button = Mouse.getEventButton();
                if (button == -1) {
                    for (Integer btn : heldButtons) {
                        if (!EmiScreenManager.mouseDragged(mx, my, btn, (double)Mouse.getDX() * xScale, (double)Mouse.getDY() * -yScale)) continue;
                        return true;
                    }
                } else if (Mouse.getEventButtonState()) {
                    heldButtons.add(button);
                    if (EmiScreenManager.mouseClicked(mx, my, button)) {
                        return true;
                    }
                } else {
                    heldButtons.remove(button);
                    if (EmiScreenManager.mouseReleased(mx, my, button)) {
                        return true;
                    }
                }
                if ((dwheel = Mouse.getEventDWheel()) != 0 && EmiScreenManager.mouseScrolled(mx, my, (double)dwheel / 120.0)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            EmiLog.error("Error while handling mouse event", e);
        }
        return false;
    }

    public static boolean handleKeyboardInput() {
        try {
            GuiScreen screen = Minecraft.getMinecraft().currentScreen;
            int k = Keyboard.getEventKey();
            char c = Keyboard.getEventCharacter();
            if (screen instanceof GuiContainer && (Keyboard.getEventKeyState() || k == 0 && Character.isDefined(c))) {
                if (Keyboard.getEventCharacter() != '\u0000' && !Character.isISOControl(Keyboard.getEventCharacter()) && EmiScreenManager.search.charTyped(Keyboard.getEventCharacter(), EmiInput.getCurrentModifiers())) {
                    return true;
                }
                if (EmiScreenManager.keyPressed(Keyboard.getEventKey(), 0, EmiInput.getCurrentModifiers())) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            EmiLog.error("Error while handling key press", e);
        }
        return false;
    }

    public static EmiIngredient wildcardIngredient(ItemStack stack) {
        if (stack != null && stack.getItemSubtype() == Short.MAX_VALUE) {
            EmiIngredient item = EmiIngredient.of(new WildcardItemTag(stack.getItem()));
            if (item.getEmiStacks().size() == 1) {
                return item;
            }
            return EmiIngredient.of(List.of(item), 65L);
        }
        return EmiStack.of(stack, 1L);
    }

    public static EmiIngredient wildcardIngredientWithStackSize(ItemStack stack) {
        if (stack != null && stack.getItemSubtype() == Short.MAX_VALUE) {
            EmiIngredient item = EmiIngredient.of(new WildcardItemTag(stack.getItem()));
            if (item.getEmiStacks().size() == 1) {
                return item;
            }
            return EmiIngredient.of(List.of(item), (long)(stack.stackSize + 64));
        }
        return EmiStack.of(stack);
    }

    public static String compactify(ResourceLocation id) {
        return id.toString().replace("emi:", "\u0113").replace("_", "");
    }

    public static String translate(String s) {
        return StringTranslate.getInstance().translateKey(s);
    }

    public static String translate(String s, Object ... arg) {
        return StringTranslate.getInstance().translateKeyFormat(s, arg);
    }

    public static boolean doesRenderIDRenderItemIn3D(int par0) {
        return par0 == 0 || par0 == 31 || par0 == 39 || par0 == 13 || par0 == 10 || par0 == 11 || par0 == 27 || par0 == 22 || par0 == 21 || par0 == 16 || par0 == 26 || par0 == 32 || par0 == 34 || par0 == 35;
    }
}

