/*
 * Decompiled with CFR 0.152.
 */
package shims.java.com.unascribed.retroemi;

import com.google.common.collect.Lists;
import dev.emi.emi.input.EmiInput;
import java.util.List;
import net.minecraft.GuiScreen;
import net.minecraft.Minecraft;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.Drawable;
import shims.java.net.minecraft.client.gui.Element;
import shims.java.net.minecraft.client.gui.ParentElement;
import shims.java.net.minecraft.text.Text;

public class REMIScreen
extends GuiScreen
implements ParentElement {
    protected final Minecraft client = Minecraft.getMinecraft();
    private int mouseDown = -1;
    private int lastMouseX;
    private int lastMouseY;
    private boolean closing = false;
    protected final Text title;
    private final List<Element> children = Lists.newArrayList();
    private final List<Drawable> drawables = Lists.newArrayList();
    @Nullable
    private Element focused;
    private boolean dragging;

    public REMIScreen(Text title) {
        this.title = title;
    }

    public void initGui() {
        this.closing = false;
        this.mouseDown = -1;
        super.initGui();
        this.children.clear();
        this.drawables.clear();
        this.init();
    }

    public final void drawScreen(int mouseX, int mouseY, float delta) {
        GL11.glEnable((int)32826);
        this.render(DrawContext.INSTANCE, mouseX, mouseY, delta);
        super.drawScreen(mouseX, mouseY, delta);
        if (this.mouseDown != -1) {
            this.mouseDragged(mouseX, mouseY, this.mouseDown, mouseX - this.lastMouseX, mouseY - this.lastMouseY);
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        GL11.glDisable((int)32826);
    }

    public void handleKeyboardInput() {
        super.handleKeyboardInput();
        int k = Keyboard.getEventKey();
        char c = Keyboard.getEventCharacter();
        if (!Keyboard.getEventKeyState() || k == 0 && Character.isDefined(c)) {
            this.keyReleased(Keyboard.getEventKey(), 0, EmiInput.getCurrentModifiers());
        }
    }

    public void handleMouseInput() {
        super.handleMouseInput();
        if (Mouse.getEventDWheel() != 0) {
            this.mouseScrolled(this.lastMouseX, this.lastMouseY, (double)Mouse.getEventDWheel() / 120.0);
        }
    }

    public final void keyTyped(char character, int keyCode) {
        if (keyCode == 1 && this.shouldCloseOnEsc()) {
            this.close();
            return;
        }
        int mod = EmiInput.getCurrentModifiers();
        this.keyPressed(keyCode, 0, mod);
        if (character != '\u0000' && !Character.isISOControl(character)) {
            this.charTyped(character, mod);
        }
    }

    public final void mouseClicked(int mouseX, int mouseY, int button) {
        this.mouseClicked(mouseX, mouseY, button);
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.mouseDown = button;
    }

    public final void mouseMovedOrUp(int mouseX, int mouseY, int button) {
        this.mouseReleased(mouseX, mouseY, button);
        if (button == this.mouseDown) {
            this.mouseDown = -1;
        }
    }

    public final boolean doesGuiPauseGame() {
        return this.shouldPause();
    }

    public final void onGuiClosed() {
        this.mouseDown = -1;
        if (this.closing) {
            return;
        }
        this.closing = true;
        this.close();
    }

    protected boolean shouldCloseOnEsc() {
        return true;
    }

    protected void init() {
    }

    protected boolean shouldPause() {
        return super.doesGuiPauseGame();
    }

    protected void render(DrawContext raw, int mouseX, int mouseY, float delta) {
        for (Drawable drawable : this.drawables) {
            drawable.render(raw, mouseX, mouseY, delta);
        }
    }

    protected void renderBackgroundTexture(DrawContext ctx) {
        this.drawBackground(0);
    }

    protected void renderBackground(DrawContext ctx) {
        this.drawDefaultBackground();
    }

    protected void close() {
        super.onGuiClosed();
        this.client.displayGuiScreen(null);
    }

    @Override
    public final boolean isDragging() {
        return this.dragging;
    }

    @Override
    public final void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    @Override
    @Nullable
    public Element getFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(@Nullable Element focused) {
        if (this.focused != null) {
            this.focused.setFocused(false);
        }
        if (focused != null) {
            focused.setFocused(true);
        }
        this.focused = focused;
    }

    @Override
    public List<? extends Element> children() {
        return this.children;
    }

    protected <T extends Element & Drawable> T addDrawableChild(T drawableElement) {
        this.drawables.add(drawableElement);
        return this.addSelectableChild(drawableElement);
    }

    protected <T extends Drawable> T addDrawable(T drawable) {
        this.drawables.add(drawable);
        return drawable;
    }

    protected <T extends Element> T addSelectableChild(T child) {
        this.children.add(child);
        return child;
    }

    protected void remove(Element child) {
        if (child instanceof Drawable) {
            this.drawables.remove((Drawable)((Object)child));
        }
        this.children.remove(child);
    }
}

