/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import moddedmite.emi.api.recipe.MITEEmiRecipeCategories;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import shims.java.net.minecraft.util.SyntheticIdentifier;

public class EmiFoodRecipe
implements EmiRecipe {
    private ResourceLocation VANILLA = new ResourceLocation("textures/gui/icons.png");
    private ResourceLocation TEXTURE = new ResourceLocation("emi", "textures/gui/icons_food.png");
    private ResourceLocation BEEF = new ResourceLocation("textures/items/beef_cooked.png");
    private ResourceLocation CARROT = new ResourceLocation("textures/items/carrot.png");
    private ResourceLocation SUGAR = new ResourceLocation("textures/items/sugar.png");
    private int y = 5;
    private final int hunger;
    private final int saturationModifier;
    private final int phytonutrients;
    private final int protein;
    private final int sugar;
    private final EmiStack foodItem;

    public EmiFoodRecipe(ItemStack foodStack) {
        Item food = foodStack.getItem();
        this.hunger = food.getNutrition();
        this.saturationModifier = food.getSatiation(null);
        this.phytonutrients = food.getPhytonutrients() / 8000;
        this.protein = food.getProtein() / 8000;
        this.sugar = food.getSugarContent() / 8000;
        this.foodItem = EmiStack.of(foodStack);
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return MITEEmiRecipeCategories.FOOD;
    }

    @Override
    @Nullable
    public ResourceLocation getId() {
        return new SyntheticIdentifier(this);
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of(this.foodItem.getEmiStacks()));
    }

    @Override
    public List<EmiIngredient> getCatalysts() {
        return List.of(EmiIngredient.of(this.foodItem.getEmiStacks()));
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of();
    }

    @Override
    public boolean supportsRecipeTree() {
        return false;
    }

    @Override
    public int getDisplayWidth() {
        return 120;
    }

    @Override
    public int getDisplayHeight() {
        return 58;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        int haunchXCoord;
        int haunchUCoord;
        int i;
        for (i = 0; i < this.hunger / 2; ++i) {
            widgets.addTexture(this.VANILLA, 10 * i + 25, this.y, 9, 9, 16, 27);
            if (i - 1 == this.hunger / 2) continue;
            widgets.addTexture(this.VANILLA, 10 * i + 25, this.y, 9, 9, 52, 27);
        }
        if (this.hunger % 2 != 0) {
            haunchUCoord = 61;
            haunchXCoord = 10 * i + 25;
            widgets.addTexture(this.VANILLA, haunchXCoord, this.y, 9, 9, 16, 27);
            widgets.addTexture(this.VANILLA, haunchXCoord, this.y, 9, 9, haunchUCoord, 27);
        }
        this.checkY(this.hunger);
        for (i = 0; i < this.saturationModifier / 2; ++i) {
            widgets.addTexture(this.TEXTURE, 10 * i + 25, this.y, 9, 9, 34, 18);
            if (i - 1 == this.saturationModifier / 2) continue;
            widgets.addTexture(this.TEXTURE, 10 * i + 25, this.y, 9, 9, 43, 18);
        }
        if (this.saturationModifier % 2 != 0) {
            haunchUCoord = 52;
            haunchXCoord = 10 * i + 25;
            widgets.addTexture(this.TEXTURE, haunchXCoord, this.y, 9, 9, 34, 18);
            widgets.addTexture(this.TEXTURE, haunchXCoord, this.y, 9, 9, haunchUCoord, 18);
        }
        this.checkY(this.saturationModifier);
        for (i = 0; i < this.phytonutrients / 2; ++i) {
            widgets.addTexture(this.TEXTURE, 10 * i + 25, this.y, 9, 9, 61, 18);
            if (i - 1 == this.phytonutrients / 2) continue;
            widgets.addTexture(this.TEXTURE, 10 * i + 25, this.y, 9, 9, 70, 18);
        }
        if (this.phytonutrients % 2 != 0) {
            haunchUCoord = 79;
            haunchXCoord = 10 * i + 25;
            widgets.addTexture(this.TEXTURE, haunchXCoord, this.y, 9, 9, 61, 18);
            widgets.addTexture(this.TEXTURE, haunchXCoord, this.y, 9, 9, haunchUCoord, 18);
        }
        this.checkY(this.phytonutrients);
        for (i = 0; i < this.protein / 2; ++i) {
            widgets.addTexture(this.TEXTURE, 10 * i + 25, this.y, 9, 9, 88, 18);
            if (i - 1 == this.protein / 2) continue;
            widgets.addTexture(this.TEXTURE, 10 * i + 25, this.y, 9, 9, 97, 18);
        }
        if (this.protein % 2 != 0) {
            haunchUCoord = 106;
            haunchXCoord = 10 * i + 25;
            widgets.addTexture(this.TEXTURE, haunchXCoord, this.y, 9, 9, 88, 18);
            widgets.addTexture(this.TEXTURE, haunchXCoord, this.y, 9, 9, haunchUCoord, 18);
        }
        this.checkY(this.protein);
        for (i = 0; i < this.sugar; ++i) {
            widgets.addTexture(this.TEXTURE, 10 * i + 25, this.y, 9, 9, 115, 18);
            widgets.addTexture(this.TEXTURE, 10 * i + 25, this.y, 9, 9, 124, 18);
        }
        this.checkY(this.sugar);
        this.y = 5;
        widgets.addSlot(this.foodItem, 0, 0).recipeContext(this);
    }

    public int getHunger() {
        return this.hunger;
    }

    public EmiStack getFoodItem() {
        return this.foodItem;
    }

    public void checkY(int value) {
        if (value > 0) {
            this.y += 10;
        }
    }
}

