/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.emi.recipe;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import moddedmite.emi.api.recipe.MITEEmiRecipeCategories;
import net.minecraft.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import shims.java.net.minecraft.util.SyntheticIdentifier;

public class EmiEnchantRecipe
implements EmiRecipe {
    private final EmiStack enchantItem;
    private final EmiStack enchantedItem;
    private final int experienceCost;

    public EmiEnchantRecipe(EmiStack enchantItem, EmiStack enchantedItem, int experienceCost) {
        this.enchantItem = enchantItem;
        this.enchantedItem = enchantedItem;
        this.experienceCost = experienceCost;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return MITEEmiRecipeCategories.ENCHANT;
    }

    @Override
    @Nullable
    public ResourceLocation getId() {
        return new SyntheticIdentifier(this);
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of(this.enchantItem.getEmiStacks()));
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of((EmiStack)EmiIngredient.of(this.enchantItem.getEmiStacks()));
    }

    @Override
    public int getDisplayWidth() {
        return 72;
    }

    @Override
    public int getDisplayHeight() {
        return 32;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        int r = 64;
        int g = 160;
        int b = 32;
        int color = (r << 16) + (g << 8) + b;
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 25, 12);
        widgets.addText(EmiPort.translatable("emi.exp_cost.items", String.format("%1d", this.experienceCost)), 25, 2, color, true);
        widgets.addSlot(this.enchantItem, 0, 12);
        widgets.addSlot(this.enchantedItem, 54, 12);
    }
}

