/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.emi.platform.fish;

import dev.emi.emi.InputPair;
import dev.emi.emi.Prototype;
import dev.emi.emi.VanillaPlugin;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.recipe.EmiBrewingRecipe;
import dev.emi.emi.registry.EmiPluginContainer;
import dev.emi.emi.runtime.EmiLog;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import moddedmite.emi.MITEPlugin;
import moddedmite.emi.util.TileEntityFurnaceHelper;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.EntityPlayer;
import net.minecraft.Item;
import net.minecraft.ItemPotion;
import net.minecraft.ItemStack;
import net.minecraft.Minecraft;
import net.minecraft.PotionEffect;
import net.minecraft.ResourceLocation;
import net.minecraft.Slot;
import net.minecraft.TileEntityBrewingStand;
import net.xiaoyu233.fml.FishModLoader;
import org.apache.commons.lang3.text.WordUtils;
import shims.java.com.unascribed.retroemi.EmiMultiPlugin;
import shims.java.com.unascribed.retroemi.NamedEmiPlugin;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.text.Text;
import shims.java.net.minecraft.util.SyntheticIdentifier;

public class EmiAgnosFish
extends EmiAgnos {
    @Override
    protected boolean isForgeAgnos() {
        return false;
    }

    public static void poke() {
    }

    @Override
    protected String getModNameAgnos(String namespace) {
        if (namespace.equals("c")) {
            return "Common";
        }
        Optional container = FishModLoader.getModContainer((String)namespace);
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getMetadata().getName();
        }
        container = FishModLoader.getModContainer((String)namespace.replace('_', '-'));
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getMetadata().getName();
        }
        return WordUtils.capitalizeFully((String)namespace.replace('_', ' '));
    }

    @Override
    protected Path getConfigDirectoryAgnos() {
        return FishModLoader.CONFIG_DIR.toPath();
    }

    @Override
    protected boolean isDevelopmentEnvironmentAgnos() {
        return FishModLoader.isDevelopmentEnvironment();
    }

    @Override
    protected boolean isModLoadedAgnos(String id) {
        return FishModLoader.hasMod((String)id);
    }

    @Override
    protected List<String> getAllModNamesAgnos(String id) {
        return FishModLoader.getModContainer((String)id).stream().map(c -> c.getMetadata().getName()).toList();
    }

    @Override
    protected List<String> getAllModAuthorsAgnos(String id) {
        return FishModLoader.getModContainer((String)id).stream().flatMap(c -> c.getMetadata().getAuthors().stream()).map(p -> p.getName()).distinct().toList();
    }

    @Override
    protected List<EmiPluginContainer> getPluginsAgnos() {
        ArrayList<EmiPluginContainer> plugins = new ArrayList<EmiPluginContainer>(FishModLoader.getEntrypointContainers((String)"emi", EmiPlugin.class).stream().map(p -> new EmiPluginContainer((EmiPlugin)p.getEntrypoint(), p.getProvider().getMetadata().getId())).toList());
        boolean foundMITEPlugins = false;
        for (EmiPluginContainer plugin : plugins) {
            if (!plugin.id().equals("emi")) continue;
            foundMITEPlugins = true;
            break;
        }
        if (!foundMITEPlugins) {
            plugins.add(new EmiPluginContainer(new MITEPlugin(), "mite"));
            plugins.add(new EmiPluginContainer(new VanillaPlugin(), "minecraft"));
        }
        return plugins;
    }

    private Stream<EmiPluginContainer> createPlugin(String clazzName, String id) {
        try {
            Stream<EmiPlugin> stream;
            Class<?> clazz = Class.forName(clazzName);
            if (!EmiPlugin.class.isAssignableFrom(clazz) && !EmiMultiPlugin.class.isAssignableFrom(clazz)) {
                EmiLog.warn("Registered emi entrypoint for nilmod {} does not implement EmiPlugin");
                return null;
            }
            if (!Runnable.class.isAssignableFrom(clazz)) {
                EmiLog.warn("Registered emi entrypoint for nilmod {} does not implement Runnable (this is required for NilLoader entrypoint compliance)");
                return null;
            }
            Object inst = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (inst instanceof EmiPlugin) {
                EmiPlugin ep2 = (EmiPlugin)inst;
                v0 = Stream.of(ep2);
            } else {
                v0 = stream = Stream.empty();
            }
            if (inst instanceof EmiMultiPlugin) {
                EmiMultiPlugin emp = (EmiMultiPlugin)inst;
                stream = Stream.concat(stream, emp.getChildPlugins());
            }
            return stream.map(ep -> {
                Object object;
                if (ep instanceof NamedEmiPlugin) {
                    NamedEmiPlugin n = (NamedEmiPlugin)ep;
                    object = id + "/" + n.getName();
                } else {
                    object = id;
                }
                return new EmiPluginContainer((EmiPlugin)ep, (String)object);
            });
        }
        catch (Throwable t) {
            EmiLog.warn("Unexpected error while attempting to create plugin for nilmod {}");
            return null;
        }
    }

    @Override
    protected void addBrewingRecipesAgnos(EmiRegistry registry) {
        Object iter;
        TileEntityBrewingStand tebs = new TileEntityBrewingStand();
        List<Item> ingredience = Arrays.stream(Item.itemsList).filter(i -> i != null && i.isPotionIngredient()).toList();
        HashMap<InputPair, Prototype> recipes = new HashMap<InputPair, Prototype>();
        IntArrayList potions = new IntArrayList();
        potions.add(0);
        IntLinkedOpenHashSet seenPotions = new IntLinkedOpenHashSet();
        while (!potions.isEmpty()) {
            iter = potions.toIntArray();
            potions.clear();
            for (Object potion : iter) {
                seenPotions.add((int)potion);
                for (Item ing : ingredience) {
                    int result = tebs.getPotionResult((int)potion, new ItemStack(ing));
                    List inputEffects = Item.potion.getEffects((int)potion);
                    List resultEffects = Item.potion.getEffects(result);
                    if ((potion > 0 && inputEffects == resultEffects || inputEffects != null && (inputEffects.equals(resultEffects) || resultEffects == null)) && (ItemPotion.isSplash((int)potion) || !ItemPotion.isSplash((int)result)) || potion == result || seenPotions.contains(result)) continue;
                    potions.add(result);
                    recipes.put(new InputPair(new Prototype(ing), new Prototype((Item)Item.potion, (int)potion)), new Prototype((Item)Item.potion, result));
                }
            }
        }
        iter = recipes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry en = (Map.Entry)iter.next();
            InputPair i2 = (InputPair)en.getKey();
            registry.addRecipe(new EmiBrewingRecipe(EmiStack.of(i2.potion()), EmiStack.of(i2.ingredient()), EmiStack.of((Prototype)en.getValue()), new ResourceLocation("brewing", "/" + SyntheticIdentifier.describe(i2.potion()) + "/" + SyntheticIdentifier.describe(i2.ingredient()) + "/" + SyntheticIdentifier.describe(en.getValue()))));
        }
        registry.removeEmiStacks(arg_0 -> EmiAgnosFish.lambda$addBrewingRecipesAgnos$6((IntSet)seenPotions, arg_0));
        List sorted = recipes.values().stream().filter(p -> p.meta() != 0).distinct().sorted((b, a) -> {
            int i = Boolean.compare(ItemPotion.isSplash((int)a.meta()), ItemPotion.isSplash((int)b.meta()));
            if (i != 0) {
                return i;
            }
            List effA = ((ItemPotion)a.getItem()).getEffects(a.toStack());
            List effB = ((ItemPotion)b.getItem()).getEffects(b.toStack());
            return EmiAgnosFish.listCompare(effA, effB, Comparator.comparingInt(PotionEffect::getPotionID).thenComparingInt(PotionEffect::getAmplifier).thenComparingInt(PotionEffect::getDuration));
        }).map(EmiStack::of).collect(Collectors.toList());
        EmiStack prev = EmiStack.of(new Prototype((Item)Item.potion, 0));
        for (EmiStack potion : sorted) {
            registry.addEmiStackAfter(potion, prev);
        }
    }

    private static <T> int listCompare(List<T> a, List<T> b, Comparator<? super T> cmp) {
        Objects.requireNonNull(cmp);
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        int length = Math.min(a.size(), b.size());
        for (int i = 0; i < length; ++i) {
            int v;
            T ob;
            T oa = a.get(i);
            if (oa == (ob = b.get(i)) || (v = cmp.compare(oa, ob)) == 0) continue;
            return v;
        }
        return a.size() - b.size();
    }

    @Override
    protected List<TooltipComponent> getItemTooltipAgnos(ItemStack stack) {
        List tip = stack.getTooltip((EntityPlayer)Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().gameSettings.advancedItemTooltips, (Slot)null);
        for (int i = 0; i < tip.size(); ++i) {
            tip.set(i, "\u00a7" + (i == 0 ? Integer.toHexString(stack.getRarity().rarityColor) : "7") + (String)tip.get(i));
        }
        return tip.stream().map(Text::literal).map(TooltipComponent::of).toList();
    }

    @Override
    protected boolean canBatchAgnos(ItemStack stack) {
        return false;
    }

    @Override
    protected Map<Prototype, Integer> getFuelMapAgnos() {
        ArrayList pain = new ArrayList();
        for (Item it : Item.itemsList) {
            if (it == null) continue;
            it.getSubItems(it.itemID, it.getCreativeTab(), pain);
        }
        return pain.stream().filter(TileEntityFurnaceHelper::isItemFuelS).map(Prototype::of).distinct().collect(Collectors.toMap(p -> p, p -> p.toStack().getItem().getBurnTime(p.toStack())));
    }

    @Override
    protected Map<Prototype, Integer> getHeatMapAgnos() {
        ArrayList pain = new ArrayList();
        for (Item it : Item.itemsList) {
            if (it == null) continue;
            it.getSubItems(it.itemID, it.getCreativeTab(), pain);
        }
        return pain.stream().filter(TileEntityFurnaceHelper::isItemFuelS).map(Prototype::of).distinct().collect(Collectors.toMap(p -> p, p -> p.toStack().getItem().getHeatLevel(p.toStack())));
    }

    private static /* synthetic */ boolean lambda$addBrewingRecipesAgnos$6(IntSet seenPotions, EmiStack es) {
        return es.getItemStack() != null && es.getItemStack().getItem() == Item.potion && !seenPotions.contains(es.getItemStack().getItemSubtype());
    }

    static {
        EmiAgnos.delegate = new EmiAgnosFish();
    }
}

