/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.emi.mixin.client;

import moddedmite.emi.api.EMIResourceLocation;
import net.minecraft.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ResourceLocation.class})
public class ResourceLocationMixin
implements EMIResourceLocation {
    @Mutable
    @Final
    @Shadow
    private String resourceDomain;
    @Mutable
    @Final
    @Shadow
    private String resourcePath;

    public ResourceLocationMixin(String resourceDomain, String resourcePath) {
        this.resourceDomain = resourceDomain;
        this.resourcePath = resourcePath;
    }

    @Override
    public int compareTo(ResourceLocation that) {
        int i = this.resourcePath.compareTo(that.getResourcePath());
        if (i != 0) {
            return i;
        }
        return this.resourceDomain.compareTo(that.getResourceDomain());
    }

    @Inject(method={"exists"}, at={@At(value="RETURN")}, cancellable=true)
    public void exists(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)true);
    }

    @Override
    public String toPath(String prefix) {
        return "/" + prefix + "/" + this.resourceDomain + "/" + this.resourcePath;
    }
}

