/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiReloadLog;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import moddedmite.emi.api.recipe.MITEEmiRecipeCategories;
import moddedmite.emi.recipe.EmiEnchantRecipe;
import moddedmite.emi.recipe.EmiFoodRecipe;
import moddedmite.emi.util.EnchantmentNameIDTranslator;
import net.minecraft.Block;
import net.minecraft.Enchantment;
import net.minecraft.EnchantmentData;
import net.minecraft.IRecipe;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.ResourceLocation;
import shims.java.net.minecraft.text.Text;

@EmiEntrypoint
public class MITEPlugin
implements EmiPlugin {
    public static final ResourceLocation WIDGETS = new ResourceLocation("textures/recipe/widgets.png");
    public static final EmiTexture SMALL_PLUS = new EmiTexture(WIDGETS, 36, 0, 7, 7);

    public static void addCustomIRecipes(IRecipe recipe, EmiRegistry registry) {
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier) {
        try {
            registry.addRecipe(supplier.get());
        }
        catch (Throwable e) {
            EmiReloadLog.warn("Exception when parsing EMI recipe (no ID available)", e);
        }
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier, IRecipe recipe) {
        try {
            registry.addRecipe(supplier.get());
        }
        catch (Throwable e) {
            EmiReloadLog.warn("Exception when parsing MITE recipe " + recipe, e);
        }
    }

    public static EmiRecipeCategory category(String id, EmiStack icon) {
        return new EmiRecipeCategory(new ResourceLocation("MITE", id), icon, new EmiTexture(new ResourceLocation("emi", "textures/simple_icons/" + id + ".png"), 0, 0, 16, 16, 16, 16, 16, 16));
    }

    public static EmiRecipeCategory category(String id, EmiStack icon, Comparator<EmiRecipe> comp) {
        return new EmiRecipeCategory(new ResourceLocation("MITE", id), icon, new EmiTexture(new ResourceLocation("emi", "textures/simple_icons/" + id + ".png"), 0, 0, 16, 16, 16, 16, 16, 16), comp);
    }

    @Override
    public void register(EmiRegistry registry) {
        if (EmiConfig.moreWorkstation) {
            registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, EmiStack.of(Block.furnaceClayIdle));
            registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, EmiStack.of(Block.furnaceHardenedClayIdle));
            registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, EmiStack.of(Block.furnaceSandstoneIdle));
            registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, EmiStack.of(Block.furnaceObsidianIdle));
            registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, EmiStack.of(Block.furnaceNetherrackIdle));
        }
        registry.addCategory(MITEEmiRecipeCategories.FOOD);
        registry.addCategory(MITEEmiRecipeCategories.ENCHANT);
        for (Item it : Item.itemsList) {
            if (it == null || it.getNutrition() <= 0 && it.getSatiation(null) <= 0) continue;
            MITEPlugin.addRecipeSafe(registry, () -> new EmiFoodRecipe(new ItemStack(it)));
        }
        MITEPlugin.addRecipeSafe(registry, () -> new EmiEnchantRecipe(EmiStack.of(new ItemStack(Item.appleGold, 1, 0)), EmiStack.of(new ItemStack(Item.appleGold, 1, 1)), 200));
        MITEPlugin.addRecipeSafe(registry, () -> new EmiEnchantRecipe(EmiStack.of(new ItemStack((Item)Item.potion, 1, 0)), EmiStack.of(new ItemStack(Item.expBottle, 1, 1)), 200));
        this.addInfoRecipes(registry);
        this.addWorldRecipes(registry);
    }

    private void addInfoRecipes(EmiRegistry registry) {
        this.info(registry, (Block)Block.gravel, 0, "mite.gravel.info");
        HashSet<Integer> enchantmentSet = new HashSet<Integer>();
        for (int i = 0; i < Enchantment.enchantmentsList.length; ++i) {
            Enchantment enchantment = EnchantmentNameIDTranslator.getEnchantmentByText(i);
            if (enchantment == null || enchantmentSet.contains(enchantment.effectId)) continue;
            enchantmentSet.add(enchantment.effectId);
            this.info(registry, Item.enchantedBook.getEnchantedItemStack(new EnchantmentData(enchantment, enchantment.getNumLevels())), "enchanted_book.info." + enchantment.getName());
        }
    }

    private void info(EmiRegistry registry, Item item, String info) {
        registry.addRecipe(new EmiInfoRecipe(List.of(EmiStack.of(item)), List.of(Text.translatable(info)), null));
    }

    private void info(EmiRegistry registry, ItemStack stack, String info) {
        registry.addRecipe(new EmiInfoRecipe(List.of(EmiStack.of(stack)), List.of(Text.translatable(info)), null));
    }

    private void info(EmiRegistry registry, Item item, int metadata, String info) {
        registry.addRecipe(new EmiInfoRecipe(List.of(EmiStack.of(new ItemStack(item, 1, metadata))), List.of(Text.translatable(info)), null));
    }

    private void info(EmiRegistry registry, Block block, String info) {
        registry.addRecipe(new EmiInfoRecipe(List.of(EmiStack.of(block)), List.of(Text.translatable(info)), null));
    }

    private void info(EmiRegistry registry, Block block, int metadata, String info) {
        registry.addRecipe(new EmiInfoRecipe(List.of(EmiStack.of(new ItemStack(block, 1, metadata))), List.of(Text.translatable(info)), null));
    }

    private void addWorldRecipes(EmiRegistry registry) {
        ArrayList woodTypes = new ArrayList();
    }

    static {
        MITEEmiRecipeCategories.ENCHANT = MITEPlugin.category("enchant", EmiStack.of(Block.enchantmentTable));
        MITEEmiRecipeCategories.FOOD = MITEPlugin.category("food", EmiStack.of(Item.carrot), Comparator.comparingInt(a -> ((EmiFoodRecipe)a).getHunger()));
    }
}

