/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.widget;

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiScreenshotRecorder;
import dev.emi.emi.widget.RecipeButtonWidget;
import java.util.List;
import net.minecraft.Minecraft;
import net.minecraft.ResourceLocation;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;

public class RecipeScreenshotButtonWidget
extends RecipeButtonWidget {
    public RecipeScreenshotButtonWidget(int x, int y, EmiRecipe recipe) {
        super(x, y, 60, 0, recipe);
    }

    @Override
    public List<TooltipComponent> getTooltip(int mouseX, int mouseY) {
        return List.of(TooltipComponent.of(EmiPort.ordered(EmiPort.translatable("tooltip.emi.recipe_screenshot"))));
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        this.playButtonSound();
        ResourceLocation id = this.recipe.getId();
        Object path = id == null ? "unknown-recipe" : id.getResourceDomain() + "/" + id.getResourcePath().replace("/", "_").replace(":", ".");
        int width = this.recipe.getDisplayWidth() + 8;
        int height = this.recipe.getDisplayHeight() + 8;
        Minecraft client = Minecraft.getMinecraft();
        DrawContext context = DrawContext.INSTANCE;
        EmiScreenshotRecorder.saveScreenshot("emi/recipes/" + (String)path, width, height, () -> EmiRenderHelper.renderRecipe(this.recipe, EmiDrawContext.wrap(context), 0, 0, false, -1));
        return true;
    }
}

