/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.search;

import com.google.common.collect.Sets;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.search.EmiSearch;
import dev.emi.emi.search.Query;
import java.util.List;
import java.util.Set;
import shims.java.net.minecraft.text.Text;

public class TooltipQuery
extends Query {
    private final Set<EmiStack> valid;
    private final String name;

    public TooltipQuery(String name) {
        this.valid = Sets.newHashSet(EmiSearch.tooltips.findAll(name.toLowerCase()));
        this.name = name.toLowerCase();
    }

    @Override
    public boolean matches(EmiStack stack) {
        return this.valid.contains(stack);
    }

    @Override
    public boolean matchesUnbaked(EmiStack stack) {
        for (Text text : TooltipQuery.getText(stack)) {
            if (!text.getString().toLowerCase().contains(this.name)) continue;
            return true;
        }
        return false;
    }

    public static List<Text> getText(EmiStack stack) {
        List<Text> lines = stack.getTooltipText();
        if (lines.isEmpty()) {
            return lines;
        }
        return lines.subList(1, lines.size());
    }
}

