/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.search;

import dev.emi.emi.Prototype;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.search.Query;
import java.util.Set;
import java.util.stream.Collectors;

public class TagQuery
extends Query {
    private final Set<Object> valid;

    public TagQuery(String name) {
        String lowerName = name.toLowerCase();
        this.valid = EmiTags.getTags(Prototype.class).stream().filter(t -> {
            if (EmiTags.hasTranslation(t) && EmiTags.getTagName(t).getString().toLowerCase().contains(lowerName)) {
                return true;
            }
            return t.id().toString().contains(lowerName);
        }).flatMap(t -> t.get().stream()).collect(Collectors.toSet());
    }

    @Override
    public boolean matches(EmiStack stack) {
        return this.valid.contains(stack.getKey());
    }
}

