/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.search;

import dev.emi.emi.Prototype;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.search.Query;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class RegexTagQuery
extends Query {
    private final Set<Object> valid;

    public RegexTagQuery(String name) {
        Pattern p = null;
        try {
            p = Pattern.compile(name, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (p == null) {
            this.valid = Collections.emptySet();
        } else {
            Pattern pat = p;
            this.valid = EmiTags.getTags(Prototype.class).stream().filter(t -> {
                if (EmiTags.hasTranslation(t) && pat.matcher(EmiTags.getTagName(t).getString().toLowerCase()).find()) {
                    return true;
                }
                return pat.matcher(t.id().toString()).find();
            }).flatMap(t -> t.get().stream()).collect(Collectors.toSet());
        }
    }

    @Override
    public boolean matches(EmiStack stack) {
        return this.valid.contains(stack.getKey());
    }
}

