/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.search;

import com.google.common.collect.Sets;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.search.EmiSearch;
import dev.emi.emi.search.Query;
import java.util.Set;
import shims.java.net.minecraft.text.Text;

public class NameQuery
extends Query {
    private final Set<EmiStack> valid;
    private final String name;

    public NameQuery(String name) {
        this.valid = Sets.newHashSet(EmiSearch.names.findAll(name.toLowerCase()));
        this.name = name.toLowerCase();
    }

    @Override
    public boolean matches(EmiStack stack) {
        return this.valid.contains(stack);
    }

    @Override
    public boolean matchesUnbaked(EmiStack stack) {
        return NameQuery.getText(stack).getString().toLowerCase().contains(this.name);
    }

    public static Text getText(EmiStack stack) {
        return stack.getName();
    }
}

