/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.search;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.data.EmiAlias;
import dev.emi.emi.data.EmiData;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.search.AliasQuery;
import dev.emi.emi.search.LogicalAndQuery;
import dev.emi.emi.search.LogicalOrQuery;
import dev.emi.emi.search.NameQuery;
import dev.emi.emi.search.Query;
import dev.emi.emi.search.QueryType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import moddedmite.emi.util.ModIdentifier;
import net.minecraft.Minecraft;
import net.minecraft.ResourceLocation;
import net.minecraft.StringTranslate;
import net.xiaoyu233.fml.FishModLoader;
import shims.java.com.unascribed.retroemi.RetroEMI;
import shims.java.net.minecraft.client.search.SuffixArray;
import shims.java.net.minecraft.text.Text;

public class EmiSearch {
    public static final Pattern TOKENS = Pattern.compile("-?[@#$]?(\\/(\\\\.|[^\\\\\\/])+\\/|\\\"(\\.|[^\\\"])+\\\"|[^\\s|]+|\\||\\&)");
    private static volatile SearchWorker currentWorker = null;
    public static volatile Thread searchThread = null;
    public static volatile List<? extends EmiIngredient> stacks = EmiStackList.stacks;
    public static volatile CompiledQuery compiledQuery;
    public static Set<EmiStack> bakedStacks;
    public static SuffixArray<EmiStack> names;
    public static SuffixArray<EmiStack> tooltips;
    public static SuffixArray<EmiStack> mods;
    public static SuffixArray<EmiStack> aliases;
    public static SuffixArray<EmiStack> ids;

    public static void bake() {
        SuffixArray<EmiStack> names = new SuffixArray<EmiStack>();
        SuffixArray<EmiStack> tooltips = new SuffixArray<EmiStack>();
        SuffixArray<EmiStack> mods = new SuffixArray<EmiStack>();
        SuffixArray<EmiStack> aliases = new SuffixArray<EmiStack>();
        SuffixArray<EmiStack> ids = new SuffixArray<EmiStack>();
        Set bakedStacks = Sets.newIdentityHashSet();
        boolean old = EmiConfig.appendItemModId;
        EmiConfig.appendItemModId = false;
        for (EmiStack emiStack : EmiStackList.stacks) {
            try {
                List<Text> tooltip;
                EmiStack strictStack = emiStack;
                bakedStacks.add(emiStack);
                Text name = NameQuery.getText(emiStack);
                if (name != null) {
                    names.add(strictStack, name.getString().toLowerCase());
                }
                if ((tooltip = emiStack.getTooltipText()) != null) {
                    for (int i = 1; i < tooltip.size(); ++i) {
                        Text text = tooltip.get(i);
                        if (text == null) continue;
                        tooltips.add(strictStack, text.getString().toLowerCase());
                    }
                }
                ResourceLocation id = emiStack.getId();
                EmiRecipe recipe = BoM.getRecipe(emiStack);
                if (id != null) {
                    mods.add(emiStack, ModIdentifier.getMod(emiStack.getItemStack()).toLowerCase().replace(" ", ""));
                    names.add(emiStack, id.toString());
                }
                if (recipe != null) {
                    names.add(emiStack, recipe.getId().toString());
                }
                Object idString = "";
                idString = emiStack.getItemStack().itemID < 10 ? "000" + emiStack.getItemStack().itemID : (emiStack.getItemStack().itemID < 100 ? "00" + emiStack.getItemStack().itemID : (emiStack.getItemStack().itemID < 1000 ? "0" + emiStack.getItemStack().itemID : String.valueOf(emiStack.getItemStack().itemID)));
                ids.add(emiStack, (String)idString + "/" + emiStack.getItemStack().getItemSubtype());
            }
            catch (Exception e) {
                EmiLog.error("EMI caught an exception while baking search for " + emiStack, e);
            }
        }
        for (Supplier supplier : EmiData.aliases) {
            EmiAlias alias = (EmiAlias)supplier.get();
            for (String key : alias.keys()) {
                if (!StringTranslate.getInstance().containsTranslateKey(key)) {
                    EmiReloadLog.warn("Untranslated alias " + key);
                }
                String text = RetroEMI.translate(key).toLowerCase();
                for (EmiIngredient ing : alias.stacks()) {
                    for (EmiStack stack : ing.getEmiStacks()) {
                        aliases.add(stack.copy().comparison(Comparison.compareNbt()), text);
                    }
                }
            }
        }
        for (EmiAlias.Baked baked : EmiStackList.registryAliases) {
            for (Text text : baked.text()) {
                for (EmiIngredient ing : baked.stacks()) {
                    for (EmiStack stack : ing.getEmiStacks()) {
                        aliases.add(stack.copy().comparison(EmiPort.compareStrict()), text.getString().toLowerCase());
                    }
                }
            }
        }
        EmiConfig.appendItemModId = old;
        names.build();
        tooltips.build();
        mods.build();
        aliases.build();
        ids.build();
        EmiSearch.names = names;
        EmiSearch.tooltips = tooltips;
        EmiSearch.mods = mods;
        EmiSearch.aliases = aliases;
        EmiSearch.bakedStacks = bakedStacks;
        EmiSearch.ids = ids;
    }

    public static void update() {
        EmiSearch.search(EmiScreenManager.search.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void search(String query) {
        Class<EmiSearch> clazz = EmiSearch.class;
        synchronized (EmiSearch.class) {
            SearchWorker worker;
            currentWorker = worker = new SearchWorker(query, EmiScreenManager.getSearchSource());
            searchThread = new Thread(worker);
            searchThread.setDaemon(true);
            searchThread.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void apply(SearchWorker worker, List<? extends EmiIngredient> stacks) {
        Class<EmiSearch> clazz = EmiSearch.class;
        synchronized (EmiSearch.class) {
            if (worker == currentWorker) {
                EmiSearch.stacks = stacks;
                currentWorker = null;
                searchThread = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static class SearchWorker
    implements Runnable {
        private final String query;
        private final List<? extends EmiIngredient> source;

        public SearchWorker(String query, List<? extends EmiIngredient> source) {
            this.query = query;
            this.source = source;
        }

        @Override
        public void run() {
            try {
                CompiledQuery compiled;
                compiledQuery = compiled = new CompiledQuery(this.query);
                if (compiled.isEmpty()) {
                    EmiSearch.apply(this, this.source);
                    return;
                }
                ArrayList stacks = Lists.newArrayList();
                int processed = 0;
                for (EmiIngredient emiIngredient : this.source) {
                    EmiStack es;
                    List<EmiStack> ess;
                    if (processed++ >= 1024) {
                        processed = 0;
                        if (this != currentWorker) {
                            return;
                        }
                    }
                    if ((ess = emiIngredient.getEmiStacks()).size() != 1 || !compiled.test(es = ess.get(0))) continue;
                    stacks.add(emiIngredient);
                }
                EmiSearch.apply(this, Lists.newArrayList((Iterable)stacks));
            }
            catch (Exception e) {
                EmiLog.error("Error when attempting to search:", e);
            }
        }
    }

    public static class CompiledQuery {
        public final Query fullQuery;

        public CompiledQuery(String query) {
            ArrayList full = Lists.newArrayList();
            ArrayList queries = Lists.newArrayList();
            Matcher matcher = TOKENS.matcher(query);
            while (matcher.find()) {
                String q = matcher.group();
                if (q.equals("|")) {
                    if (queries.isEmpty()) continue;
                    full.add(new LogicalAndQuery(queries));
                    queries = Lists.newArrayList();
                    continue;
                }
                boolean negated = q.startsWith("-");
                if (negated) {
                    q = q.substring(1);
                }
                if (q.isEmpty()) continue;
                QueryType type = QueryType.fromString(q);
                Function<String, Query> constructor = type.queryConstructor;
                Function<String, Query> regexConstructor = type.regexQueryConstructor;
                if (type == QueryType.DEFAULT) {
                    ArrayList constructors = Lists.newArrayList();
                    ArrayList regexConstructors = Lists.newArrayList();
                    constructors.add(constructor);
                    regexConstructors.add(regexConstructor);
                    if (EmiConfig.searchTooltipByDefault) {
                        constructors.add(QueryType.TOOLTIP.queryConstructor);
                        regexConstructors.add(QueryType.TOOLTIP.regexQueryConstructor);
                    }
                    if (EmiConfig.searchModNameByDefault) {
                        constructors.add(QueryType.MOD.queryConstructor);
                        regexConstructors.add(QueryType.MOD.regexQueryConstructor);
                    }
                    if (EmiConfig.searchNameByPinyin && Objects.equals(Minecraft.theMinecraft.gameSettings.language, "zh_CN") && FishModLoader.hasMod((String)"pinin")) {
                        constructors.add(QueryType.PINYIN.queryConstructor);
                        regexConstructors.add(QueryType.PINYIN.regexQueryConstructor);
                    }
                    if (EmiConfig.searchTagsByDefault) {
                        constructors.add(QueryType.TAG.queryConstructor);
                        regexConstructors.add(QueryType.TAG.regexQueryConstructor);
                    }
                    if (EmiConfig.searchIdByDefault) {
                        constructors.add(QueryType.ITEM_ID.queryConstructor);
                        regexConstructors.add(QueryType.ITEM_ID.regexQueryConstructor);
                    }
                    constructors.add(AliasQuery::new);
                    if (constructors.size() > 1) {
                        constructor = name -> new LogicalOrQuery(constructors.stream().map(c -> (Query)c.apply(name)).collect(Collectors.toList()));
                        regexConstructor = name -> new LogicalOrQuery(regexConstructors.stream().map(c -> (Query)c.apply(name)).collect(Collectors.toList()));
                    }
                }
                CompiledQuery.addQuery(q.substring(type.prefix.length()), negated, queries, constructor, regexConstructor);
            }
            if (!queries.isEmpty()) {
                full.add(new LogicalAndQuery(queries));
            }
            this.fullQuery = !full.isEmpty() ? new LogicalOrQuery(full) : null;
        }

        public boolean isEmpty() {
            return this.fullQuery == null;
        }

        public boolean test(EmiStack stack) {
            if (this.fullQuery == null) {
                return true;
            }
            if (bakedStacks.contains(stack)) {
                return this.fullQuery.matches(stack);
            }
            return this.fullQuery.matchesUnbaked(stack);
        }

        private static void addQuery(String s, boolean negated, List<Query> queries, Function<String, Query> normal, Function<String, Query> regex) {
            Query q = s.length() > 1 && s.startsWith("/") && s.endsWith("/") ? regex.apply(s.substring(1, s.length() - 1)) : normal.apply(s);
            q.negated = negated;
            queries.add(q);
        }
    }
}

