/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.widget.config;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.MathHelper;
import net.minecraft.Minecraft;
import net.minecraft.ResourceLocation;
import net.minecraft.Tessellator;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import shims.java.com.mojang.blaze3d.systems.RenderSystem;
import shims.java.net.minecraft.client.gui.AbstractParentElement;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.Drawable;
import shims.java.net.minecraft.client.gui.Element;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.client.gui.widget.ClickableWidget;
import shims.java.net.minecraft.client.gui.widget.TextFieldWidget;

public class ListWidget
extends AbstractParentElement
implements Drawable {
    protected final Minecraft client;
    private final List<Entry> children = Lists.newArrayList();
    protected int width;
    protected int height;
    protected int top;
    protected int bottom;
    protected int right;
    protected int left;
    private double scrollAmount;
    private boolean renderSelection = true;
    private boolean scrolling;
    private Entry selected;
    private Entry hoveredEntry;
    public int padding = 4;

    public ListWidget(Minecraft client, int width, int height, int top, int bottom) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }

    public void setRenderSelection(boolean renderSelection) {
        this.renderSelection = renderSelection;
    }

    public int getRowWidth() {
        return Math.min(400, this.width - 60);
    }

    public int getLogicalHeight() {
        return this.bottom - this.top;
    }

    @Nullable
    public Entry getSelectedOrNull() {
        return this.selected;
    }

    public void setSelected(@Nullable Entry entry) {
        this.selected = entry;
    }

    public final List<Entry> children() {
        return this.children;
    }

    protected final void clearEntries() {
        this.children.clear();
    }

    protected void replaceEntries(Collection<Entry> newEntries) {
        this.children.clear();
        this.children.addAll(newEntries);
    }

    protected Entry getEntry(int index) {
        return this.children().get(index);
    }

    public int addEntry(Entry entry) {
        this.children.add(entry);
        entry.parentList = this;
        return this.children.size() - 1;
    }

    protected int getEntryCount() {
        return this.children().size();
    }

    protected boolean isSelectedEntry(int index) {
        return Objects.equals(this.getSelectedOrNull(), this.children().get(index));
    }

    @Nullable
    protected final Entry getEntryAtPosition(double x, double y) {
        int rowWidth = this.getRowWidth() / 2;
        int mid = this.left + this.width / 2;
        int rowLeft = mid - rowWidth;
        int rowRight = mid + rowWidth;
        int m = MathHelper.floor_double((double)(y - (double)this.top)) + (int)this.getScrollAmount() - 4;
        if (x < (double)this.getScrollbarPositionX() && x >= (double)rowLeft && x <= (double)rowRight && m >= 0) {
            int h = 0;
            for (int i = 0; i < this.getEntryCount(); ++i) {
                int eh = this.getEntryHeight(i);
                if (m >= h && m < h + eh - this.padding) {
                    return this.getEntry(i);
                }
                h += eh;
            }
        }
        return null;
    }

    public void updateSize(int width, int height, int top, int bottom) {
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }

    public void setLeftPos(int left) {
        this.left = left;
        this.right = left + this.width;
    }

    protected int getMaxPosition() {
        return this.getTotalHeight();
    }

    @Override
    public void render(DrawContext draw, int mouseX, int mouseY, float delta) {
        int i = this.getScrollbarPositionX();
        int j = i + 6;
        Tessellator tess = Tessellator.instance;
        this.hoveredEntry = this.isMouseOver(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        Minecraft.getMinecraft().renderEngine.getTexture(new ResourceLocation("textures/gui/options_background.png"));
        GL11.glColor4f((float)0.1254902f, (float)0.1254902f, (float)0.1254902f, (float)1.0f);
        tess.startDrawingQuads();
        tess.addVertexWithUV((double)this.left, (double)this.bottom, 0.0, (double)((float)this.left / 32.0f), (double)((float)(this.bottom + (int)this.getScrollAmount()) / 32.0f));
        tess.addVertexWithUV((double)this.right, (double)this.bottom, 0.0, (double)((float)this.right / 32.0f), (double)((float)(this.bottom + (int)this.getScrollAmount()) / 32.0f));
        tess.addVertexWithUV((double)this.right, (double)this.top, 0.0, (double)((float)this.right / 32.0f), (double)((float)(this.top + (int)this.getScrollAmount()) / 32.0f));
        tess.addVertexWithUV((double)this.left, (double)this.top, 0.0, (double)((float)this.left / 32.0f), (double)((float)(this.top + (int)this.getScrollAmount()) / 32.0f));
        tess.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = this.getRowLeft();
        int l = this.top + 4 - (int)this.getScrollAmount();
        this.renderList(draw, k, l, mouseX, mouseY, delta);
        Minecraft.getMinecraft().renderEngine.bindTexture(new ResourceLocation("textures/gui/options_background.png"));
        GL11.glColor4f((float)0.2509804f, (float)0.2509804f, (float)0.2509804f, (float)1.0f);
        RenderSystem.enableDepthTest();
        GL11.glDepthFunc((int)519);
        tess.startDrawingQuads();
        tess.addVertexWithUV((double)this.left, (double)this.top, -100.0, 0.0, (double)((float)this.top / 32.0f));
        tess.addVertexWithUV((double)(this.left + this.width), (double)this.top, -100.0, (double)((float)this.width / 32.0f), (double)((float)this.top / 32.0f));
        tess.addVertexWithUV((double)(this.left + this.width), 0.0, -100.0, (double)((float)this.width / 32.0f), 0.0);
        tess.addVertexWithUV((double)this.left, 0.0, -100.0, 0.0, 0.0);
        tess.addVertexWithUV((double)this.left, (double)this.height, -100.0, 0.0, (double)((float)this.height / 32.0f));
        tess.addVertexWithUV((double)(this.left + this.width), (double)this.height, -100.0, (double)((float)this.width / 32.0f), (double)((float)this.height / 32.0f));
        tess.addVertexWithUV((double)(this.left + this.width), (double)this.bottom, -100.0, (double)((float)this.width / 32.0f), (double)((float)this.bottom / 32.0f));
        tess.addVertexWithUV((double)this.left, (double)this.bottom, -100.0, 0.0, (double)((float)this.bottom / 32.0f));
        tess.draw();
        GL11.glDepthFunc((int)515);
        RenderSystem.disableDepthTest();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        RenderSystem.enableBlend();
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        int n = 4;
        tess.startDrawingQuads();
        tess.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.0f);
        tess.addVertex((double)this.left, (double)(this.top + 4), 0.0);
        tess.addVertex((double)this.right, (double)(this.top + 4), 0.0);
        tess.setColorRGBA_F(0.0f, 0.0f, 0.0f, 1.0f);
        tess.addVertex((double)this.right, (double)this.top, 0.0);
        tess.addVertex((double)this.left, (double)this.top, 0.0);
        tess.addVertex((double)this.left, (double)this.bottom, 0.0);
        tess.addVertex((double)this.right, (double)this.bottom, 0.0);
        tess.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.0f);
        tess.addVertex((double)this.right, (double)(this.bottom - 4), 0.0);
        tess.addVertex((double)this.left, (double)(this.bottom - 4), 0.0);
        tess.draw();
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int o = this.getMaxScroll();
        if (o > 0) {
            GL11.glDisable((int)3553);
            int m = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getMaxPosition());
            m = MathHelper.clamp_int((int)m, (int)32, (int)(this.bottom - this.top - 8));
            n = (int)this.getScrollAmount() * (this.bottom - this.top - m) / o + this.top;
            if (n < this.top) {
                n = this.top;
            }
            tess.startDrawingQuads();
            tess.setColorRGBA_F(0.0f, 0.0f, 0.0f, 1.0f);
            tess.addVertex((double)i, (double)this.bottom, 0.0);
            tess.addVertex((double)j, (double)this.bottom, 0.0);
            tess.addVertex((double)j, (double)this.top, 0.0);
            tess.addVertex((double)i, (double)this.top, 0.0);
            tess.setColorRGBA_F(0.5f, 0.5f, 0.5f, 1.0f);
            tess.addVertex((double)i, (double)(n + m), 0.0);
            tess.addVertex((double)j, (double)(n + m), 0.0);
            tess.addVertex((double)j, (double)n, 0.0);
            tess.addVertex((double)i, (double)n, 0.0);
            tess.setColorRGBA_F(0.75f, 0.75f, 0.75f, 1.0f);
            tess.addVertex((double)i, (double)(n + m - 1), 0.0);
            tess.addVertex((double)(j - 1), (double)(n + m - 1), 0.0);
            tess.addVertex((double)(j - 1), (double)n, 0.0);
            tess.addVertex((double)i, (double)n, 0.0);
            tess.draw();
            GL11.glEnable((int)3553);
        }
        RenderSystem.disableBlend();
    }

    public void centerScrollOn(Entry entry) {
        int i = 0;
        for (Entry e : this.children()) {
            if (e == entry) {
                this.setScrollAmount(i - 42);
                return;
            }
            i += this.getEntryHeight(e);
        }
    }

    protected void ensureVisible(Entry entry) {
        int i = this.getRowTop(this.children().indexOf(entry));
        int j = i - this.top - 4 - entry.getHeight();
        int k = this.bottom - i - entry.getHeight() * 2;
        if (j < 0) {
            this.scroll(j);
        }
        if (k < 0) {
            this.scroll(-k);
        }
    }

    private void scroll(int amount) {
        this.setScrollAmount(this.getScrollAmount() + (double)amount);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double amount) {
        this.scrollAmount = MathHelper.clamp_float((float)((float)amount), (float)0.0f, (float)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4) + 40);
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPositionX() && mouseX < (double)(this.getScrollbarPositionX() + 6);
    }

    protected int getScrollbarPositionX() {
        return this.width - 6;
    }

    public void unfocusTextField() {
        for (Entry e : this.children) {
            for (Element el : e.children()) {
                if (!(el instanceof TextFieldWidget)) continue;
                TextFieldWidget tfw = (TextFieldWidget)el;
                EmiPort.focus(tfw, false);
            }
        }
    }

    public TextFieldWidget getFocusedTextField() {
        for (Entry e : this.children) {
            for (Element el : e.children()) {
                TextFieldWidget tfw;
                if (!(el instanceof TextFieldWidget) || !(tfw = (TextFieldWidget)el).isFocused()) continue;
                return tfw;
            }
        }
        return null;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        this.unfocusTextField();
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        Entry entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null && entry.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused(entry);
            this.setDragging(true);
            return true;
        }
        return this.scrolling;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button != 0 || !this.scrolling) {
            return false;
        }
        if (mouseY < (double)this.top) {
            this.setScrollAmount(0.0);
        } else if (mouseY > (double)this.bottom) {
            this.setScrollAmount(this.getMaxScroll());
        } else {
            double d = Math.max(1, this.getMaxScroll());
            int i = this.bottom - this.top;
            int j = MathHelper.clamp_int((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
            double e = Math.max(1.0, d / (double)(i - j));
            this.setScrollAmount(this.getScrollAmount() + deltaY * e);
        }
        return true;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        this.setScrollAmount(this.getScrollAmount() - amount * 22.0);
        return true;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void moveSelection(MoveDirection direction) {
        this.moveSelectionIf(direction, entry -> true);
    }

    protected void ensureSelectedEntryVisible() {
        Entry entry = this.getSelectedOrNull();
        if (entry != null) {
            this.setSelected(entry);
            this.ensureVisible(entry);
        }
    }

    protected void moveSelectionIf(MoveDirection direction, Predicate<Entry> predicate) {
        int i;
        int n = i = direction == MoveDirection.UP ? -1 : 1;
        if (!this.children().isEmpty()) {
            int k;
            int j = this.children().indexOf(this.getSelectedOrNull());
            while (j != (k = MathHelper.clamp_int((int)(j + i), (int)0, (int)(this.getEntryCount() - 1)))) {
                Entry entry = this.children().get(k);
                if (predicate.test(entry)) {
                    this.setSelected(entry);
                    this.ensureVisible(entry);
                    break;
                }
                j = k;
            }
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseY >= (double)this.top && mouseY <= (double)this.bottom && mouseX >= (double)this.left && mouseX <= (double)this.right;
    }

    protected void renderList(DrawContext draw, int x, int y, int mouseX, int mouseY, float delta) {
        int i = this.getEntryCount();
        Tessellator tess = Tessellator.instance;
        for (int j = 0; j < i; ++j) {
            int p;
            int k = this.getRowTop(j);
            int l = this.getRowBottom(j);
            if (l < this.top || k > this.bottom) continue;
            int m = k;
            int n = this.getEntryHeight(j);
            if (n == 0) continue;
            n -= 4;
            Entry entry = this.getEntry(j);
            int o = this.getRowWidth();
            if (this.renderSelection && this.isSelectedEntry(j)) {
                p = this.left + this.width / 2 - o / 2;
                int q = this.left + this.width / 2 + o / 2;
                GL11.glDisable((int)3553);
                float f = this.isFocused() ? 1.0f : 0.5f;
                GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                tess.startDrawingQuads();
                tess.addVertex((double)p, (double)(m + n + 2), 0.0);
                tess.addVertex((double)q, (double)(m + n + 2), 0.0);
                tess.addVertex((double)q, (double)(m - 2), 0.0);
                tess.addVertex((double)p, (double)(m - 2), 0.0);
                tess.draw();
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                tess.startDrawingQuads();
                tess.addVertex((double)(p + 1), (double)(m + n + 1), 0.0);
                tess.addVertex((double)(q - 1), (double)(m + n + 1), 0.0);
                tess.addVertex((double)(q - 1), (double)(m - 1), 0.0);
                tess.addVertex((double)(p + 1), (double)(m - 1), 0.0);
                tess.draw();
            }
            p = this.getRowLeft();
            entry.render(draw, j, k, p, o - 3, n, mouseX, mouseY, Objects.equals(this.hoveredEntry, entry), delta);
        }
    }

    public int getRowLeft() {
        return this.left + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    public int getRowRight() {
        return this.getRowLeft() + this.getRowWidth();
    }

    private int getEntryHeight(int i) {
        return this.getEntryHeight(this.getEntry(i));
    }

    private int getEntryHeight(Entry entry) {
        int h = entry.getHeight();
        if (h == 0) {
            return 0;
        }
        return h + this.padding;
    }

    protected int getRowTop(int index) {
        int height = 0;
        for (int i = 0; i < index; ++i) {
            height += this.getEntryHeight(i);
        }
        return this.top + 4 - (int)this.getScrollAmount() + height;
    }

    private int getRowBottom(int index) {
        return this.getRowTop(index) + this.getEntry(index).getHeight();
    }

    @Override
    public boolean isFocused() {
        return false;
    }

    public ClickableWidget.SelectionType getType() {
        if (this.isFocused()) {
            return ClickableWidget.SelectionType.FOCUSED;
        }
        if (this.hoveredEntry != null) {
            return ClickableWidget.SelectionType.HOVERED;
        }
        return ClickableWidget.SelectionType.NONE;
    }

    @Nullable
    public Entry getHoveredEntry() {
        return this.hoveredEntry;
    }

    void setEntryParentList(Entry entry) {
        entry.parentList = this;
    }

    public int getTotalHeight() {
        int height = 0;
        for (int i = 0; i < this.getEntryCount(); ++i) {
            height += this.getEntryHeight(i);
        }
        if (height > 0) {
            height -= this.padding;
        }
        return height;
    }

    @Override
    public void setFocused(boolean focused) {
    }

    public static abstract class Entry
    extends AbstractParentElement {
        public ListWidget parentList;

        public abstract void render(DrawContext var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        @Override
        public boolean isMouseOver(double mouseX, double mouseY) {
            return Objects.equals(this.parentList.getEntryAtPosition(mouseX, mouseY), this);
        }

        public List<TooltipComponent> getTooltip(int mouseX, int mouseY) {
            return List.of();
        }

        public abstract int getHeight();
    }

    protected static enum MoveDirection {
        UP,
        DOWN;

    }
}

