/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.widget.config;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.widget.config.ConfigEntryWidget;
import dev.emi.emi.screen.widget.config.ListWidget;
import java.util.List;
import net.minecraft.Minecraft;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.Element;
import shims.java.net.minecraft.text.Text;

public class GroupNameWidget
extends ListWidget.Entry {
    protected static final Minecraft CLIENT = Minecraft.getMinecraft();
    public final String id;
    public final Text text;
    public final List<ConfigEntryWidget> children = Lists.newArrayList();
    public boolean collapsed = false;

    public GroupNameWidget(String id, Text text) {
        this.id = id;
        this.text = text;
    }

    @Override
    public void render(DrawContext raw, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        context.drawCenteredTextWithShadow(this.text, x + width / 2, y + 3, -1);
        if (hovered || this.collapsed) {
            String collapse = "[-]";
            int cx = x + width / 2 - GroupNameWidget.CLIENT.fontRenderer.getStringWidth(this.text.asString()) / 2 - 20;
            if (this.collapsed) {
                collapse = "[+]";
            }
            context.drawTextWithShadow(EmiPort.literal(collapse), cx, y + 3, -1);
        }
    }

    @Override
    public int getHeight() {
        for (ConfigEntryWidget w : this.children) {
            if (!w.isVisible()) continue;
            return 20;
        }
        return 0;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.collapsed = !this.collapsed;
            Minecraft.getMinecraft().sndManager.playSoundFX("random.click", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public List<? extends Element> children() {
        return List.of();
    }
}

