/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.widget.config;

import dev.emi.emi.EmiPort;
import dev.emi.emi.config.ConfigEnum;
import dev.emi.emi.screen.ConfigEnumScreen;
import dev.emi.emi.screen.ConfigScreen;
import dev.emi.emi.screen.widget.config.ConfigEntryWidget;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.GuiScreen;
import net.minecraft.Minecraft;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.client.gui.widget.ButtonWidget;
import shims.java.net.minecraft.text.Text;

public class EnumWidget
extends ConfigEntryWidget {
    private final ConfigScreen.Mutator<ConfigEnum> mutator;
    private ButtonWidget button;

    public EnumWidget(Text name, List<TooltipComponent> tooltip, Supplier<String> search, ConfigScreen.Mutator<ConfigEnum> mutator, Predicate<ConfigEnum> filter) {
        super(name, tooltip, search, 20);
        this.mutator = mutator;
        this.button = EmiPort.newButton(0, 0, 150, 20, this.getText(), button -> EnumWidget.page((ConfigEnum)mutator.get(), filter, mutator::set));
        this.setChildren(List.of(this.button));
    }

    public static void page(ConfigEnum original, Predicate<ConfigEnum> filter, Consumer<ConfigEnum> consumer) {
        Enum e = (Enum)((Object)original);
        Enum[] values = (Enum[])e.getClass().getEnumConstants();
        Minecraft client = Minecraft.getMinecraft();
        GuiScreen guiScreen = client.currentScreen;
        if (guiScreen instanceof ConfigScreen) {
            ConfigScreen cs = (ConfigScreen)guiScreen;
            client.displayGuiScreen(new ConfigEnumScreen<ConfigEnum>(cs, Stream.of(values).filter(f -> filter.test((ConfigEnum)((Object)f))).map(v -> {
                ConfigEnum en = (ConfigEnum)((Object)v);
                return new ConfigEnumScreen.Entry<ConfigEnum>(en, en.getText(), List.of());
            }).collect(Collectors.toList()), consumer));
        }
    }

    public Text getText() {
        return this.mutator.get().getText();
    }

    @Override
    public void update(int y, int x, int width, int height) {
        this.button.x = x + width - this.button.getWidth();
        this.button.y = y;
    }
}

