/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.widget.config;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.input.EmiBind;
import dev.emi.emi.screen.ConfigScreen;
import dev.emi.emi.screen.widget.config.ConfigEntryWidget;
import java.util.List;
import java.util.function.Supplier;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.client.gui.widget.ButtonWidget;
import shims.java.net.minecraft.client.util.InputUtil;
import shims.java.net.minecraft.util.Formatting;

public class EmiBindWidget
extends ConfigEntryWidget {
    private final ConfigScreen screen;
    private EmiBind bind;
    private List<ButtonWidget> buttons = Lists.newArrayList();

    public EmiBindWidget(ConfigScreen screen, List<TooltipComponent> tooltip, Supplier<String> search, EmiBind bind) {
        super(EmiPort.translatable(bind.translationKey), tooltip, search, 0);
        this.screen = screen;
        this.bind = bind;
        this.updateButtons();
        this.setChildren(this.buttons);
    }

    private void updateButtons() {
        this.buttons.clear();
        for (int i = 0; i < this.bind.boundKeys.size(); ++i) {
            int j = i;
            ButtonWidget widget = EmiPort.newButton(0, 0, 200, 20, this.bind.boundKeys.get(i).getKeyText(Formatting.RESET), button -> this.screen.setActiveBind(this.bind, j));
            this.buttons.add(widget);
        }
    }

    @Override
    public void update(int y, int x, int width, int height) {
        if (this.buttons.size() != this.bind.boundKeys.size()) {
            this.updateButtons();
        }
        int h = 0;
        for (int i = 0; i < this.buttons.size(); ++i) {
            ButtonWidget button = this.buttons.get(i);
            button.x = x + width - 224;
            button.y = y + h;
            if (this.screen.activeBind == this.bind && this.screen.activeBindOffset == i) {
                button.setWidth(200);
                button.x = x + width - 224;
                if (this.screen.lastModifier == 0) {
                    button.setMessage(EmiPort.literal("...", Formatting.YELLOW));
                } else {
                    button.setMessage(new EmiBind.ModifiedKey(InputUtil.Type.KEYSYM.createFromCode(this.screen.lastModifier), this.screen.activeModifiers).getKeyText(Formatting.YELLOW));
                }
            } else if (i < this.bind.boundKeys.size()) {
                if (this.bind.boundKeys.get(i).isUnbound() && i > 0) {
                    button.setWidth(20);
                    button.x = x + width - 20;
                    button.y = y;
                    button.setMessage(EmiPort.literal("+", Formatting.AQUA));
                } else {
                    button.setMessage(this.bind.boundKeys.get(i).getKeyText(Formatting.RESET));
                }
            }
            h += 24;
        }
    }

    @Override
    public int getHeight() {
        if (!this.isVisible() || !this.isParentVisible()) {
            return 0;
        }
        int size = this.buttons.size() * 24;
        if (this.buttons.size() > 1 && this.buttons.size() <= this.bind.boundKeys.size() && this.bind.boundKeys.get(this.buttons.size() - 1).isUnbound() && (this.screen.activeBind != this.bind || this.screen.activeBindOffset != this.buttons.size() - 1)) {
            size -= 24;
        }
        return size - 4;
    }
}

