/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.widget;

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.ConfigScreen;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.Minecraft;
import net.minecraft.ResourceLocation;
import shims.java.com.mojang.blaze3d.systems.RenderSystem;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.client.gui.widget.ButtonWidget;
import shims.java.net.minecraft.text.MutableText;
import shims.java.net.minecraft.text.Text;

public class SizedButtonWidget
extends ButtonWidget {
    private final BooleanSupplier isActive;
    private final IntSupplier vOffset;
    protected ResourceLocation texture = EmiRenderHelper.BUTTONS;
    protected Supplier<List<Text>> text;
    protected int u;
    protected int v;

    public SizedButtonWidget(int x, int y, int width, int height, int u, int v, BooleanSupplier isActive, ButtonWidget.PressAction action) {
        this(x, y, width, height, u, v, isActive, action, () -> 0);
    }

    public SizedButtonWidget(int x, int y, int width, int height, int u, int v, BooleanSupplier isActive, ButtonWidget.PressAction action, List<Text> text) {
        this(x, y, width, height, u, v, isActive, action, () -> 0, () -> text);
    }

    public SizedButtonWidget(int x, int y, int width, int height, int u, int v, BooleanSupplier isActive, ButtonWidget.PressAction action, IntSupplier vOffset) {
        this(x, y, width, height, u, v, isActive, action, vOffset, null);
    }

    public SizedButtonWidget(int x, int y, int width, int height, int u, int v, BooleanSupplier isActive, ButtonWidget.PressAction action, IntSupplier vOffset, Supplier<List<Text>> text) {
        super(x, y, width, height, EmiPort.literal(""), action, s -> (MutableText)s.get());
        this.u = u;
        this.v = v;
        this.isActive = isActive;
        this.vOffset = vOffset;
        this.text = text;
    }

    protected int getU(int mouseX, int mouseY) {
        return this.u;
    }

    protected int getV(int mouseX, int mouseY) {
        int v = this.v + this.vOffset.getAsInt();
        this.active = this.isActive.getAsBoolean();
        if (!this.active) {
            v += this.height * 2;
        } else if (this.isMouseOver(mouseX, mouseY)) {
            v += this.height;
        }
        return v;
    }

    @Override
    public void renderWidget(DrawContext raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        RenderSystem.enableDepthTest();
        if (!(Minecraft.getMinecraft().currentScreen instanceof ConfigScreen)) {
            context.resetColor();
        }
        context.drawTexture(this.texture, this.x, this.y, this.getU(mouseX, mouseY), this.getV(mouseX, mouseY), this.width, this.height);
        if (this.isMouseOver(mouseX, mouseY) && this.text != null && this.active) {
            context.push();
            RenderSystem.disableDepthTest();
            Minecraft client = Minecraft.getMinecraft();
            EmiRenderHelper.drawTooltip(client.currentScreen, context, this.text.get().stream().map(EmiPort::ordered).map(TooltipComponent::of).toList(), mouseX, mouseY);
            context.pop();
        }
    }
}

