/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.widget;

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiHistory;
import dev.emi.emi.widget.RecipeDefaultButtonWidget;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Minecraft;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.widget.ButtonWidget;
import shims.java.net.minecraft.text.MutableText;

public class ResolutionButtonWidget
extends ButtonWidget {
    public Supplier<Widget> hoveredWidget;
    public EmiIngredient stack;

    public ResolutionButtonWidget(int x, int y, int width, int height, EmiIngredient stack, Supplier<Widget> hoveredWidget) {
        super(x, y, width, height, EmiPort.literal(""), button -> {
            BoM.tree.addResolution(stack, null);
            EmiHistory.pop();
        }, s -> (MutableText)s.get());
        this.stack = stack;
        this.hoveredWidget = hoveredWidget;
    }

    @Override
    public void render(DrawContext raw, int mouseX, int mouseY, float delta) {
        super.render(raw, mouseX, mouseY, delta);
        if (this.isHovered()) {
            Minecraft client = Minecraft.getMinecraft();
            raw.drawTooltip(client.fontRenderer, List.of(EmiPort.translatable("tooltip.emi.resolution"), EmiPort.translatable("tooltip.emi.select_resolution"), EmiPort.translatable("tooltip.emi.default_resolution"), EmiPort.translatable("tooltip.emi.clear_resolution")), mouseX, mouseY);
        }
        this.stack.render(raw, this.x + 1, this.y + 1, delta);
    }

    @Override
    public void renderWidget(DrawContext raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.instance();
        int u = 0;
        if (this.isHovered()) {
            u = 18;
        } else {
            SlotWidget slot;
            Widget widget = this.hoveredWidget.get();
            if (widget instanceof SlotWidget && (slot = (SlotWidget)widget).getRecipe() != null || widget instanceof RecipeDefaultButtonWidget) {
                u = 36;
            }
        }
        EmiTexture.SLOT.render(context.raw(), this.x, this.y, delta);
        context.drawTexture(EmiRenderHelper.WIDGETS, this.x, this.y, u, 128, this.width, this.height);
    }
}

