/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.widget;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.search.EmiSearch;
import dev.emi.emi.search.QueryType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.FontRenderer;
import net.minecraft.Tessellator;
import org.lwjgl.opengl.GL11;
import shims.java.com.unascribed.retroemi.Pair;
import shims.java.com.unascribed.retroemi.RetroEMI;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.widget.TextFieldWidget;
import shims.java.net.minecraft.client.util.math.MatrixStack;
import shims.java.net.minecraft.text.MutableText;
import shims.java.net.minecraft.text.Style;
import shims.java.net.minecraft.util.Formatting;

public class EmiSearchWidget
extends TextFieldWidget {
    private static final Pattern ESCAPE = Pattern.compile("\\\\.");
    private List<Pair<Integer, Style>> styles;
    private long lastClick = 0L;
    private String last = "";
    private long lastRender = System.currentTimeMillis();
    private long accumulatedSpin = 0L;
    public boolean highlight = false;
    public boolean isFocused;
    Tessellator tessellator = Tessellator.instance;

    public EmiSearchWidget(FontRenderer fontRenderer, int x, int y, int width, int height) {
        super(fontRenderer, x, y, width, height, EmiPort.literal(""));
        this.setFocusUnlocked(true);
        this.setEditableColor(-1);
        this.setUneditableColor(-1);
        this.setMaxLength(256);
        this.setRenderTextProvider((string, stringStart) -> {
            int end;
            Pair<Integer, Style> style;
            int s;
            MutableText text = null;
            int last = 0;
            for (s = 0; s < this.styles.size(); ++s) {
                style = this.styles.get(s);
                end = style.getLeft();
                if (end <= stringStart) continue;
                if (end - stringStart >= string.length()) {
                    text = EmiPort.literal(string, style.getRight());
                    s = this.styles.size();
                    break;
                }
                text = EmiPort.literal(string.substring(0, end - stringStart), style.getRight());
                last = end - stringStart;
                ++s;
                break;
            }
            while (s < this.styles.size()) {
                style = this.styles.get(s);
                end = style.getLeft();
                if (end - stringStart >= string.length()) {
                    EmiPort.append(text, EmiPort.literal(string.substring(last), style.getRight()));
                    break;
                }
                EmiPort.append(text, EmiPort.literal(string.substring(last, end - stringStart), style.getRight()));
                last = end - stringStart;
                ++s;
            }
            return EmiPort.ordered(text);
        });
        this.setChangedListener(string -> {
            if (string.isEmpty()) {
                this.setSuggestion(RetroEMI.translate("emi.search"));
            } else {
                this.setSuggestion("");
            }
            EmiScreenManager.focusSearchSidebarType(EmiConfig.emptySearchSidebarFocus);
            Matcher matcher = EmiSearch.TOKENS.matcher((CharSequence)string);
            ArrayList styles = Lists.newArrayList();
            int last = 0;
            while (matcher.find()) {
                String group;
                int start = matcher.start();
                int end = matcher.end();
                if (last < start) {
                    styles.add(new Pair<Integer, Style>(start, Style.EMPTY.withFormatting(Formatting.WHITE)));
                }
                if ((group = matcher.group()).startsWith("-")) {
                    styles.add(new Pair<Integer, Style>(start + 1, Style.EMPTY.withFormatting(Formatting.RED)));
                    ++start;
                    group = group.substring(1);
                }
                QueryType type = QueryType.fromString(group);
                int subStart = type.prefix.length();
                if (group.length() > 1 + subStart && group.substring(subStart).startsWith("/") && group.endsWith("/")) {
                    int rOff = start + subStart + 1;
                    styles.add(new Pair<Integer, Style>(rOff, type.slashColor));
                    Matcher rMatcher = ESCAPE.matcher(string.substring(rOff, end - 1));
                    int rLast = 0;
                    while (rMatcher.find()) {
                        int rStart = rMatcher.start();
                        int rEnd = rMatcher.end();
                        if (rLast < rStart) {
                            styles.add(new Pair<Integer, Style>(rStart + rOff, type.regexColor));
                        }
                        styles.add(new Pair<Integer, Style>(rEnd + rOff, type.escapeColor));
                        rLast = rEnd;
                    }
                    if (rLast < end - 1) {
                        styles.add(new Pair<Integer, Style>(end - 1, type.regexColor));
                    }
                    styles.add(new Pair<Integer, Style>(end, type.slashColor));
                } else {
                    styles.add(new Pair<Integer, Style>(end, type.color));
                }
                last = end;
            }
            if (last < string.length()) {
                styles.add(new Pair<Integer, Style>(string.length(), Style.EMPTY.withFormatting(Formatting.WHITE)));
            }
            this.styles = styles;
            EmiSearch.search(string);
        });
    }

    public void update() {
        this.setText(this.getText());
    }

    public void swap() {
        String last = this.getText();
        this.setText(this.last);
        this.last = last;
    }

    @Override
    public void setFocused(boolean focused) {
        if (focused == this.isFocused) {
            return;
        }
        this.isFocused = focused;
        super.setFocused(focused);
        EmiScreenManager.updateSearchSidebar();
    }

    @Override
    public boolean isFocused() {
        return this.isFocused;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY) || !EmiConfig.enabled) {
            this.setFocused(false);
            return false;
        }
        boolean b = super.mouseClicked(mouseX, mouseY, button == 1 ? 0 : button);
        if (this.isMouseOver(mouseX, mouseY)) {
            this.setFocused(true);
        }
        if (this.isFocused()) {
            if (button == 0) {
                if (System.currentTimeMillis() - this.lastClick < 500L) {
                    this.highlight = !this.highlight;
                    this.lastClick = 0L;
                } else {
                    this.lastClick = System.currentTimeMillis();
                }
            } else if (button == 1) {
                this.setText("");
                this.setFocused(true);
            }
        }
        return b;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isFocused()) {
            if (EmiConfig.clearSearch.matchesKey(keyCode, scanCode)) {
                this.setText("");
                return true;
            }
            if (EmiConfig.focusSearch.matchesKey(keyCode, scanCode) || keyCode == 28 || keyCode == 1) {
                this.setFocused(false);
                this.setFocused(false);
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void render(DrawContext raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        this.setEditable(EmiConfig.enabled);
        String lower = this.getText().toLowerCase();
        boolean dinnerbone = lower.contains("dinnerbone");
        this.accumulatedSpin += (long)(dinnerbone ? 1 : -1) * Math.abs(System.currentTimeMillis() - this.lastRender);
        if (this.accumulatedSpin < 0L) {
            this.accumulatedSpin = 0L;
        } else if (this.accumulatedSpin > 500L) {
            this.accumulatedSpin = 500L;
        }
        this.lastRender = System.currentTimeMillis();
        long deg = this.accumulatedSpin * -180L / 500L;
        MatrixStack view = MatrixStack.INSTANCE;
        view.push();
        if (deg != 0L) {
            view.translate((double)this.x + (double)this.width / 2.0, (double)this.y + (double)this.height / 2.0, 0.0);
            view.multiply(() -> GL11.glRotatef((float)deg, (float)0.0f, (float)0.0f, (float)-1.0f));
            view.translate(-((double)this.x + (double)this.width / 2.0), -((double)this.y + (double)this.height / 2.0), 0.0);
        }
        if (lower.contains("jeb_")) {
            int amount = 1023;
            this.lastRender = System.currentTimeMillis();
            float h = (float)(this.lastRender & (long)amount) % (float)amount / (float)amount;
            int rgb = Color.HSBtoRGB(h, 1.0f, 1.0f);
            this.tessellator.setColorRGBA((int)((float)(rgb >> 16 & 0xFF) / 255.0f), (int)((float)(rgb >> 8 & 0xFF) / 255.0f), (int)((float)(rgb >> 0 & 0xFF) / 255.0f), 1);
        }
        if (EmiConfig.enabled) {
            super.render(context.raw(), mouseX, mouseY, delta);
            if (this.highlight) {
                int border = -1118720;
                context.fill(this.x - 2, this.y - 2, this.width + 3, 1, border);
                context.fill(this.x - 2, this.y + this.height + 1, this.width + 3, 1, border);
                context.fill(this.x - 2, this.y - 2, 1, this.height + 3, border);
                context.fill(this.x + this.width + 1, this.y - 2, 1, this.height + 4, border);
            }
        }
        context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        view.pop();
    }
}

