/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.tooltip;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.tooltip.EmiTooltip;
import dev.emi.emi.screen.tooltip.EmiTooltipComponent;
import java.util.List;
import net.minecraft.FontRenderer;
import shims.java.net.minecraft.text.MutableText;
import shims.java.net.minecraft.util.Formatting;

public class RemainderTooltipComponent
implements EmiTooltipComponent {
    public List<Remainder> remainders = Lists.newArrayList();

    public RemainderTooltipComponent(EmiIngredient ingredient) {
        block0: for (EmiStack stack : ingredient.getEmiStacks()) {
            for (Remainder remainder : this.remainders) {
                if (!remainder.remainder.isEqual(stack.getRemainder())) continue;
                remainder.inputs.add(stack);
                continue block0;
            }
            if (stack.getRemainder().isEmpty()) continue;
            this.remainders.add(new Remainder(stack, stack.getRemainder()));
        }
    }

    @Override
    public int getHeight() {
        return 18 * this.remainders.size();
    }

    @Override
    public int getWidth(FontRenderer var1) {
        return 54;
    }

    @Override
    public void drawTooltip(EmiDrawContext context, EmiTooltipComponent.TooltipRenderData render) {
        for (int i = 0; i < this.remainders.size(); ++i) {
            Remainder remainder = this.remainders.get(i);
            context.drawStack(remainder.inputs.get(0), 0, 18 * i, 1);
            context.drawStack(remainder.remainder, 36, 18 * i);
        }
    }

    @Override
    public void drawTooltipText(EmiTooltipComponent.TextRenderData text) {
        for (int i = 0; i < this.remainders.size(); ++i) {
            Remainder remainder = this.remainders.get(i);
            boolean chanced = remainder.remainder.getChance() != 1.0f;
            text.draw(EmiPort.literal("->"), 20, 5 + i * 18 - (chanced ? 4 : 0), 0xFFFFFF, true);
            if (!chanced) continue;
            MutableText t = EmiPort.literal(EmiTooltip.TEXT_FORMAT.format(remainder.remainder.getChance() * 100.0f) + "%");
            int tx = text.renderer.getStringWidth(t.asString());
            text.draw(t, 27 - tx / 2, 9 + i * 18, (int)Formatting.GOLD.getColorValue(), false);
        }
    }

    private static class Remainder {
        public final List<EmiStack> inputs = Lists.newArrayList();
        public final EmiStack remainder;

        public Remainder(EmiStack input, EmiStack remainder) {
            this.inputs.add(input);
            this.remainder = remainder;
        }
    }
}

