/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.tooltip;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.bom.ChanceMaterialCost;
import dev.emi.emi.bom.FlatMaterialCost;
import dev.emi.emi.bom.MaterialTree;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.tooltip.EmiTooltipComponent;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.FontRenderer;
import shims.java.net.minecraft.text.Text;
import shims.java.net.minecraft.util.Formatting;

public class RecipeCostTooltipComponent
implements EmiTooltipComponent {
    private static final Text COST = EmiPort.translatable("emi.cost_per");
    private final List<Node> nodes = Lists.newArrayList();
    public final MaterialTree tree;
    private int maxWidth = 0;

    public RecipeCostTooltipComponent(EmiRecipe recipe) {
        this.tree = new MaterialTree(recipe);
        this.tree.batches = this.tree.cost.getIdealBatch(this.tree.goal, 1L, 1L);
        this.tree.calculateCost();
        this.addNodes();
    }

    public boolean shouldDisplay() {
        return !this.nodes.isEmpty();
    }

    public void addNodes() {
        double batches = this.tree.batches;
        List costs = Stream.concat(this.tree.cost.costs.values().stream(), this.tree.cost.chanceCosts.values().stream()).sorted((a, b) -> Integer.compare(EmiStackList.indices.getOrDefault((Object)a.ingredient.getEmiStacks().get(0), Integer.MAX_VALUE), EmiStackList.indices.getOrDefault((Object)b.ingredient.getEmiStacks().get(0), Integer.MAX_VALUE))).collect(Collectors.toList());
        for (FlatMaterialCost cost : costs) {
            if (cost instanceof ChanceMaterialCost) {
                ChanceMaterialCost cmc = (ChanceMaterialCost)cost;
                this.nodes.add(new Node(cost.ingredient, (double)cost.amount / batches * (double)cmc.chance, true));
                continue;
            }
            this.nodes.add(new Node(cost.ingredient, (double)cost.amount / batches, false));
        }
        this.positionNodes();
    }

    public void positionNodes() {
        int wrapWidth = this.getWrapWidth();
        int padding = 8;
        int x = 0;
        int y = 10;
        this.maxWidth = 0;
        for (Node node : this.nodes) {
            int width = 16 + EmiRenderHelper.getAmountOverflow(node.text);
            if (x + width > wrapWidth) {
                x = 0;
                y += 18;
            }
            this.maxWidth = Math.max(this.maxWidth, x + width);
            node.x = x;
            node.y = y;
            x += width + padding;
        }
    }

    public int getWrapWidth() {
        return 160;
    }

    @Override
    public int getHeight() {
        if (!this.nodes.isEmpty()) {
            return this.nodes.get((int)(this.nodes.size() - 1)).y + 18;
        }
        return 10;
    }

    @Override
    public int getWidth(FontRenderer fontRenderer) {
        return Math.max(fontRenderer.getStringWidth(COST.asString()), this.maxWidth);
    }

    @Override
    public void drawTooltip(EmiDrawContext context, EmiTooltipComponent.TooltipRenderData render) {
        for (Node node : this.nodes) {
            context.drawStack(node.stack, node.x, node.y);
            EmiRenderHelper.renderAmount(context, node.x, node.y, node.text);
        }
    }

    @Override
    public void drawTooltipText(EmiTooltipComponent.TextRenderData text) {
        text.draw(COST, 0, 0, (int)Formatting.GRAY.getColorValue(), true);
    }

    private static class Node {
        public final EmiIngredient stack;
        public final Text text;
        public int x;
        public int y;

        public Node(EmiIngredient stack, double amount, boolean chanced) {
            this.stack = stack;
            this.text = chanced ? EmiPort.append(EmiPort.literal("\u2248"), EmiRenderHelper.getAmountText(stack, amount)).formatted(Formatting.GOLD) : EmiRenderHelper.getAmountText(stack, amount);
        }
    }
}

