/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.tooltip;

import dev.emi.emi.EmiPort;
import dev.emi.emi.runtime.EmiDrawContext;
import net.minecraft.FontRenderer;
import net.minecraft.Minecraft;
import net.minecraft.RenderItem;
import shims.java.com.unascribed.retroemi.RetroEMI;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.text.Text;

public interface EmiTooltipComponent
extends TooltipComponent {
    default public void drawTooltip(EmiDrawContext context, TooltipRenderData tooltip) {
    }

    default public void drawTooltipText(TextRenderData text) {
    }

    @Override
    default public void drawItems(FontRenderer fontRenderer, int x, int y) {
        EmiDrawContext context = EmiDrawContext.instance();
        context.push();
        context.matrices().translate(x, y, 0.0);
        Minecraft client = Minecraft.getMinecraft();
        this.drawTooltip(context, new TooltipRenderData(fontRenderer, RetroEMI.instance.itemRenderer, x, y));
        context.pop();
    }

    @Override
    default public void drawText(FontRenderer fontRenderer, int x, int y) {
        this.drawTooltipText(new TextRenderData(fontRenderer, x, y));
    }

    public static class TooltipRenderData {
        public final FontRenderer text;
        public final RenderItem item;
        public final int x;
        public final int y;

        public TooltipRenderData(FontRenderer text, RenderItem item, int x, int y) {
            this.text = text;
            this.item = item;
            this.x = x;
            this.y = y;
        }
    }

    public static class TextRenderData {
        public final FontRenderer renderer;
        public final int x;
        public final int y;

        public TextRenderData(FontRenderer renderer, int x, int y) {
            this.renderer = renderer;
            this.x = x;
            this.y = y;
        }

        public void draw(String text, int x, int y, int color, boolean shadow) {
            this.draw(EmiPort.literal(text), x, y, color, shadow);
        }

        public void draw(Text text, int x, int y, int color, boolean shadow) {
            this.renderer.drawString(text.asString(), x + this.x, y + this.y, color, shadow);
        }
    }
}

