/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.tooltip;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.tooltip.EmiTooltipComponent;
import java.util.Arrays;
import java.util.List;
import net.minecraft.FontRenderer;
import net.minecraft.ItemStack;
import net.minecraft.Minecraft;
import shims.java.net.minecraft.text.Text;

public class EmiSecondaryOutputComponent
implements EmiTooltipComponent {
    private final List<? extends EmiIngredient> secondaryOutputs;

    public EmiSecondaryOutputComponent(ItemStack[] secondaryOutputs) {
        this.secondaryOutputs = Arrays.stream(secondaryOutputs).map(EmiStack::of).toList();
    }

    @Override
    public int getHeight() {
        return 27;
    }

    @Override
    public int getWidth(FontRenderer textRenderer) {
        int charWidth = Minecraft.getMinecraft().fontRenderer.getStringWidth(Text.translatable("tooltip.emi.recipe_remainder").toString());
        return Math.max(charWidth, this.secondaryOutputs.size() * 18);
    }

    @Override
    public void drawTooltip(EmiDrawContext context, EmiTooltipComponent.TooltipRenderData tooltip) {
        context.drawTextWithShadow(Text.translatable("tooltip.emi.recipe_remainder"), 0, 0, 0xFFFFFF);
        for (int i = 0; i < this.secondaryOutputs.size(); ++i) {
            context.drawStack(this.secondaryOutputs.get(i), 18 * i, 9);
        }
    }
}

