/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiFillAction;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.chess.EmiChess;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.HeaderType;
import dev.emi.emi.config.Margins;
import dev.emi.emi.config.ScreenAlign;
import dev.emi.emi.config.SidebarPages;
import dev.emi.emi.config.SidebarSettings;
import dev.emi.emi.config.SidebarSide;
import dev.emi.emi.config.SidebarSubpanels;
import dev.emi.emi.config.SidebarTheme;
import dev.emi.emi.config.SidebarType;
import dev.emi.emi.input.EmiBind;
import dev.emi.emi.input.EmiInput;
import dev.emi.emi.network.CreateItemC2SPacket;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.platform.EmiClient;
import dev.emi.emi.registry.EmiDragDropHandlers;
import dev.emi.emi.registry.EmiExclusionAreas;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.emi.emi.registry.EmiRecipes;
import dev.emi.emi.registry.EmiStackProviders;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiFavorite;
import dev.emi.emi.runtime.EmiFavorites;
import dev.emi.emi.runtime.EmiHidden;
import dev.emi.emi.runtime.EmiHistory;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.runtime.EmiReloadManager;
import dev.emi.emi.runtime.EmiSidebars;
import dev.emi.emi.screen.ConfigScreen;
import dev.emi.emi.screen.EmiScreen;
import dev.emi.emi.screen.StackBatcher;
import dev.emi.emi.screen.tooltip.RecipeTooltipComponent;
import dev.emi.emi.screen.widget.EmiSearchWidget;
import dev.emi.emi.screen.widget.SidebarButtonWidget;
import dev.emi.emi.screen.widget.SizedButtonWidget;
import dev.emi.emi.search.EmiSearch;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import moddedmite.emi.api.EMIGuiTextField;
import moddedmite.emi.api.EMIPlayerControllerMP;
import net.minecraft.EntityPlayer;
import net.minecraft.GuiContainer;
import net.minecraft.GuiContainerCreative;
import net.minecraft.GuiScreen;
import net.minecraft.GuiTextField;
import net.minecraft.ItemStack;
import net.minecraft.MathHelper;
import net.minecraft.Minecraft;
import net.minecraft.Packet;
import net.minecraft.Packet3Chat;
import net.minecraft.ScaledResolution;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import shims.java.com.mojang.blaze3d.systems.RenderSystem;
import shims.java.com.unascribed.retroemi.ItemStacks;
import shims.java.com.unascribed.retroemi.RetroEMI;
import shims.java.net.minecraft.client.gui.Element;
import shims.java.net.minecraft.client.gui.ParentElement;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.client.gui.widget.TextFieldWidget;
import shims.java.net.minecraft.client.util.math.MatrixStack;
import shims.java.net.minecraft.text.MutableText;
import shims.java.net.minecraft.text.Text;
import shims.java.net.minecraft.util.Formatting;

public class EmiScreenManager {
    private static final int PADDING_SIZE = 1;
    private static final int ENTRY_SIZE = 18;
    private static final int SUBPANEL_SEPARATOR_SIZE = 3;
    private static Minecraft client = Minecraft.getMinecraft();
    private static List<? extends EmiIngredient> searchedStacks = List.of();
    private static int lastWidth;
    private static int lastHeight;
    private static List<Bounds> lastExclusion;
    private static List<SidebarPanel> panels;
    public static ItemStack lastStackTooltipRendered;
    private static long lastPlayerInventorySync;
    public static EmiPlayerInventory lastPlayerInventory;
    public static int lastMouseX;
    public static int lastMouseY;
    public static EmiIngredient pressedStack;
    public static EmiIngredient draggedStack;
    private static EmiStackInteraction lastHoveredCraftable;
    private static boolean lastHoveredCraftableSturdy;
    private static int lastHoveredCraftableOffset;
    private static double scrollAcc;
    static ScaledResolution scaledResolution;
    static int screenWidth;
    static int screenHeight;
    public static EmiSearchWidget search;
    public static SizedButtonWidget emi;
    public static SizedButtonWidget tree;

    public static boolean isDisabled() {
        return !EmiReloadManager.isLoaded() || !EmiConfig.enabled;
    }

    public static void recalculate() {
        GuiScreen screen;
        EmiScreenManager.updateCraftables();
        SidebarPanel searchPanel = EmiScreenManager.getSearchPanel();
        if (searchPanel != null && searchPanel.space != null && searchedStacks != EmiSearch.stacks) {
            searchPanel.space.batcher.repopulate();
            searchedStacks = EmiSearch.stacks;
        }
        if ((screen = EmiScreenManager.client.currentScreen) == null) {
            return;
        }
        List<Bounds> exclusion = EmiExclusionAreas.getExclusion(screen);
        if (lastWidth == screen.width && lastHeight == screen.height && exclusion.size() == lastExclusion.size()) {
            boolean same = true;
            for (int i = 0; i < exclusion.size(); ++i) {
                Bounds a = exclusion.get(i);
                Bounds b = lastExclusion.get(i);
                if (a.x() == b.x() && a.y() == b.y() && a.width() == b.width() && a.height() == b.height()) continue;
                same = false;
                break;
            }
            if (same) {
                return;
            }
        }
        for (SidebarPanel panel : panels) {
            for (ScreenSpace space : panel.getSpaces()) {
                space.batcher.repopulate();
            }
        }
        lastWidth = screen.width;
        lastHeight = screen.height;
        lastExclusion = exclusion;
        Object panel = RetroEMI.emify(screen);
        if (panel instanceof EmiScreen) {
            EmiScreen emi = (EmiScreen)panel;
            int left = Math.max(36, emi.emi$getLeft());
            int right = Math.min(screen.width - 36, emi.emi$getRight());
            int top = emi.emi$getTop();
            int bottom = emi.emi$getBottom();
            ArrayList spaceExclusion = Lists.newArrayList();
            spaceExclusion.addAll(exclusion);
            EmiScreenManager.createScreenSpace(panels.get(0), screen, spaceExclusion, false, new Bounds(0, 0, left, screen.height), SidebarSettings.LEFT);
            EmiScreenManager.createScreenSpace(panels.get(1), screen, spaceExclusion, true, new Bounds(right, 0, screen.width - right, screen.height), SidebarSettings.RIGHT);
            spaceExclusion = Lists.newArrayList();
            if (panels.get(0).isVisible()) {
                spaceExclusion.add(panels.get(0).getBounds());
            }
            if (panels.get(1).isVisible()) {
                spaceExclusion.add(panels.get(1).getBounds());
            }
            spaceExclusion.addAll(exclusion);
            int topCenter = EmiConfig.topSidebarSize.values.get(0) * 18 / 2 + EmiConfig.topSidebarTheme.horizontalPadding;
            int topSpaceBottom = switch (EmiConfig.topSidebarAlign.horizontal) {
                default -> throw new IncompatibleClassChangeError();
                case ScreenAlign.Horizontal.LEFT -> EmiScreenManager.getVerticalConstraint(panels.get(0), EmiConfig.topSidebarMargins.left() + topCenter, top, screen.height, true);
                case ScreenAlign.Horizontal.CENTER -> top;
                case ScreenAlign.Horizontal.RIGHT -> EmiScreenManager.getVerticalConstraint(panels.get(1), right - EmiConfig.topSidebarMargins.right() + topCenter, top, screen.height, true);
            };
            boolean topRtl = EmiConfig.topSidebarAlign.horizontal == ScreenAlign.Horizontal.RIGHT;
            EmiScreenManager.createScreenSpace(panels.get(2), screen, spaceExclusion, topRtl, new Bounds(0, 0, screen.width, topSpaceBottom), SidebarSettings.TOP);
            int bottomCenter = EmiConfig.bottomSidebarSize.values.get(0) * 18 / 2 + EmiConfig.bottomSidebarTheme.horizontalPadding;
            int bottomSpaceTop = switch (EmiConfig.bottomSidebarAlign.horizontal) {
                default -> throw new IncompatibleClassChangeError();
                case ScreenAlign.Horizontal.LEFT -> EmiScreenManager.getVerticalConstraint(panels.get(0), EmiConfig.bottomSidebarMargins.left() + bottomCenter, bottom, 0, false);
                case ScreenAlign.Horizontal.CENTER -> bottom;
                case ScreenAlign.Horizontal.RIGHT -> EmiScreenManager.getVerticalConstraint(panels.get(1), EmiConfig.bottomSidebarMargins.right() + bottomCenter, bottom, 0, false);
            };
            boolean bottomRtl = EmiConfig.bottomSidebarAlign.horizontal == ScreenAlign.Horizontal.RIGHT;
            EmiScreenManager.createScreenSpace(panels.get(3), screen, spaceExclusion, bottomRtl, new Bounds(0, bottomSpaceTop, screen.width, screen.height - bottomSpaceTop), SidebarSettings.BOTTOM);
            EmiScreenManager.updateSidebarButtons();
        }
    }

    private static void updateCraftables() {
        int minDelay = 400;
        if (EmiScreenManager.hasSidebarVisible(SidebarType.CRAFTABLES)) {
            minDelay = 50;
        }
        if (lastPlayerInventory == null || Math.abs(System.currentTimeMillis() - lastPlayerInventorySync) >= (long)minDelay) {
            lastPlayerInventorySync = System.currentTimeMillis();
            EmiPlayerInventory inv = EmiPlayerInventory.of((EntityPlayer)EmiScreenManager.client.thePlayer);
            SidebarPanel searchPanel = EmiScreenManager.getSearchPanel();
            if (!inv.isEqual(lastPlayerInventory)) {
                lastPlayerInventory = inv;
                EmiSidebars.craftables = lastPlayerInventory.getCraftables();
                if (searchPanel != null && searchPanel.space != null) {
                    searchPanel.space.batcher.repopulate();
                    if (searchPanel.getType() == SidebarType.CRAFTABLES) {
                        EmiSearch.update();
                    }
                }
                EmiFavorites.updateSynthetic(inv);
                EmiScreenManager.repopulatePanels(SidebarType.CRAFTABLES);
            }
        }
    }

    public static void forceRecalculate() {
        lastWidth = -1;
        lastPlayerInventory = null;
        EmiScreenManager.recalculate();
    }

    public static void updateSearchSidebar() {
        if (EmiScreenManager.search.isFocused || !search.getText().isEmpty()) {
            EmiScreenManager.focusSearchSidebarType(EmiConfig.searchSidebarFocus);
        } else {
            EmiScreenManager.focusSearchSidebarType(EmiConfig.emptySearchSidebarFocus);
        }
    }

    private static int getVerticalConstraint(SidebarPanel panel, int cx, int def, int max, boolean top) {
        Bounds bounds;
        if (panel.isVisible() && (bounds = panel.getBounds()).x() <= cx && bounds.right() >= cx) {
            return top ? Math.max(def, bounds.top()) : Math.min(def, bounds.bottom());
        }
        return max;
    }

    private static void createScreenSpace(SidebarPanel panel, GuiScreen screen, List<Bounds> exclusion, boolean rtl, Bounds bounds, SidebarSettings settings) {
        Margins margins = settings.margins();
        ScreenAlign align = settings.align();
        SidebarTheme theme = settings.theme();
        SidebarSubpanels subpanels = settings.subpanels();
        boolean header = settings.header() == HeaderType.VISIBLE;
        int maxWidth = settings.size().values.get(0);
        int maxHeight = settings.size().values.get(1);
        int subpanelHeight = 0;
        for (SidebarSubpanels.Subpanel subpanel : subpanels.subpanels) {
            subpanelHeight += subpanel.rows() * 18 + 3;
            maxHeight -= subpanel.rows();
        }
        if (panel.getType() == SidebarType.CHESS) {
            maxWidth = 8;
            maxHeight = 8;
            theme = SidebarTheme.MODERN;
        }
        int cx = bounds.x() + bounds.width() / 2;
        int cy = bounds.y() + bounds.height() / 2;
        int headerOffset = header ? 18 : 0;
        int idealWidth = Math.min(maxWidth * 18 + margins.left() + margins.right() + theme.horizontalPadding * 2, bounds.width());
        int idealHeight = Math.min(maxHeight * 18 + margins.top() + margins.bottom() + theme.verticalPadding * 2 + headerOffset + subpanelHeight, bounds.height());
        int idealX = switch (align.horizontal) {
            default -> throw new IncompatibleClassChangeError();
            case ScreenAlign.Horizontal.LEFT -> bounds.x();
            case ScreenAlign.Horizontal.CENTER -> bounds.x() + bounds.width() / 2 - idealWidth / 2;
            case ScreenAlign.Horizontal.RIGHT -> bounds.right() - idealWidth;
        };
        int idealY = switch (align.horizontal) {
            default -> throw new IncompatibleClassChangeError();
            case ScreenAlign.Horizontal.LEFT -> bounds.y();
            case ScreenAlign.Horizontal.CENTER -> bounds.y() + bounds.height() / 2 - idealHeight / 2;
            case ScreenAlign.Horizontal.RIGHT -> bounds.bottom() - idealHeight;
        };
        Bounds idealBounds = EmiScreenManager.constrainBounds(exclusion, new Bounds(idealX, idealY, idealWidth, idealHeight), align, headerOffset);
        bounds = EmiScreenManager.constrainBounds(exclusion, bounds, align, headerOffset);
        if (Math.min(idealWidth, idealBounds.width()) * Math.min(idealHeight, idealBounds.height()) > Math.min(idealWidth, bounds.width()) * Math.min(idealHeight, bounds.height())) {
            bounds = idealBounds;
        }
        int xMin = bounds.left() + margins.left() + theme.horizontalPadding;
        int xMax = bounds.right() - margins.right() - theme.horizontalPadding;
        int yMin = bounds.top() + margins.top() + theme.verticalPadding;
        int yMax = bounds.bottom() - margins.bottom() - theme.verticalPadding;
        int xSpan = xMax - xMin;
        int ySpan = yMax - yMin;
        int tw = Math.max(0, Math.min(xSpan / 18, maxWidth));
        int th = Math.max(0, Math.min((ySpan - headerOffset - subpanelHeight) / 18, maxHeight));
        int hl = xMin;
        int hr = xMax - tw * 18;
        int tx = switch (align.horizontal) {
            default -> throw new IncompatibleClassChangeError();
            case ScreenAlign.Horizontal.LEFT -> hl;
            case ScreenAlign.Horizontal.CENTER -> MathHelper.clamp_int((int)(cx - tw * 18 / 2), (int)hl, (int)hr);
            case ScreenAlign.Horizontal.RIGHT -> hr;
        };
        int vt = yMin + headerOffset;
        int vb = yMax - th * 18 - subpanelHeight;
        int ty = switch (align.vertical) {
            default -> throw new IncompatibleClassChangeError();
            case ScreenAlign.Vertical.TOP -> vt;
            case ScreenAlign.Vertical.CENTER -> MathHelper.clamp_int((int)(cy - (th * 18 - headerOffset + subpanelHeight + theme.verticalPadding / 2) / 2), (int)vt, (int)vb);
            case ScreenAlign.Vertical.BOTTOM -> vb;
        };
        panel.header = header;
        panel.theme = theme;
        ScreenSpace space = new ScreenSpace(tx, ty, tw, th, rtl, exclusion, () -> panel.getType(), panel.isSearch());
        ArrayList subspaces = Lists.newArrayList();
        for (SidebarSubpanels.Subpanel subpanel : subpanels.subpanels) {
            th = subpanel.rows();
            subspaces.add(new ScreenSpace(tx, ty += th * 18 + 3, tw, th, rtl, exclusion, () -> subpanel.type, false));
        }
        panel.setSpaces(space, subspaces);
    }

    private static Bounds constrainBounds(List<Bounds> exclusion, Bounds bounds, ScreenAlign align, int headerOffset) {
        for (int i = 0; i < exclusion.size(); ++i) {
            Bounds overlap = exclusion.get(i).overlap(bounds);
            if (overlap.empty() || overlap.top() >= bounds.top() + 18 + headerOffset && overlap.width() < bounds.width() * 2 / 3 && overlap.height() < bounds.height() / 3) continue;
            int widthFactor = overlap.width() * 10 / bounds.width();
            int heightFactor = overlap.height() * 10 / bounds.height();
            if (heightFactor < widthFactor) {
                int cy = bounds.y() + bounds.height() / 2;
                int ocy = overlap.y() + overlap.height() / 2;
                bounds = (cy += (switch (align.vertical) {
                    default -> throw new IncompatibleClassChangeError();
                    case ScreenAlign.Vertical.TOP -> -bounds.height() / 4;
                    case ScreenAlign.Vertical.CENTER -> 0;
                    case ScreenAlign.Vertical.BOTTOM -> bounds.height() / 4;
                })) < ocy ? new Bounds(bounds.x(), bounds.y(), bounds.width(), overlap.top() - bounds.top()) : new Bounds(bounds.x(), overlap.bottom(), bounds.width(), bounds.bottom() - overlap.bottom());
            } else {
                int cx = bounds.x() + bounds.width() / 2;
                int ocx = overlap.x() + overlap.width() / 2;
                bounds = (cx += (switch (align.horizontal) {
                    default -> throw new IncompatibleClassChangeError();
                    case ScreenAlign.Horizontal.LEFT -> -bounds.width() / 4;
                    case ScreenAlign.Horizontal.CENTER -> 0;
                    case ScreenAlign.Horizontal.RIGHT -> bounds.width() / 4;
                })) < ocx ? new Bounds(bounds.x(), bounds.y(), overlap.left() - bounds.left(), bounds.height()) : new Bounds(overlap.right(), bounds.y(), bounds.right() - overlap.right(), bounds.height());
            }
            i = -1;
        }
        if (bounds.empty()) {
            return Bounds.EMPTY;
        }
        return bounds;
    }

    public static void focusSearchSidebarType(SidebarType type) {
        SidebarPanel search = EmiScreenManager.getSearchPanel();
        if (search != null && search.supportsType(type)) {
            search.setType(type);
        }
    }

    public static void focusSidebarType(SidebarType type) {
        for (SidebarPanel panel : panels) {
            if (!panel.supportsType(type)) continue;
            panel.setType(type);
        }
    }

    @Nullable
    public static SidebarPanel getPanelFor(SidebarSide side) {
        for (SidebarPanel panel : panels) {
            if (panel.side != side) continue;
            return panel;
        }
        return null;
    }

    @Nullable
    public static SidebarPanel getPanelFor(SidebarType type) {
        for (SidebarPanel panel : panels) {
            if (panel.getType() != type) continue;
            return panel;
        }
        return null;
    }

    @Nullable
    public static SidebarPanel getHoveredPanel(int mouseX, int mouseY) {
        for (SidebarPanel panel : panels) {
            if (!panel.getBounds().contains(mouseX, mouseY) || !panel.isVisible()) continue;
            return panel;
        }
        return null;
    }

    @Nullable
    public static ScreenSpace getHoveredSpace(int mouseX, int mouseY) {
        SidebarPanel panel = EmiScreenManager.getHoveredPanel(mouseX, mouseY);
        if (panel != null) {
            return panel.getHoveredSpace(mouseX, mouseY);
        }
        return null;
    }

    public static boolean hasSidebarVisible(SidebarType type) {
        for (SidebarPanel panel : panels) {
            for (ScreenSpace space : panel.getSpaces()) {
                if (type != space.getType()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSidebarAvailable(SidebarType type) {
        for (SidebarPanel panel : panels) {
            if (!panel.supportsType(type)) continue;
            return true;
        }
        return false;
    }

    public static void repopulatePanels(SidebarType type) {
        for (SidebarPanel panel : panels) {
            for (ScreenSpace space : panel.getSpaces()) {
                if (space.getType() != type) continue;
                space.batcher.repopulate();
            }
        }
    }

    public static SidebarPanel getSearchPanel() {
        for (SidebarPanel panel : panels) {
            if (!panel.isSearch()) continue;
            return panel;
        }
        return null;
    }

    public static void toggleSidebarType(SidebarType type) {
        boolean visible = false;
        for (SidebarPanel panel : panels) {
            if (panel.getType() != type) continue;
            visible = true;
            panel.cycleType(1);
        }
        if (!visible) {
            EmiScreenManager.focusSidebarType(type);
        }
    }

    public static List<? extends EmiIngredient> getSearchSource() {
        SidebarPanel search = EmiScreenManager.getSearchPanel();
        if (search == null) {
            return List.of();
        }
        return EmiSidebars.getStacks(search.getType());
    }

    public static EmiStackInteraction getHoveredStack(int mouseX, int mouseY, boolean notClick) {
        return EmiScreenManager.getHoveredStack(mouseX, mouseY, notClick, false);
    }

    public static int getDebugTextX() {
        int x = 4;
        if (EmiScreenManager.emi.visible) {
            x = Math.max(4, 26);
        }
        if (EmiScreenManager.tree.visible) {
            x = Math.max(4, 48);
        }
        return x;
    }

    public static EmiStackInteraction getHoveredStack(int mouseX, int mouseY, boolean notClick, boolean ignoreLastHoveredCraftable) {
        if (EmiScreenManager.client.currentScreen == null) {
            return EmiStackInteraction.EMPTY;
        }
        EmiStackInteraction stack = EmiStackProviders.getStackAt(EmiScreenManager.client.currentScreen, mouseX, mouseY, notClick);
        if (!stack.isEmpty()) {
            return stack;
        }
        if (!ignoreLastHoveredCraftable && lastHoveredCraftable != null) {
            if (lastHoveredCraftable.getRecipeContext() == null || !lastHoveredCraftableSturdy && lastPlayerInventory != null && !lastPlayerInventory.canCraft(lastHoveredCraftable.getRecipeContext())) {
                lastHoveredCraftable = null;
            } else {
                return lastHoveredCraftable;
            }
        }
        for (SidebarPanel panel : panels) {
            for (ScreenSpace space : panel.getSpaces()) {
                if (!panel.isVisible() || space.pageSize <= 0 || !space.contains(mouseX, mouseY) || mouseX < space.tx || mouseY < space.ty) continue;
                int x = (mouseX - space.tx) / 18;
                int y = (mouseY - space.ty) / 18;
                int n = space.getRawOffset(x, y);
                if (n >= 0 && space == panel.space) {
                    n += space.pageSize * panel.page;
                }
                if (n < 0 || n >= space.getStacks().size()) continue;
                EmiIngredient hovered = space.getStacks().get(n);
                if (hovered instanceof EmiFavorite) {
                    EmiFavorite fav = (EmiFavorite)hovered;
                    return new SidebarEmiStackInteraction(hovered, space, fav.getRecipe(), true);
                }
                return new SidebarEmiStackInteraction(hovered, space);
            }
        }
        if (lastStackTooltipRendered != null && notClick) {
            return new EmiStackInteraction(EmiStack.of(lastStackTooltipRendered));
        }
        return EmiStackInteraction.EMPTY;
    }

    private static void updateMouse(int mouseX, int mouseY) {
        if (lastHoveredCraftable != null) {
            ScreenSpace space = EmiScreenManager.getHoveredSpace(mouseX, mouseY);
            if (space != null && (space.getType() == SidebarType.CRAFTABLES || space.getType() == SidebarType.CRAFT_HISTORY)) {
                int offset = space.getRawOffsetFromMouse(mouseX, mouseY);
                if (offset != lastHoveredCraftableOffset) {
                    lastHoveredCraftable = null;
                }
            } else {
                lastHoveredCraftable = null;
            }
        }
        lastMouseX = mouseX;
        lastMouseY = mouseY;
    }

    public static void drawBackground(EmiDrawContext context, int mouseX, int mouseY, float delta) {
        EmiScreenManager.updateMouse(mouseX, mouseY);
        EmiScreenManager.recalculate();
        GuiScreen screen = EmiScreenManager.client.currentScreen;
        if (screen == null) {
            return;
        }
        Iterator<SidebarPanel> iterator = RetroEMI.emify(screen);
        if (iterator instanceof EmiScreen) {
            EmiScreen emi = (EmiScreen)((Object)iterator);
            EmiScreenManager.client.mcProfiler.startSection("sidebar");
            for (SidebarPanel panel : panels) {
                panel.drawBackground(context, mouseX, mouseY, delta);
            }
        }
    }

    public static void render(EmiDrawContext context, int mouseX, int mouseY, float delta) {
        EmiScreenManager.client.mcProfiler.startSection("emi");
        EmiScreenManager.updateMouse(mouseX, mouseY);
        EmiScreenManager.recalculate();
        GuiScreen screen = EmiScreenManager.client.currentScreen;
        if (screen == null) {
            EmiScreenManager.client.mcProfiler.endSection();
            return;
        }
        boolean visible = !EmiScreenManager.isDisabled();
        EmiScreenManager.emi.visible = EmiConfig.emiConfigButtonVisibility.resolve(visible);
        EmiScreenManager.tree.visible = EmiConfig.recipeTreeButtonVisibility.resolve(visible);
        for (SidebarPanel panel : panels) {
            panel.updateWidgetVisibility();
        }
        if (EmiScreenManager.isDisabled()) {
            if (!EmiReloadManager.isLoaded()) {
                int reloadInfoX = EmiScreenManager.getDebugTextX();
                if (EmiReloadManager.getStatus() == -1) {
                    context.drawTextWithShadow(EmiPort.translatable("emi.reloading.error"), reloadInfoX, screen.height - 16);
                } else if (EmiReloadManager.getStatus() == 0) {
                    context.drawTextWithShadow(EmiPort.translatable("emi.reloading.waiting"), reloadInfoX, screen.height - 16);
                } else {
                    context.drawTextWithShadow(EmiPort.translatable("emi.reloading"), reloadInfoX, screen.height - 16);
                    context.drawTextWithShadow(EmiReloadManager.reloadStep, reloadInfoX, screen.height - 26);
                    if (System.currentTimeMillis() > EmiReloadManager.reloadWorry) {
                        context.drawTextWithShadow(EmiPort.translatable("emi.reloading.worry"), reloadInfoX, screen.height - 36);
                    }
                }
            }
            EmiScreenManager.client.mcProfiler.endSection();
            lastHoveredCraftable = null;
            return;
        }
        if (EmiRecipes.activeWorker != null) {
            context.drawTextWithShadow(EmiPort.translatable("emi.reloading.still_baking_recipes"), 48, screen.height - 16);
        } else {
            EmiScreenManager.renderDevMode(context, mouseX, mouseY, delta, screen);
        }
        EmiScreenManager.renderWidgets(context, mouseX, mouseY, delta, screen);
        EmiScreenManager.client.mcProfiler.startSection("sidebars");
        Iterator<SidebarPanel> iterator = RetroEMI.emify(screen);
        if (iterator instanceof EmiScreen) {
            EmiScreen emi = (EmiScreen)((Object)iterator);
            EmiScreenManager.client.mcProfiler.startSection("sidebar");
            for (SidebarPanel panel : panels) {
                panel.render(context, mouseX, mouseY, delta);
            }
            EmiScreenManager.renderLastHoveredCraftable(context, mouseX, mouseY, delta, screen);
            EmiScreenManager.client.mcProfiler.endSection();
        }
        EmiScreenManager.client.mcProfiler.endSection();
        EmiScreenManager.renderExclusionAreas(context, mouseX, mouseY, delta, screen);
        EmiScreenManager.client.mcProfiler.endSection();
    }

    public static void drawForeground(EmiDrawContext context, int mouseX, int mouseY, float delta) {
        GuiScreen screen = EmiScreenManager.client.currentScreen;
        if (RetroEMI.emify(screen) instanceof EmiScreen && !EmiScreenManager.isDisabled()) {
            EmiScreenManager.renderDraggedStack(context, mouseX, mouseY, delta, screen);
            EmiScreenManager.renderCurrentTooltip(context, mouseX, mouseY, delta, screen);
        }
    }

    private static void renderWidgets(EmiDrawContext context, int mouseX, int mouseY, float delta, GuiScreen screen) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.push();
        context.matrices().translate(0.0, 0.0, 100.0);
        emi.render(context.raw(), mouseX, mouseY, delta);
        tree.render(context.raw(), mouseX, mouseY, delta);
        search.render(context.raw(), mouseX, mouseY, delta);
        context.pop();
    }

    private static void renderLastHoveredCraftable(EmiDrawContext context, int mouseX, int mouseY, float delta, GuiScreen screen) {
        ScreenSpace space;
        EmiStackInteraction cur;
        if (lastHoveredCraftable != null && lastHoveredCraftableOffset != -1 && (cur = EmiScreenManager.getHoveredStack(mouseX, mouseY, false, true)).getRecipeContext() != lastHoveredCraftable.getRecipeContext() && (space = EmiScreenManager.getHoveredSpace(mouseX, mouseY)) != null && (space.getType() == SidebarType.CRAFTABLES || space.getType() == SidebarType.CRAFT_HISTORY)) {
            MatrixStack view = MatrixStack.INSTANCE;
            view.push();
            view.translate(0.0, 0.0, 200.0);
            int lhx = space.getRawX(lastHoveredCraftableOffset);
            int lhy = space.getRawY(lastHoveredCraftableOffset);
            context.fill(lhx, lhy, 18, 18, 1151992063);
            lastHoveredCraftable.getStack().render(context.raw(), lhx + 1, lhy + 1, delta, 1);
            view.pop();
        }
    }

    private static void renderDraggedStack(EmiDrawContext context, int mouseX, int mouseY, float delta, GuiScreen screen) {
        if (!draggedStack.isEmpty()) {
            ScreenSpace space;
            SidebarPanel panel = EmiScreenManager.getHoveredPanel(mouseX, mouseY);
            if (panel != null && (space = panel.getHoveredSpace(mouseX, mouseY)) != null && space.getType() == SidebarType.FAVORITES) {
                int pageSize = space.pageSize;
                int page = panel.page;
                int index = space.getClosestEdge(mouseX, mouseY);
                if (index + pageSize * page > EmiFavorites.favorites.size()) {
                    index = EmiFavorites.favorites.size() - pageSize * page;
                }
                if (index + pageSize * page > space.getStacks().size()) {
                    index = space.getStacks().size() - pageSize * page;
                }
                if (index >= 0) {
                    context.push();
                    context.matrices().translate(0.0, 0.0, 200.0);
                    int dx = space.getEdgeX(index);
                    int dy = space.getEdgeY(index);
                    context.fill(dx - 1, dy, 2, 18, -16711681);
                    context.pop();
                }
            }
            EmiDragDropHandlers.render(screen, draggedStack, context.raw(), mouseX, mouseY, delta);
            MatrixStack view = MatrixStack.INSTANCE;
            view.push();
            view.translate(0.0, 0.0, 400.0);
            draggedStack.render(context.raw(), mouseX - 8, mouseY - 8, delta, 1);
            view.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderCurrentTooltip(EmiDrawContext context, int mouseX, int mouseY, float delta, GuiScreen screen) {
        block15: {
            try {
                ItemStack cursor = EmiScreenManager.client.thePlayer.inventory.getItemStack();
                ScreenSpace space = EmiScreenManager.getHoveredSpace(mouseX, mouseY);
                if (EmiConfig.cheatMode && !ItemStacks.isEmpty(cursor) && space != null && space.getType() == SidebarType.INDEX && EmiConfig.deleteCursorStack.isBound()) {
                    List<TooltipComponent> list = List.of(TooltipComponent.of(EmiPort.ordered(EmiPort.translatable("emi.delete_stack"))), TooltipComponent.of(EmiPort.ordered(EmiConfig.deleteCursorStack.getBindText())));
                    if (space.rtl) {
                        EmiRenderHelper.drawLeftTooltip(screen, context, list, mouseX, mouseY);
                    } else {
                        EmiRenderHelper.drawTooltip(screen, context, list, mouseX, mouseY);
                    }
                }
                if (!ItemStacks.isEmpty(cursor) || !draggedStack.isEmpty()) break block15;
                EmiScreenManager.client.mcProfiler.endStartSection("hover");
                try {
                    EmiRecipe recipe;
                    EmiIngredient hov = EmiStack.EMPTY;
                    SidebarType sidebar = SidebarType.NONE;
                    EmiStackInteraction emiStackInteraction = EmiScreenManager.getHoveredStack(mouseX, mouseY, false);
                    if (emiStackInteraction instanceof SidebarEmiStackInteraction) {
                        SidebarEmiStackInteraction sesi = (SidebarEmiStackInteraction)emiStackInteraction;
                        hov = sesi.getStack();
                        sidebar = sesi.getType();
                    }
                    ArrayList list = Lists.newArrayList();
                    list.addAll(hov.getTooltip());
                    if (EmiApi.getRecipeContext(hov) == null && EmiConfig.showCraft.isHeld() && (recipe = EmiUtil.getPreferredRecipe(hov, lastPlayerInventory, false)) != null) {
                        list.add(new RecipeTooltipComponent(recipe, true));
                    }
                    if (EmiConfig.editMode && sidebar == SidebarType.INDEX) {
                        list.add(TooltipComponent.of(EmiPort.translatable("emi.edit_mode.hide_one", EmiConfig.hideStack.getBindText()).asOrderedText()));
                        list.add(TooltipComponent.of(EmiPort.translatable("emi.edit_mode.hide_all", EmiConfig.hideStackById.getBindText()).asOrderedText()));
                    }
                    if (space != null && space.rtl) {
                        EmiRenderHelper.drawLeftTooltip(screen, context, list, mouseX, mouseY);
                    } else {
                        EmiRenderHelper.drawTooltip(screen, context, list, mouseX, mouseY);
                    }
                }
                finally {
                    EmiScreenManager.client.mcProfiler.endSection();
                }
            }
            catch (Exception e) {
                try {
                    EmiLog.error("Error rendering tooltip", e);
                    List<TooltipComponent> list = List.of(EmiTooltipComponents.of(EmiPort.literal("Error rendering tooltip", Formatting.RED)), EmiTooltipComponents.of(EmiPort.literal("See log", Formatting.GRAY)));
                    EmiRenderHelper.drawTooltip(screen, context, list, mouseX, mouseY);
                }
                catch (Exception e2) {
                    EmiLog.error("Critical error rendering tooltip", e);
                }
            }
        }
        lastStackTooltipRendered = null;
    }

    private static void renderDevMode(EmiDrawContext context, int mouseX, int mouseY, float delta, GuiScreen screen) {
        if (EmiConfig.devMode) {
            EmiScreenManager.client.mcProfiler.endStartSection("dev");
            int color = 0xFFFFFF;
            MutableText title = EmiPort.literal("EMI Dev Mode");
            int off = -16;
            int devTextX = EmiScreenManager.getDebugTextX();
            if (!EmiReloadLog.warnings.isEmpty()) {
                color = 0xFF0000;
                off = -11;
                String warnCount = EmiReloadLog.warningCount + " Warnings";
                context.drawTextWithShadow(EmiPort.literal(warnCount), devTextX, screen.height - 21, color);
                int width = Math.max(EmiScreenManager.client.fontRenderer.getStringWidth(title.asString()), EmiScreenManager.client.fontRenderer.getStringWidth(warnCount));
                if (mouseX >= devTextX && mouseX < width + devTextX && mouseY > screen.height - 28) {
                    context.raw().drawTooltip(EmiScreenManager.client.fontRenderer, Stream.concat(Stream.of(" EMI detected some issues, see log for full details"), EmiReloadLog.warnings.stream()).map(s -> {
                        Object a = s;
                        if (((String)a).length() > 10 && EmiScreenManager.client.fontRenderer.getStringWidth((String)a) > screen.width - 20) {
                            a = EmiScreenManager.client.fontRenderer.trimStringToWidth((String)a, screen.width - 30) + "...";
                        }
                        return EmiPort.literal((String)a);
                    }).collect(Collectors.toList()), 0, 20);
                }
            }
            context.drawTextWithShadow(title, devTextX, screen.height + off, color);
        }
    }

    private static void renderExclusionAreas(EmiDrawContext context, int mouseX, int mouseY, float delta, GuiScreen screen) {
        Iterator<SidebarPanel> iterator;
        if (EmiConfig.highlightExclusionAreas && (iterator = RetroEMI.emify(screen)) instanceof EmiScreen) {
            EmiScreen emi = (EmiScreen)((Object)iterator);
            for (SidebarPanel panel : panels) {
                if (!panel.isVisible()) continue;
                Bounds bounds = panel.getBounds();
                context.fill(bounds.left(), bounds.top(), bounds.width(), bounds.height(), 0x440000FF);
            }
            List<Bounds> exclusions = EmiExclusionAreas.getExclusion(screen);
            if (exclusions.size() == 0) {
                return;
            }
            for (int i = 0; i < exclusions.size(); ++i) {
                Bounds b = exclusions.get(i);
                context.fill(b.x(), b.y(), b.width(), b.height(), i == 0 ? 0x4400FF00 : 0x44FF0000);
            }
        }
    }

    public static void addWidgets(GuiScreen screen) {
        EmiScreenManager.forceRecalculate();
        if (EmiConfig.centerSearchBar || EmiScreenManager.panels.get((int)0).space == null || EmiScreenManager.panels.get((int)1).space == null) {
            EmiScreenManager.search.x = (screen.width - 160) / 2;
            EmiScreenManager.search.y = screen.height - 21;
            search.setWidth(160);
        } else if (EmiConfig.searchSidebar == SidebarSide.RIGHT) {
            EmiScreenManager.search.x = EmiScreenManager.panels.get((int)1).space.tx;
            EmiScreenManager.search.y = screen.height - 21;
            search.setWidth(EmiScreenManager.panels.get((int)1).space.tw * 18);
        } else {
            EmiScreenManager.search.x = EmiScreenManager.panels.get((int)0).space.tx;
            EmiScreenManager.search.y = screen.height - 21 - 21;
            search.setWidth(EmiScreenManager.panels.get((int)0).space.tw * 18);
        }
        EmiPort.focus(search, false);
        search.setVisible(EmiConfig.searchSidebar != SidebarSide.NONE);
        EmiScreenManager.emi.x = 2;
        EmiScreenManager.emi.y = screen.height - 22;
        EmiScreenManager.tree.x = 24;
        EmiScreenManager.tree.y = screen.height - 22;
        EmiScreenManager.updateSidebarButtons();
    }

    private static void updateSidebarButtons() {
        for (SidebarPanel panel : panels) {
            panel.updateWidgetPosition();
            panel.updateWidgetVisibility();
        }
    }

    public static boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        int sa = (int)(scrollAcc += amount);
        scrollAcc %= 1.0;
        if (EmiScreenManager.isDisabled()) {
            return false;
        }
        EmiScreenManager.recalculate();
        SidebarPanel panel = EmiScreenManager.getHoveredPanel((int)mouseX, (int)mouseY);
        if (panel != null) {
            panel.scroll(-sa);
            return true;
        }
        return false;
    }

    public static boolean mouseClicked(double mouseX, double mouseY, int button) {
        EmiIngredient ingredient;
        if (search.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (emi.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (tree.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        for (SidebarPanel panel : panels) {
            if (panel.cycle.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (panel.pageLeft.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (!panel.pageRight.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        if (EmiScreenManager.isDisabled()) {
            if (EmiConfig.toggleVisibility.matchesMouse(button)) {
                EmiScreenManager.toggleVisibility(true);
                return true;
            }
            return false;
        }
        EmiScreenManager.recalculate();
        pressedStack = ingredient = EmiScreenManager.getHoveredStack((int)mouseX, (int)mouseY, false).getStack();
        if (!ingredient.isEmpty()) {
            return true;
        }
        return EmiScreenManager.genericInteraction(bind -> bind.matchesMouse(button));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mouseReleased(double mouseX, double mouseY, int button) {
        try {
            if (EmiScreenManager.isDisabled()) {
                boolean bl = false;
                return bl;
            }
            int mx = (int)mouseX;
            int my = (int)mouseY;
            EmiScreenManager.recalculate();
            if (EmiConfig.cheatMode && Minecraft.inDevMode() && EmiConfig.deleteCursorStack.matchesMouse(button) && EmiScreenManager.deleteCursor(mx, my)) {
                boolean bl = false;
                return bl;
            }
            SidebarPanel panel = EmiScreenManager.getHoveredPanel(mx, my);
            if (draggedStack == EmiStack.EMPTY && panel != null && panel.getType() == SidebarType.CHESS) {
                EmiChess.interact(pressedStack, button);
                boolean bl = true;
                return bl;
            }
            if (!pressedStack.isEmpty()) {
                if (!draggedStack.isEmpty()) {
                    if (panel != null) {
                        ScreenSpace space = panel.getHoveredSpace(mx, my);
                        if (space != null && space.getType() == SidebarType.FAVORITES) {
                            int page = panel.page;
                            int pageSize = space.pageSize;
                            int index = Math.min(space.getClosestEdge(mx, my), EmiFavorites.favorites.size());
                            if (index + pageSize * page > EmiFavorites.favorites.size()) {
                                index = EmiFavorites.favorites.size() - pageSize * page;
                            }
                            if (index >= 0) {
                                EmiFavorites.addFavoriteAt(draggedStack, index + pageSize * page);
                                space.batcher.repopulate();
                            }
                            boolean bl = true;
                            return bl;
                        }
                        if (panel.getType() == SidebarType.CHESS) {
                            EmiChess.drop(draggedStack, EmiScreenManager.getHoveredStack(mx, my, true).getStack());
                        }
                    } else if (EmiScreenManager.client.currentScreen != null && EmiDragDropHandlers.dropStack(EmiScreenManager.client.currentScreen, draggedStack, mx, my)) {
                        boolean space = true;
                        return space;
                    }
                } else {
                    EmiStackInteraction hovered = EmiScreenManager.getHoveredStack((int)mouseX, (int)mouseY, false);
                    if (draggedStack.isEmpty() && EmiScreenManager.stackInteraction(hovered, bind -> bind.matchesMouse(button))) {
                        boolean bl = true;
                        return bl;
                    }
                }
                if (EmiScreenManager.genericInteraction(bind -> bind.matchesMouse(button))) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            pressedStack = EmiStack.EMPTY;
            draggedStack = EmiStack.EMPTY;
        }
    }

    public static boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (EmiScreenManager.isDisabled()) {
            return false;
        }
        if (draggedStack.isEmpty() && button == 0) {
            if (EmiScreenManager.client.thePlayer.inventory.getItemStack() != null) {
                return false;
            }
            EmiScreenManager.recalculate();
            EmiStackInteraction hovered = EmiScreenManager.getHoveredStack((int)mouseX, (int)mouseY, false);
            if (hovered.getStack() != pressedStack && !(pressedStack instanceof EmiFavorite.Synthetic)) {
                draggedStack = pressedStack;
            }
        }
        return false;
    }

    public static boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (EmiScreenManager.isDisabled()) {
            if (EmiConfig.toggleVisibility.matchesKey(keyCode, scanCode)) {
                EmiScreenManager.toggleVisibility(true);
                return true;
            }
            return false;
        }
        if (search.keyPressed(keyCode, scanCode, modifiers) || search.isActive()) {
            return true;
        }
        if (EmiScreenManager.hasFocusedTextField(EmiScreenManager.client.currentScreen, 10)) {
            return false;
        }
        if (EmiConfig.cheatMode && Minecraft.inDevMode() && EmiConfig.deleteCursorStack.matchesKey(keyCode, scanCode) && EmiScreenManager.deleteCursor(lastMouseX, lastMouseY)) {
            return true;
        }
        if (EmiInput.isControlDown() && keyCode == 21) {
            EmiApi.displayAllRecipes();
            return true;
        }
        EmiScreenManager.recalculate();
        if (EmiScreenManager.stackInteraction(EmiScreenManager.getHoveredStack(lastMouseX, lastMouseY, true), bind -> bind.matchesKey(keyCode, scanCode))) {
            return true;
        }
        return EmiScreenManager.genericInteraction(bind -> bind.matchesKey(keyCode, scanCode));
    }

    private static boolean hasFocusedTextField(Object parent, int depthBail) {
        if (depthBail <= 0) {
            return false;
        }
        if (parent instanceof ParentElement) {
            ParentElement ps = (ParentElement)parent;
            for (Element element : ps.children()) {
                TextFieldWidget tfw;
                if (element instanceof TextFieldWidget && (tfw = (TextFieldWidget)element).isActive() && tfw.visible) {
                    return true;
                }
                if (!(element instanceof ParentElement)) continue;
                ParentElement p = (ParentElement)element;
                return EmiScreenManager.hasFocusedTextField(p, depthBail - 1);
            }
        } else {
            for (Field f : parent.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                if (!GuiTextField.class.isAssignableFrom(f.getType())) continue;
                try {
                    GuiTextField wtf;
                    Object object = f.get(parent);
                    if (!(object instanceof GuiTextField) || !((EMIGuiTextField)(wtf = (GuiTextField)object)).getIsEnabled() || !wtf.isFocused()) continue;
                    return true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static boolean genericInteraction(Function<EmiBind, Boolean> function) {
        if (function.apply(EmiConfig.toggleVisibility).booleanValue()) {
            EmiScreenManager.toggleVisibility(true);
            return true;
        }
        boolean searchBreak = false;
        if (function.apply(EmiConfig.focusSearch).booleanValue() && EmiScreenManager.client.currentScreen != null) {
            EmiPort.focus(search, true);
            searchBreak = true;
        }
        if (function.apply(EmiConfig.clearSearch).booleanValue()) {
            search.setText("");
            searchBreak = true;
        }
        if (searchBreak) {
            return true;
        }
        if (function.apply(EmiConfig.viewTree).booleanValue()) {
            EmiApi.viewRecipeTree();
            return true;
        }
        if (function.apply(EmiConfig.back).booleanValue()) {
            if (!EmiHistory.isEmpty()) {
                EmiHistory.pop();
                return true;
            }
        } else if (function.apply(EmiConfig.forward).booleanValue() && !EmiHistory.isForwardEmpty()) {
            EmiHistory.forward();
            return true;
        }
        return false;
    }

    public static boolean stackInteraction(EmiStackInteraction stack, Function<EmiBind, Boolean> function) {
        EmiIngredient ingredient = stack.getStack();
        EmiRecipe context = EmiApi.getRecipeContext(ingredient);
        if (!ingredient.isEmpty()) {
            SidebarEmiStackInteraction sesi;
            if (EmiConfig.editMode && stack instanceof SidebarEmiStackInteraction && (sesi = (SidebarEmiStackInteraction)stack).getType() == SidebarType.INDEX) {
                if (function.apply(EmiConfig.hideStack).booleanValue()) {
                    EmiHidden.setVisibility(sesi.getStack(), !EmiHidden.isHidden(sesi.getStack()), false);
                    return true;
                }
                if (function.apply(EmiConfig.hideStackById).booleanValue()) {
                    EmiHidden.setVisibility(sesi.getStack(), !EmiHidden.isHidden(sesi.getStack()), true);
                    return true;
                }
            }
            if (EmiScreenManager.craftInteraction(ingredient, () -> context, stack, function)) {
                return true;
            }
            if (EmiConfig.cheatMode && Minecraft.inDevMode() && ingredient.getEmiStacks().size() == 1 && stack instanceof SidebarEmiStackInteraction) {
                if (function.apply(EmiConfig.cheatOneToInventory).booleanValue()) {
                    return EmiScreenManager.give(ingredient.getEmiStacks().get(0), 1, 0);
                }
                if (function.apply(EmiConfig.cheatStackToInventory).booleanValue()) {
                    return EmiScreenManager.give(ingredient.getEmiStacks().get(0), ingredient.getEmiStacks().get(0).getItemStack().getMaxStackSize(), 0);
                }
                if (function.apply(EmiConfig.cheatOneToCursor).booleanValue()) {
                    return EmiScreenManager.give(ingredient.getEmiStacks().get(0), 1, 1);
                }
                if (function.apply(EmiConfig.cheatStackToCursor).booleanValue()) {
                    return EmiScreenManager.give(ingredient.getEmiStacks().get(0), ingredient.getEmiStacks().get(0).getItemStack().getMaxStackSize(), 1);
                }
            }
            if (function.apply(EmiConfig.viewRecipes).booleanValue()) {
                EmiApi.displayRecipes(ingredient);
                if (stack.getRecipeContext() != null) {
                    EmiApi.focusRecipe(stack.getRecipeContext());
                }
                return true;
            }
            if (function.apply(EmiConfig.viewUses).booleanValue()) {
                EmiApi.displayUses(ingredient);
                return true;
            }
            if (function.apply(EmiConfig.favorite).booleanValue()) {
                EmiFavorites.addFavorite(ingredient, stack.getRecipeContext());
                EmiScreenManager.repopulatePanels(SidebarType.FAVORITES);
                return true;
            }
            if (function.apply(EmiConfig.viewStackTree).booleanValue() && stack.getRecipeContext() != null) {
                BoM.setGoal(stack.getRecipeContext());
                EmiApi.viewRecipeTree();
                return true;
            }
            Supplier<EmiRecipe> supplier = () -> EmiUtil.getPreferredRecipe(ingredient, lastPlayerInventory, true);
            if (EmiScreenManager.craftInteraction(ingredient, supplier, stack, function)) {
                return true;
            }
        }
        return EmiScreenManager.recipeInteraction(context, function);
    }

    private static boolean craftInteraction(EmiIngredient ingredient, Supplier<EmiRecipe> contextSupplier, EmiStackInteraction stack, Function<EmiBind, Boolean> function) {
        EmiRecipe context;
        if (!(stack instanceof SidebarEmiStackInteraction)) {
            return false;
        }
        EmiFillAction action = null;
        boolean all = false;
        if (function.apply(EmiConfig.craftAllToInventory).booleanValue()) {
            action = EmiFillAction.QUICK_MOVE;
            all = true;
        } else if (function.apply(EmiConfig.craftOneToInventory).booleanValue()) {
            action = EmiFillAction.QUICK_MOVE;
        } else if (function.apply(EmiConfig.craftOneToCursor).booleanValue()) {
            action = EmiFillAction.CURSOR;
        } else if (function.apply(EmiConfig.craftAll).booleanValue()) {
            action = EmiFillAction.FILL;
            all = true;
        } else if (function.apply(EmiConfig.craftOne).booleanValue()) {
            action = EmiFillAction.FILL;
        }
        if (action != null && (context = contextSupplier.get()) != null) {
            ScreenSpace space;
            if (EmiConfig.miscraftPrevention && (space = EmiScreenManager.getHoveredSpace(lastMouseX, lastMouseY)) != null && (space.getType() == SidebarType.CRAFTABLES || space.getType() == SidebarType.CRAFT_HISTORY) && (lastHoveredCraftableOffset = space.getRawOffsetFromMouse(lastMouseX, lastMouseY)) != -1) {
                lastHoveredCraftableSturdy = lastHoveredCraftable != null;
                lastHoveredCraftable = stack;
                if (!all) {
                    lastHoveredCraftableSturdy = true;
                }
            }
            int amount = all ? Integer.MAX_VALUE : 1;
            EmiIngredient emiIngredient = stack.getStack();
            if (emiIngredient instanceof EmiFavorite.Synthetic) {
                int oc;
                EmiFavorite.Synthetic syn = (EmiFavorite.Synthetic)emiIngredient;
                int batches = (int)syn.batches;
                if (syn.getRecipe() == null && (oc = EmiUtil.getOutputCount(context, syn.getStack())) > 0) {
                    batches /= oc;
                }
                amount = Math.min(amount, batches);
            }
            if (EmiRecipeFiller.performFill(context, EmiApi.getHandledScreen(), action, amount)) {
                Minecraft.getMinecraft().sndManager.playSoundFX("random.click", 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public static boolean recipeInteraction(EmiRecipe recipe, Function<EmiBind, Boolean> function) {
        if (recipe == null) {
            return false;
        }
        if (function.apply(EmiConfig.favorite).booleanValue() && recipe.getOutputs().size() > 0) {
            EmiFavorites.addFavorite(recipe.getOutputs().get(0), recipe);
            EmiScreenManager.repopulatePanels(SidebarType.FAVORITES);
            return true;
        }
        if (function.apply(EmiConfig.copyId).booleanValue()) {
            Minecraft.getMinecraft().sndManager.playSoundFX("random.click", 1.0f, 1.0f);
            StringSelection ss = new StringSelection("" + recipe.getId());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
            return true;
        }
        return false;
    }

    public static void toggleVisibility(boolean notify) {
        EmiConfig.enabled = !EmiConfig.enabled;
        EmiConfig.writeConfig();
    }

    private static boolean give(EmiStack stack, int amount, int mode) {
        if (ItemStacks.isEmpty(stack.getItemStack())) {
            return false;
        }
        ItemStack is = stack.getItemStack().copy();
        is.stackSize = amount;
        if (mode == 1 && EmiScreenManager.client.thePlayer.capabilities.isCreativeMode && EmiScreenManager.client.currentScreen instanceof GuiContainerCreative) {
            EmiScreenManager.client.thePlayer.inventory.setItemStack(is);
            return true;
        }
        if (EmiClient.onServer) {
            EmiNetwork.sendToServer(new CreateItemC2SPacket(mode, is));
            return true;
        }
        if (!ItemStacks.isEmpty(is)) {
            int id = is.itemID;
            String command = "/give @s " + id;
            if ((command = command + " " + amount).length() < 256) {
                ((EMIPlayerControllerMP)EmiScreenManager.client.playerController).getNetClientHandler().addToSendQueue((Packet)new Packet3Chat(command));
                return true;
            }
        }
        return false;
    }

    private static boolean deleteCursor(int mx, int my) {
        GuiScreen guiScreen = EmiScreenManager.client.currentScreen;
        if (guiScreen instanceof GuiContainer) {
            GuiContainer handled = (GuiContainer)guiScreen;
            ItemStack cursor = EmiScreenManager.client.thePlayer.inventory.getItemStack();
            ScreenSpace space = EmiScreenManager.getHoveredSpace(mx, my);
            if (!ItemStacks.isEmpty(cursor) && space != null && space.getType() == SidebarType.INDEX) {
                EmiScreenManager.client.thePlayer.inventory.setItemStack(null);
                EmiNetwork.sendToServer(new CreateItemC2SPacket(1, null));
                return true;
            }
        }
        return false;
    }

    static {
        panels = List.of(new SidebarPanel(SidebarSide.LEFT, EmiConfig.leftSidebarPages), new SidebarPanel(SidebarSide.RIGHT, EmiConfig.rightSidebarPages), new SidebarPanel(SidebarSide.TOP, EmiConfig.topSidebarPages), new SidebarPanel(SidebarSide.BOTTOM, EmiConfig.bottomSidebarPages));
        lastPlayerInventorySync = 0L;
        pressedStack = EmiStack.EMPTY;
        draggedStack = EmiStack.EMPTY;
        lastHoveredCraftable = null;
        lastHoveredCraftableSturdy = false;
        lastHoveredCraftableOffset = -1;
        scrollAcc = 0.0;
        scaledResolution = new ScaledResolution(EmiScreenManager.client.gameSettings, EmiScreenManager.client.displayWidth, EmiScreenManager.client.displayHeight);
        screenWidth = scaledResolution.getScaledWidth();
        screenHeight = scaledResolution.getScaledHeight();
        search = new EmiSearchWidget(EmiScreenManager.client.fontRenderer, screenWidth / 2 - 80, screenHeight - 21, 160, 18);
        emi = new SizedButtonWidget(2, screenHeight - 22, 20, 20, 204, 0, () -> true, w -> client.displayGuiScreen((GuiScreen)new ConfigScreen(EmiScreenManager.client.currentScreen)), List.of(EmiPort.translatable("tooltip.emi.config", EmiRenderHelper.getEmiText())));
        tree = new SizedButtonWidget(24, screenHeight - 22, 20, 20, 184, 0, () -> true, w -> EmiApi.viewRecipeTree(), List.of(EmiPort.translatable("tooltip.emi.recipe_tree")));
    }

    public static class SidebarPanel {
        public final SizedButtonWidget pageLeft;
        public final SizedButtonWidget pageRight;
        public final SidebarButtonWidget cycle;
        public final SidebarPages pages;
        public final SidebarSide side;
        public List<ScreenSpace> spaces;
        public ScreenSpace space;
        public SidebarTheme theme;
        public boolean header;
        public int sidebarPage;
        public int page;

        public SidebarPanel(SidebarSide side, SidebarPages pages) {
            this.side = side;
            this.pages = pages;
            this.pageLeft = new SizedButtonWidget(0, 0, 16, 16, 224, 0, this::hasMultiplePages, w -> this.scroll(-1));
            this.pageRight = new SizedButtonWidget(0, 0, 16, 16, 240, 0, this::hasMultiplePages, w -> this.scroll(1));
            this.cycle = new SidebarButtonWidget(0, 0, 16, 16, this);
        }

        public void setSpaces(ScreenSpace main, List<ScreenSpace> subpanels) {
            this.space = main;
            this.spaces = Stream.concat(Stream.of(main), subpanels.stream()).collect(Collectors.toList());
        }

        public List<ScreenSpace> getSpaces() {
            if (this.spaces == null) {
                return List.of();
            }
            return this.spaces;
        }

        public ScreenSpace getHoveredSpace(int mouseX, int mouseY) {
            for (ScreenSpace space : this.getSpaces()) {
                if (!space.containsNotExcluded(mouseX, mouseY)) continue;
                return space;
            }
            return null;
        }

        public SidebarType getType() {
            if (this.sidebarPage >= 0 && this.sidebarPage < this.pages.pages.size()) {
                return this.pages.pages.get((int)this.sidebarPage).type;
            }
            return SidebarType.NONE;
        }

        public boolean supportsType(SidebarType type) {
            for (SidebarPages.SidebarPage page : this.pages.pages) {
                if (page.type != type) continue;
                return true;
            }
            return false;
        }

        public void setSidebarPage(int page) {
            if (page == this.sidebarPage) {
                return;
            }
            boolean forceRecalculate = this.getType() == SidebarType.CHESS;
            this.sidebarPage = page;
            if ((forceRecalculate |= this.getType() == SidebarType.CHESS) && EmiScreenManager.client.currentScreen != null) {
                lastWidth = -1;
                EmiScreenManager.recalculate();
            }
            if (this.isSearch()) {
                EmiSearch.search(search.getText());
            }
            if (this.space != null) {
                this.space.batcher.repopulate();
            }
        }

        public void setType(SidebarType type) {
            for (int i = 0; i < this.pages.pages.size(); ++i) {
                SidebarPages.SidebarPage page = this.pages.pages.get(i);
                if (page.type != type) continue;
                this.setSidebarPage(i);
            }
        }

        public void cycleType(int amount) {
            int page = this.sidebarPage + amount;
            if (page >= this.pages.pages.size()) {
                page = 0;
            } else if (page < 0) {
                page = Math.max(this.pages.pages.size() - 1, 0);
            }
            this.setSidebarPage(page);
        }

        public void render(EmiDrawContext context, int mouseX, int mouseY, float delta) {
            if (this.space == null) {
                return;
            }
            try {
                this.cycleType(0);
                if (this.getType() == SidebarType.CHESS) {
                    EmiChess.get().update();
                    if (this.space.tw != 8 || this.space.th != 8) {
                        this.cycleType(1);
                    }
                }
                if (this.isVisible()) {
                    EmiScreenManager.client.mcProfiler.endStartSection(this.side.getName());
                    context.push();
                    context.matrices().translate(0.0, 0.0, 100.0);
                    this.pageLeft.render(context.raw(), mouseX, mouseY, delta);
                    this.cycle.render(context.raw(), mouseX, mouseY, delta);
                    this.pageRight.render(context.raw(), mouseX, mouseY, delta);
                    context.pop();
                    int totalPages = (this.space.getStacks().size() - 1) / this.space.pageSize + 1;
                    this.wrapPage();
                    this.drawHeader(context, mouseX, mouseY, delta, this.page, totalPages);
                    for (ScreenSpace space : this.getSpaces()) {
                        if (space == this.space) {
                            space.render(context, mouseX, mouseY, delta, space.pageSize * this.page);
                            continue;
                        }
                        space.render(context, mouseX, mouseY, delta, 0);
                    }
                }
            }
            catch (Exception e) {
                EmiLog.error("Error rendering sidebar", e);
                this.drawError(context, mouseX, mouseY, delta);
            }
        }

        private void drawBackground(EmiDrawContext context, int mouseX, int mouseY, float delta) {
            if (this.space == null) {
                return;
            }
            try {
                this.cycleType(0);
                if (this.getType() == SidebarType.CHESS && (this.space.tw != 8 || this.space.th != 8)) {
                    this.cycleType(1);
                }
                if (this.isVisible()) {
                    int headerOffset;
                    RenderSystem.enableDepthTest();
                    context.resetColor();
                    int n = headerOffset = this.header ? 18 : 0;
                    if (this.theme == SidebarTheme.VANILLA) {
                        int totalHeight = 18 + headerOffset;
                        for (ScreenSpace space : this.getSpaces()) {
                            totalHeight += space.th * 18 + 3;
                        }
                        EmiRenderHelper.drawNinePatch(context, EmiRenderHelper.BACKGROUND, this.space.tx - 9, this.space.ty - 9 - headerOffset, this.space.tw * 18 + 18, totalHeight, 0, 32, 8, 1);
                    } else if (this.theme == SidebarTheme.MODERN) {
                        int offset = 2;
                        for (ScreenSpace space : this.getSpaces()) {
                            RenderSystem.enableBlend();
                            context.drawTexture(EmiRenderHelper.GRID, space.tx, space.ty, space.tw * 18, space.th * 18, 0.0f, 0.0f, space.tw, space.th, 2, offset);
                            if (space.th % 2 == 1) {
                                offset *= -1;
                            }
                            RenderSystem.disableBlend();
                        }
                    }
                    for (ScreenSpace space : this.getSpaces()) {
                        if (space == this.space) continue;
                        context.drawTexture(EmiRenderHelper.DASH, space.tx + 1, space.ty - 2, space.tw * 18, 1, 0.0f, 0.0f, space.tw * 18, 1, 6, 1);
                    }
                }
            }
            catch (Exception e) {
                EmiLog.error("Error rendering sidebar background", e);
                this.drawError(context, mouseX, mouseY, delta);
            }
        }

        private void drawError(EmiDrawContext context, int mouseX, int mouseY, float delta) {
            try {
                Bounds bounds = this.getBounds();
                int color = -65536;
                int border = 4;
                context.fill(bounds.left(), bounds.top(), bounds.width(), border, color);
                context.fill(bounds.left(), bounds.bottom() - border, bounds.width(), border, color);
                context.fill(bounds.left(), bounds.top(), border, bounds.height(), color);
                context.fill(bounds.right() - border, bounds.top(), border, bounds.height(), color);
                int cx = (bounds.left() + bounds.right()) / 2;
                int cy = (bounds.top() + bounds.bottom()) / 2;
                context.drawCenteredText(EmiPort.literal("Render Error"), cx, cy - 6, color);
                context.drawCenteredText(EmiPort.literal("See Log"), cx, cy + 6, color);
            }
            catch (Exception e) {
                EmiLog.error("Critical error rendering sidebar", e);
            }
        }

        private void drawHeader(EmiDrawContext context, int mouseX, int mouseY, float delta, int page, int totalPages) {
            if (this.header) {
                Text text = EmiRenderHelper.getPageText(page + 1, totalPages, (this.space.tw - 3) * 18);
                int x = this.space.tx + this.space.tw * 18 / 2;
                int maxLeft = (this.space.tw - 2) * 18 / 2 - 18;
                int w = EmiScreenManager.client.fontRenderer.getStringWidth(text.asString()) / 2;
                if (w > maxLeft) {
                    x += w - maxLeft;
                }
                context.drawCenteredText(text, x, this.space.ty - 15);
                if (totalPages > 1 && this.space.tw > 2) {
                    int scrollLeft = this.space.tx + 18;
                    int scrollWidth = this.space.tw * 18 - 36;
                    int scrollY = this.space.ty - 4;
                    context.fill(scrollLeft, scrollY, scrollWidth, 2, 0x55555555);
                    EmiRenderHelper.drawScroll(context, scrollLeft, scrollY, scrollWidth, 2, page, totalPages, -1);
                }
            }
        }

        private void wrapPage() {
            int totalPages = (this.space.getStacks().size() - 1) / this.space.pageSize + 1;
            if (this.page >= totalPages) {
                this.page = 0;
                this.space.batcher.repopulate();
            } else if (this.page < 0) {
                this.page = totalPages - 1;
                this.space.batcher.repopulate();
            }
        }

        public boolean isSearch() {
            return this.side == EmiConfig.searchSidebar;
        }

        public void updateWidgetPosition() {
            if (this.space == null) {
                return;
            }
            this.pageLeft.x = this.space.tx;
            this.pageLeft.y = this.space.ty - 18;
            this.pageRight.x = this.space.tx + this.space.tw * 18 - 16;
            this.pageRight.y = this.pageLeft.y;
            this.cycle.x = this.space.tx + 18;
            this.cycle.y = this.pageLeft.y - 1;
        }

        public boolean isVisible() {
            if (this.space == null) {
                return false;
            }
            if (this.getType() == SidebarType.CHESS && (this.space.tw != 8 || this.space.th != 8)) {
                return false;
            }
            return !EmiScreenManager.isDisabled() && this.space.pageSize > 0 && this.pages.pages.size() > 0;
        }

        public void updateWidgetVisibility() {
            boolean visible;
            this.pageLeft.visible = visible = this.header && this.isVisible();
            this.cycle.visible = visible;
            this.pageRight.visible = visible;
        }

        public boolean hasMultiplePages() {
            return this.space != null && this.space.getStacks().size() > this.space.pageSize;
        }

        public void scroll(int delta) {
            if (this.space == null) {
                return;
            }
            if (this.space.pageSize == 0) {
                return;
            }
            this.page += delta;
            int pageSize = this.space.pageSize;
            int totalPages = (this.space.getStacks().size() - 1) / pageSize + 1;
            if (totalPages <= 1) {
                return;
            }
            if (this.page >= totalPages) {
                this.page = 0;
            } else if (this.page < 0) {
                this.page = totalPages - 1;
            }
            this.space.batcher.repopulate();
        }

        public Bounds getBounds() {
            List<ScreenSpace> spaces = this.getSpaces();
            if (this.space == null || spaces.isEmpty()) {
                return Bounds.EMPTY;
            }
            int headerOffset = this.header ? 18 : 0;
            ScreenSpace end = this.getSpaces().get(this.getSpaces().size() - 1);
            return new Bounds(this.space.tx - this.theme.horizontalPadding, this.space.ty - this.theme.verticalPadding - headerOffset, this.space.tw * 18 + this.theme.horizontalPadding * 2, end.ty - this.space.ty + end.th * 18 + this.theme.verticalPadding * 2 + headerOffset);
        }
    }

    public static class ScreenSpace {
        public final StackBatcher batcher = new StackBatcher();
        private final Supplier<SidebarType> typeSupplier;
        public final int tx;
        public final int ty;
        public final int tw;
        public final int th;
        public final int pageSize;
        public final boolean rtl;
        public final int[] widths;
        public final boolean search;

        public ScreenSpace(int tx, int ty, int tw, int th, boolean rtl, List<Bounds> exclusion, Supplier<SidebarType> typeSupplier, boolean search) {
            this.tx = tx;
            this.ty = ty;
            this.tw = tw;
            this.th = th;
            this.rtl = rtl;
            this.typeSupplier = typeSupplier;
            this.search = search;
            int[] widths = new int[th];
            int pageSize = 0;
            for (int y = 0; y < th; ++y) {
                int width = 0;
                int cy = ty + y * 18;
                block1: for (int x = 0; x < tw; ++x) {
                    int cx = tx + (rtl ? tw - 1 - x : x) * 18;
                    int rx = cx + 18 - 1;
                    int ry = cy + 18 - 1;
                    for (Bounds rect : exclusion) {
                        if (!rect.contains(cx, cy) && !rect.contains(rx, cy) && !rect.contains(cx, ry) && !rect.contains(rx, ry)) continue;
                        break block1;
                    }
                    ++width;
                }
                widths[y] = width;
                pageSize += width;
            }
            this.pageSize = pageSize;
            this.widths = widths;
        }

        public List<? extends EmiIngredient> getStacks() {
            if (this.search && this.getType() != SidebarType.CHESS) {
                return searchedStacks;
            }
            return EmiSidebars.getStacks(this.getType());
        }

        public List<? extends EmiIngredient> getPage(int page) {
            int start = page * this.pageSize;
            List<? extends EmiIngredient> stacks = this.getStacks();
            int end = Math.min(start + this.pageSize, stacks.size());
            if (end > start) {
                return stacks.subList(start, end);
            }
            return List.of();
        }

        public SidebarType getType() {
            return this.typeSupplier.get();
        }

        public void render(EmiDrawContext context, int mouseX, int mouseY, float delta, int startIndex) {
            if (this.pageSize > 0) {
                GL11.glEnable((int)2929);
                EmiPort.setPositionTexShader();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int hx = -1;
                int hy = -1;
                this.batcher.begin(0, 0, 0);
                int i = startIndex;
                List<? extends EmiIngredient> stacks = this.getStacks();
                int hovered = this.getRawOffsetFromMouse(mouseX, mouseY);
                if (hovered != -1 && EmiConfig.showHoverOverlay && startIndex + hovered < stacks.size()) {
                    hx = this.getRawX(hovered);
                    hy = this.getRawY(hovered);
                    EmiRenderHelper.drawSlotHightlight(context, hx, hy, 18, 18);
                }
                context.push();
                context.matrices().translate(0.0, 0.0, 100.0);
                block0: for (int yo = 0; yo < this.th; ++yo) {
                    for (int xo = 0; xo < this.getWidth(yo); ++xo) {
                        if (i >= stacks.size()) break block0;
                        int cx = this.getX(xo, yo);
                        int cy = this.getY(xo, yo);
                        EmiIngredient stack = stacks.get(i++);
                        this.batcher.render(stack, context.raw(), cx + 1, cy + 1, delta);
                        if (this.getType() != SidebarType.INDEX) continue;
                        if (EmiConfig.editMode) {
                            if (!EmiHidden.isHidden(stack)) continue;
                            GL11.glEnable((int)2929);
                            context.fill(cx, cy, 18, 18, 0x33FF0000);
                            continue;
                        }
                        if (!EmiConfig.highlightDefaulted || BoM.getRecipe(stack) == null) continue;
                        GL11.glEnable((int)2929);
                        context.fill(cx, cy, 18, 18, 0x3300FF00);
                    }
                }
                this.batcher.draw();
                context.pop();
            }
        }

        public int getWidth(int y) {
            return this.widths[y];
        }

        public int getX(int x, int y) {
            return this.tx + (this.rtl ? x + this.tw - this.getWidth(y) : x) * 18;
        }

        public int getY(int x, int y) {
            return this.ty + y * 18;
        }

        public int getEdgeX(int off) {
            int t = 0;
            int y = 0;
            while (y < this.th && t + this.getWidth(y) < off) {
                t += this.getWidth(y++);
            }
            return this.getX(off - t, y);
        }

        public int getEdgeY(int off) {
            int t = 0;
            int y = 0;
            while (y < this.th && t + this.getWidth(y) < off) {
                t += this.getWidth(y++);
            }
            return this.ty + y * 18;
        }

        public int getRawX(int off) {
            int t = 0;
            int y = 0;
            while (y < this.th && t + this.getWidth(y) <= off) {
                t += this.getWidth(y++);
            }
            return this.getX(off - t, y);
        }

        public int getRawY(int off) {
            int t = 0;
            int y = 0;
            while (y < this.th && t + this.getWidth(y) <= off) {
                t += this.getWidth(y++);
            }
            return this.ty + y * 18;
        }

        public int getClosestEdge(int x, int y) {
            if (y < this.ty) {
                return 0;
            }
            if (y >= this.ty + this.th * 18) {
                return this.pageSize;
            }
            x = (x - this.tx) / 18;
            y = (y - this.ty) / 18;
            int off = 0;
            for (int i = 0; i < y; ++i) {
                off += this.widths[i];
            }
            if (x < 0) {
                return y;
            }
            if (x >= this.widths[y]) {
                return y + this.widths[y];
            }
            if (this.rtl) {
                int to = this.tw - this.widths[y];
                if (x >= to) {
                    off += x - to;
                }
            } else {
                off = x < this.widths[y] ? (off += x) : (off += this.widths[y]);
            }
            return off;
        }

        public int getRawOffsetFromMouse(int mouseX, int mouseY) {
            if (mouseX < this.tx || mouseY < this.ty) {
                return -1;
            }
            return this.getRawOffset((mouseX - this.tx) / 18, (mouseY - this.ty) / 18);
        }

        public int getRawOffset(int x, int y) {
            if (x >= 0 && y >= 0 && x < this.tw && y < this.th) {
                int off = 0;
                for (int i = 0; i < y; ++i) {
                    off += this.widths[i];
                }
                if (this.rtl) {
                    int to = this.tw - this.widths[y];
                    if (x >= to) {
                        return off + x - to;
                    }
                } else if (x < this.widths[y]) {
                    return off + x;
                }
            }
            return -1;
        }

        public boolean contains(int x, int y) {
            return x >= this.tx && x < this.tx + this.tw * 18 && y >= this.ty && y < this.ty + this.th * 18;
        }

        public boolean containsNotExcluded(int x, int y) {
            if (this.contains(lastMouseX, lastMouseY)) {
                for (Bounds bounds : EmiExclusionAreas.getExclusion(EmiScreenManager.client.currentScreen)) {
                    if (!bounds.contains(x, y)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class SidebarEmiStackInteraction
    extends EmiStackInteraction {
        public final ScreenSpace space;

        public SidebarEmiStackInteraction(EmiIngredient stack, ScreenSpace space) {
            super(stack);
            this.space = space;
        }

        public SidebarEmiStackInteraction(EmiIngredient stack, ScreenSpace space, EmiRecipe recipe, boolean clickable) {
            super(stack, recipe, clickable);
            this.space = space;
        }

        public SidebarType getType() {
            return this.space.getType();
        }
    }
}

