/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.com.unascribed.qdcss.QDCSS;
import dev.emi.emi.config.ConfigEnum;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.IntGroup;
import dev.emi.emi.config.ScreenAlign;
import dev.emi.emi.config.SidebarPages;
import dev.emi.emi.config.SidebarSubpanels;
import dev.emi.emi.input.EmiBind;
import dev.emi.emi.input.EmiInput;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.ConfigPresetScreen;
import dev.emi.emi.screen.widget.SizedButtonWidget;
import dev.emi.emi.screen.widget.config.BooleanWidget;
import dev.emi.emi.screen.widget.config.ConfigEntryWidget;
import dev.emi.emi.screen.widget.config.ConfigJumpButton;
import dev.emi.emi.screen.widget.config.ConfigSearch;
import dev.emi.emi.screen.widget.config.EmiBindWidget;
import dev.emi.emi.screen.widget.config.EmiNameWidget;
import dev.emi.emi.screen.widget.config.EnumWidget;
import dev.emi.emi.screen.widget.config.GroupNameWidget;
import dev.emi.emi.screen.widget.config.IntGroupWidget;
import dev.emi.emi.screen.widget.config.IntWidget;
import dev.emi.emi.screen.widget.config.ListWidget;
import dev.emi.emi.screen.widget.config.ScreenAlignWidget;
import dev.emi.emi.screen.widget.config.SidebarPagesWidget;
import dev.emi.emi.screen.widget.config.SidebarSubpanelsWidget;
import dev.emi.emi.screen.widget.config.SubGroupNameWidget;
import dev.emi.emi.search.EmiSearch;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.GuiScreen;
import net.minecraft.Minecraft;
import net.minecraft.StringTranslate;
import shims.java.com.unascribed.retroemi.REMIScreen;
import shims.java.com.unascribed.retroemi.RetroEMI;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.Element;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.client.gui.widget.ButtonWidget;
import shims.java.net.minecraft.client.gui.widget.TextFieldWidget;
import shims.java.net.minecraft.client.util.InputUtil;
import shims.java.net.minecraft.text.MutableText;
import shims.java.net.minecraft.text.Text;

public class ConfigScreen
extends REMIScreen {
    private static final int maxWidth = 240;
    private GuiScreen last;
    private ConfigSearch search;
    public ListWidget list;
    public EmiBind activeBind;
    public int activeBindOffset;
    public int activeModifiers;
    public int lastModifier;
    public String originalConfig;
    public ButtonWidget resetButton;

    public ConfigScreen(GuiScreen last) {
        super(EmiPort.translatable("screen.emi.config"));
        this.last = last;
        this.originalConfig = EmiConfig.getSavedConfig();
    }

    public void setActiveBind(EmiBind bind, int offset) {
        this.activeBind = bind;
        this.activeBindOffset = offset;
        this.activeModifiers = 0;
        this.lastModifier = 0;
    }

    @Override
    public void close() {
        EmiConfig.writeConfig();
        EmiSearch.update();
        Minecraft.getMinecraft().displayGuiScreen(this.last);
    }

    public static List<TooltipComponent> getFieldTooltip(Field field) {
        EmiConfig.ConfigValue annot = field.getAnnotation(EmiConfig.ConfigValue.class);
        String key = "config.emi.tooltip." + annot.value().replace('-', '_');
        EmiConfig.Comment comment = field.getAnnotation(EmiConfig.Comment.class);
        List<TooltipComponent> text = StringTranslate.getInstance().containsTranslateKey(key) ? Arrays.stream(RetroEMI.translate(key).split("\n")).map(EmiPort::literal).map(EmiTooltipComponents::of).toList() : (comment != null ? Arrays.stream(comment.value().split("\n")).map(EmiPort::literal).map(EmiTooltipComponents::of).toList() : null);
        if (text == null) {
            return List.of();
        }
        return text;
    }

    @Override
    protected void init() {
        super.init();
        int scroll = 0;
        String query = "";
        HashSet collapsed = Sets.newHashSet();
        if (this.list != null) {
            scroll = (int)this.list.getScrollAmount();
            query = this.search.getSearch();
            for (ListWidget.Entry e : this.list.children()) {
                if (!(e instanceof GroupNameWidget)) continue;
                GroupNameWidget g = (GroupNameWidget)e;
                if (!g.collapsed) continue;
                collapsed.add(g.text.getString());
            }
        }
        this.list = new ListWidget(this.client, this.width, this.height, 40, this.height - 60);
        this.addDrawable(new EmiNameWidget(this.width / 2, 16));
        int w = Math.min(400, this.width - 40) / 4 * 4;
        int x = (this.width - w) / 2;
        this.search = new ConfigSearch(x + 3, this.height - 51, w / 2 - 4, 18);
        this.addDrawable(this.search.field);
        this.resetButton = EmiPort.newButton(x + 2, this.height - 30, w / 2 - 2, 20, EmiPort.translatable("gui.done"), button -> {
            EmiConfig.loadConfig(QDCSS.load("revert", this.originalConfig));
            Minecraft client = Minecraft.getMinecraft();
            this.setWorldAndResolution(client, this.width, this.height);
        });
        this.addDrawableChild(EmiPort.newButton(x + w / 2 + 2, this.height - 30, w / 2 - 2, 20, EmiPort.translatable("gui.done"), button -> this.close()));
        this.addDrawableChild(EmiPort.newButton(x + w / 2 + 2, this.height - 52, w / 2 - 24, 20, EmiPort.translatable("screen.emi.presets"), button -> {
            Minecraft client = Minecraft.getMinecraft();
            client.displayGuiScreen((GuiScreen)new ConfigPresetScreen(this));
        }));
        this.addDrawableChild(new SizedButtonWidget(x + w - 20, this.height - 52, 20, 20, 164, 0, () -> true, widget -> {
            EmiConfig.setGlobalState(!EmiConfig.useGlobalConfig);
            this.setWorldAndResolution(this.client, this.width, this.height);
        }, () -> EmiConfig.useGlobalConfig ? 40 : 0, () -> Arrays.stream(RetroEMI.translate("tooltip.emi.config.global").split("\n")).flatMap(s -> this.client.fontRenderer.listFormattedStringToWidth(s, 240).stream().map(str -> Text.literal((String)str))).collect(Collectors.toList())));
        this.addDrawableChild(this.resetButton);
        this.addSelectableChild(this.search.field);
        try {
            String lastGroup = "";
            GroupNameWidget lastGroupWidget = null;
            EmiConfig.ConfigGroup currentGroup = null;
            SubGroupNameWidget currentSubGroupWidget = null;
            Supplier<String> searchSupplier = () -> this.search.getSearch();
            for (final Field field : EmiConfig.class.getFields()) {
                boolean endGroup;
                EmiConfig.ConfigGroup configGroup;
                String group;
                EmiConfig.ConfigValue annot = field.getAnnotation(EmiConfig.ConfigValue.class);
                if (annot == null || (group = annot.value().split("\\.")[0]).equals("persistent")) continue;
                if (!group.equals(lastGroup)) {
                    lastGroup = group;
                    MutableText text = EmiPort.translatable("config.emi.group." + group.replace('-', '_'));
                    lastGroupWidget = new GroupNameWidget(group, text);
                    if (collapsed.contains(text.getString())) {
                        lastGroupWidget.collapsed = true;
                    }
                    this.list.addEntry(lastGroupWidget);
                }
                if ((configGroup = field.getAnnotation(EmiConfig.ConfigGroup.class)) != null) {
                    currentGroup = configGroup;
                    MutableText text = EmiPort.translatable("config.emi.group." + configGroup.value().replace('-', '_'));
                    currentSubGroupWidget = new SubGroupNameWidget(configGroup.value(), text);
                    if (collapsed.contains(text.getString())) {
                        currentSubGroupWidget.collapsed = true;
                    }
                    currentSubGroupWidget.parent = lastGroupWidget;
                    this.list.addEntry(currentSubGroupWidget);
                }
                Predicate<Object> predicate = EmiConfig.FILTERS.getOrDefault(annot.value(), v -> true);
                MutableText translation = EmiPort.translatable("config.emi." + annot.value().replace('-', '_'));
                ConfigEntryWidget entry = null;
                if (field.getType() == Boolean.TYPE) {
                    entry = new BooleanWidget((Text)translation, ConfigScreen.getFieldTooltip(field), searchSupplier, new Mutator<Boolean>(){

                        @Override
                        public Boolean getValue() {
                            try {
                                return field.getBoolean(null);
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }

                        @Override
                        public void setValue(Boolean value) {
                            try {
                                field.setBoolean(null, value);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                } else if (field.getType() == Integer.TYPE) {
                    entry = new IntWidget((Text)translation, ConfigScreen.getFieldTooltip(field), searchSupplier, new Mutator<Integer>(){

                        @Override
                        public Integer getValue() {
                            try {
                                return field.getInt(null);
                            }
                            catch (Exception exception) {
                                return -1;
                            }
                        }

                        @Override
                        public void setValue(Integer value) {
                            try {
                                field.setInt(null, value);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                } else if (field.getType() == EmiBind.class) {
                    entry = new EmiBindWidget(this, ConfigScreen.getFieldTooltip(field), searchSupplier, (EmiBind)field.get(null));
                } else if (field.getType() == ScreenAlign.class) {
                    entry = new ScreenAlignWidget((Text)translation, ConfigScreen.getFieldTooltip(field), searchSupplier, this.objectMutator(field));
                } else if (field.getType() == SidebarPages.class) {
                    entry = new SidebarPagesWidget((Text)translation, ConfigScreen.getFieldTooltip(field), searchSupplier, this.objectMutator(field));
                } else if (field.getType() == SidebarSubpanels.class) {
                    entry = new SidebarSubpanelsWidget((Text)translation, ConfigScreen.getFieldTooltip(field), searchSupplier, this.objectMutator(field));
                } else if (IntGroup.class.isAssignableFrom(field.getType())) {
                    entry = new IntGroupWidget((Text)translation, ConfigScreen.getFieldTooltip(field), searchSupplier, this.objectMutator(field));
                } else if (ConfigEnum.class.isAssignableFrom(field.getType())) {
                    entry = new EnumWidget(translation, ConfigScreen.getFieldTooltip(field), searchSupplier, this.objectMutator(field), predicate);
                }
                boolean bl = endGroup = field.getAnnotation(EmiConfig.ConfigGroupEnd.class) != null;
                if (entry != null) {
                    entry.group = currentGroup;
                    entry.endGroup = endGroup;
                    this.list.addEntry(entry);
                    if (lastGroupWidget != null) {
                        lastGroupWidget.children.add(entry);
                        entry.parentGroups.add(lastGroupWidget);
                    }
                    if (currentSubGroupWidget != null) {
                        currentSubGroupWidget.children.add(entry);
                        entry.parentGroups.add(currentSubGroupWidget);
                    }
                }
                if (!endGroup) continue;
                currentGroup = null;
                currentSubGroupWidget = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addSelectableChild(this.list);
        this.list.setScrollAmount(scroll);
        this.search.setText(query);
        this.addJumpButtons();
        this.updateChanges();
    }

    private void addJumpButtons() {
        ArrayList jumps = Lists.newArrayList((Object[])new String[]{"general", "general.search", "ui", "ui.left-sidebar", "ui.right-sidebar", "ui.top-sidebar", "ui.bottom-sidebar", "binds", "binds.crafts", "binds.cheats", "dev", "addon"});
        List<List<String>> removes = List.of(List.of("addon.distraction"), List.of("binds.cheats"), List.of("general.search"), List.of("ui.top-sidebar", "ui.bottom-sidebar"), List.of("binds.crafts"), List.of("ui.left-sidebar", "ui.right-sidebar"));
        int space = this.list.getLogicalHeight() - 10;
        for (List<String> r : removes) {
            if (jumps.size() * 16 <= space) continue;
            jumps.removeAll(r);
        }
        int y = 40 + (this.list.getLogicalHeight() - jumps.size() * 16) / 2;
        int u = 0;
        int v = -16;
        for (String s : jumps) {
            boolean newGroup;
            boolean bl = newGroup = !s.contains(".");
            if (newGroup) {
                v += 16;
                u = 0;
            } else {
                u += 16;
            }
            this.addDrawableChild(new ConfigJumpButton(2 + (newGroup ? 0 : 8), y, u, v, w -> this.jump(s), List.of(EmiPort.translatable("config.emi.group." + s.replace('-', '_')))));
            y += 16;
        }
    }

    public void jump(String jump) {
        for (ListWidget.Entry e : this.list.children()) {
            if (!(e instanceof ConfigEntryWidget)) continue;
            ConfigEntryWidget c = (ConfigEntryWidget)e;
            for (GroupNameWidget p : c.parentGroups) {
                if (!p.id.equals(jump)) continue;
                this.list.centerScrollOn(e);
                return;
            }
        }
    }

    public <T> Mutator<T> objectMutator(final Field field) {
        return new Mutator<T>(){

            @Override
            public T getValue() {
                try {
                    return field.get(null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void setValue(T en) {
                try {
                    field.set(null, en);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void updateChanges() {
        String[] oLines = this.originalConfig.split("\n\n");
        String[] cLines = EmiConfig.getSavedConfig().split("\n\n");
        int different = 0;
        for (int i = 0; i < oLines.length && i < cLines.length; ++i) {
            if (oLines[i].equals(cLines[i])) continue;
            ++different;
        }
        this.resetButton.active = different > 0;
        this.resetButton.setMessage(EmiPort.translatable("screen.emi.config.reset", different));
    }

    @Override
    public void render(DrawContext raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        this.list.setScrollAmount(this.list.getScrollAmount());
        this.renderBackgroundTexture(context.raw());
        this.list.render(context.raw(), mouseX, mouseY, delta);
        super.render(context.raw(), mouseX, mouseY, delta);
        if (this.list.getHoveredEntry() != null) {
            EmiRenderHelper.drawTooltip(this, context, this.list.getHoveredEntry().getTooltip(mouseX, mouseY), mouseX, mouseY, Math.min(this.width / 2 - 16, 240));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.activeBind != null) {
            this.pushModifier(0);
            this.activeBind.setBind(this.activeBindOffset, new EmiBind.ModifiedKey(InputUtil.Type.MOUSE.createFromCode(button), this.activeModifiers));
            this.activeBind = null;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void pushModifier(int lastModifier) {
        this.activeModifiers |= EmiInput.maskFromCode(this.lastModifier);
        this.lastModifier = lastModifier;
        this.activeModifiers &= ~EmiInput.maskFromCode(lastModifier);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        TextFieldWidget tfw;
        if (this.activeBind != null) {
            if (EmiInput.maskFromCode(keyCode) != 0) {
                this.pushModifier(keyCode);
            } else {
                this.pushModifier(0);
                if (keyCode == 1) {
                    this.activeBind.setBind(this.activeBindOffset, new EmiBind.ModifiedKey(InputUtil.UNKNOWN_KEY, 0));
                } else {
                    this.activeBind.setBind(this.activeBindOffset, new EmiBind.ModifiedKey(InputUtil.Type.KEYSYM.createFromCode(keyCode), this.activeModifiers));
                }
                this.activeBind = null;
                this.updateChanges();
            }
            return true;
        }
        if (keyCode == 15) {
            return false;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        Element element = this.getFocused();
        if (element instanceof TextFieldWidget && (tfw = (TextFieldWidget)element).isFocused()) {
            if (keyCode == 1) {
                EmiPort.focus(tfw, false);
                return true;
            }
        } else {
            if (keyCode == 1) {
                this.close();
                return true;
            }
            if (this.client.gameSettings.keyBindInventory.keyCode == keyCode) {
                this.close();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.activeBind != null) {
            this.activeModifiers &= ~EmiInput.maskFromCode(keyCode);
            if (keyCode == this.lastModifier) {
                this.activeBind.setBind(this.activeBindOffset, new EmiBind.ModifiedKey(InputUtil.Type.KEYSYM.createFromCode(keyCode), this.activeModifiers));
                this.activeBind = null;
            }
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    public abstract class Mutator<T> {
        protected abstract T getValue();

        protected abstract void setValue(T var1);

        public T get() {
            return this.getValue();
        }

        public void set(T value) {
            this.setValue(value);
            ConfigScreen.this.updateChanges();
        }
    }
}

