/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.com.unascribed.qdcss.QDCSS;
import dev.emi.emi.config.ConfigPresets;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.ConfigScreen;
import dev.emi.emi.screen.widget.config.EmiNameWidget;
import dev.emi.emi.screen.widget.config.ListWidget;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.GuiScreen;
import net.minecraft.Minecraft;
import shims.java.com.unascribed.retroemi.REMIScreen;
import shims.java.net.minecraft.client.gui.DrawContext;
import shims.java.net.minecraft.client.gui.Element;
import shims.java.net.minecraft.client.gui.tooltip.TooltipComponent;
import shims.java.net.minecraft.client.gui.widget.ButtonWidget;
import shims.java.net.minecraft.text.MutableText;
import shims.java.net.minecraft.text.Text;

public class ConfigPresetScreen
extends REMIScreen {
    private final ConfigScreen last;
    private ListWidget list;
    public ButtonWidget resetButton;

    public ConfigPresetScreen(ConfigScreen last) {
        super(EmiPort.translatable("screen.emi.presets"));
        this.last = last;
    }

    @Override
    public void init() {
        super.init();
        this.addDrawable(new EmiNameWidget(this.width / 2, 16));
        int w = Math.min(400, this.width - 40);
        int x = (this.width - w) / 2;
        this.resetButton = EmiPort.newButton(x + 2, this.height - 30, w / 2 - 2, 20, EmiPort.translatable("gui.done"), button -> {
            EmiConfig.loadConfig(QDCSS.load("revert", this.last.originalConfig));
            Minecraft client = Minecraft.getMinecraft();
            this.setWorldAndResolution(client, this.width, this.height);
        });
        this.addDrawableChild(this.resetButton);
        this.addDrawableChild(EmiPort.newButton(x + w / 2 + 2, this.height - 30, w / 2 - 2, 20, EmiPort.translatable("gui.done"), button -> this.close()));
        this.list = new ListWidget(this.client, this.width, this.height, 40, this.height - 40);
        try {
            for (Field field : ConfigPresets.class.getFields()) {
                MutableText translation;
                Object object;
                EmiConfig.ConfigValue config = field.getDeclaredAnnotation(EmiConfig.ConfigValue.class);
                if (config == null || !((object = field.get(null)) instanceof Runnable)) continue;
                Runnable runnable = (Runnable)object;
                EmiConfig.ConfigGroup group = field.getDeclaredAnnotation(EmiConfig.ConfigGroup.class);
                if (group != null) {
                    translation = EmiPort.translatable("config.emi." + group.value().replace('-', '_'));
                    this.list.addEntry(new PresetGroupWidget(translation));
                }
                translation = EmiPort.translatable("config.emi." + config.value().replace('-', '_'));
                this.list.addEntry(new PresetWidget(runnable, translation, ConfigScreen.getFieldTooltip(field)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addSelectableChild(this.list);
        this.updateChanges();
    }

    @Override
    public void render(DrawContext raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        this.list.setScrollAmount(this.list.getScrollAmount());
        this.renderBackgroundTexture(context.raw());
        this.list.render(context.raw(), mouseX, mouseY, delta);
        super.render(context.raw(), mouseX, mouseY, delta);
        ListWidget.Entry entry = this.list.getHoveredEntry();
        if (entry instanceof PresetWidget) {
            PresetWidget widget = (PresetWidget)entry;
            if (widget.button.isHovered()) {
                EmiRenderHelper.drawTooltip(this, context, widget.tooltip, mouseX, mouseY);
            }
        }
    }

    @Override
    public void close() {
        Minecraft.getMinecraft().displayGuiScreen((GuiScreen)this.last);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 1) {
            this.close();
            return true;
        }
        if (this.client.gameSettings.keyBindInventory.keyCode == keyCode) {
            this.close();
            return true;
        }
        if (keyCode == 15) {
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void updateChanges() {
        String[] oLines = this.last.originalConfig.split("\n\n");
        String[] cLines = EmiConfig.getSavedConfig().split("\n\n");
        int different = 0;
        for (int i = 0; i < oLines.length && i < cLines.length; ++i) {
            if (oLines[i].equals(cLines[i])) continue;
            ++different;
        }
        this.resetButton.active = different > 0;
        this.resetButton.setMessage(EmiPort.translatable("screen.emi.config.reset", different));
    }

    public class PresetGroupWidget
    extends ListWidget.Entry {
        private final Text text;

        public PresetGroupWidget(Text text) {
            this.text = text;
        }

        @Override
        public List<? extends Element> children() {
            return List.of();
        }

        @Override
        public void render(DrawContext raw, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            EmiDrawContext context = EmiDrawContext.wrap(raw);
            context.drawCenteredTextWithShadow(this.text, x + width / 2, y + 3, -1);
        }

        @Override
        public int getHeight() {
            return 20;
        }
    }

    public class PresetWidget
    extends ListWidget.Entry {
        private final ButtonWidget button;
        private final List<TooltipComponent> tooltip;

        public PresetWidget(Runnable runnable, Text name, List<TooltipComponent> tooltip) {
            this.button = EmiPort.newButton(0, 0, 200, 20, name, t -> {
                runnable.run();
                ConfigPresetScreen.this.updateChanges();
            });
            this.tooltip = tooltip;
        }

        @Override
        public List<? extends Element> children() {
            return List.of(this.button);
        }

        @Override
        public void render(DrawContext raw, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            this.button.y = y;
            this.button.x = x + width / 2 - this.button.getWidth() / 2;
            this.button.render(raw, mouseX, mouseY, delta);
        }

        @Override
        public int getHeight() {
            return 20;
        }
    }
}

